/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.debugger.jdi.JdiArrayReflective;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JdiReflective
extends Reflective {
    private ReferenceType rclass = null;
    protected String name = null;
    private ClassLoaderReference sourceLoader = null;
    private VirtualMachine sourceVM = null;

    public JdiReflective(ReferenceType rclass) {
        this.rclass = rclass;
        if (rclass == null) {
            Debug.message("JdiReflective: null ReferenceType?");
            throw new NullPointerException();
        }
    }

    public JdiReflective(String name, ReferenceType sourceType) {
        this.name = name;
        this.sourceLoader = sourceType.classLoader();
        this.sourceVM = sourceType.virtualMachine();
    }

    public JdiReflective(String name, ClassLoaderReference classLoader, VirtualMachine vm) {
        this.name = name;
        this.sourceLoader = classLoader;
        this.sourceVM = vm;
    }

    public Reflective getRelativeClass(String name) {
        if (this.rclass != null) {
            return new JdiReflective(name, this.rclass);
        }
        return new JdiReflective(name, this.sourceLoader, this.sourceVM);
    }

    protected void checkLoaded() {
        block2: {
            block3: {
                block4: {
                    if (this.rclass != null) break block2;
                    this.rclass = JdiReflective.findClass(this.name, this.sourceLoader, this.sourceVM);
                    if (this.rclass != null) break block3;
                    VMReference vmr = VMReference.getVmForMachine(this.sourceVM);
                    if (vmr == null) break block4;
                    this.rclass = vmr.loadClass(this.name, this.sourceLoader);
                    if (this.rclass != null) break block3;
                }
                Debug.message("Attempt to use unloaded type: " + this.name);
                Debug.message("  name = " + this.name + ", sourceLoader = " + this.sourceLoader);
                new Exception().printStackTrace(System.out);
                return;
            }
            this.name = null;
            this.sourceLoader = null;
            this.sourceVM = null;
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.rclass.name();
    }

    public boolean isInterface() {
        this.checkLoaded();
        return this.rclass instanceof InterfaceType;
    }

    public boolean isStatic() {
        this.checkLoaded();
        return this.rclass.isStatic();
    }

    public Reflective getArrayOf() {
        if (this.rclass != null) {
            return new JdiArrayReflective(new GenTypeClass(this), this.rclass);
        }
        return new JdiArrayReflective(new GenTypeClass(this), this.sourceLoader, this.sourceVM);
    }

    public List getTypeParams() {
        this.checkLoaded();
        String gensig = JdiUtils.getJdiUtils().genericSignature(this.rclass);
        if (gensig == null) {
            return Collections.EMPTY_LIST;
        }
        StringIterator s = new StringIterator(gensig);
        return this.getTypeParams(s);
    }

    private List getTypeParams(StringIterator s) {
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        char c = s.peek();
        if (c != '<') {
            return rlist;
        }
        s.next();
        while (c != '>') {
            String paramName = JdiReflective.readClassName(s);
            if (s.current() != ':') {
                Debug.message("getTypeParams : no ':' following type parameter name in super signature?? got " + s.current());
                Debug.message("signature was: " + s.getString());
                return null;
            }
            if (s.peek() == ':') {
                s.next();
            }
            ArrayList<JavaType> bounds = new ArrayList<JavaType>(3);
            while (s.current() == ':') {
                bounds.add(JdiReflective.fromSignature(s, null, this.rclass));
                if (s.peek() != ':') continue;
                s.next();
            }
            rlist.add(new GenTypeDeclTpar(paramName, bounds.toArray(new GenTypeSolid[0])));
            c = s.peek();
        }
        s.next();
        return rlist;
    }

    public List getSuperTypesR() {
        this.checkLoaded();
        if (this.rclass instanceof ClassType) {
            LinkedList<JdiReflective> l = new LinkedList<JdiReflective>();
            Iterator<InterfaceType> i = ((ClassType)this.rclass).interfaces().iterator();
            while (i.hasNext()) {
                l.add(new JdiReflective(i.next()));
            }
            if (((ClassType)this.rclass).superclass() != null) {
                l.add(new JdiReflective(((ClassType)this.rclass).superclass()));
            }
            return l;
        }
        if (this.rclass instanceof InterfaceType) {
            LinkedList<JdiReflective> l = new LinkedList<JdiReflective>();
            Iterator<InterfaceType> i = ((InterfaceType)this.rclass).superinterfaces().iterator();
            while (i.hasNext()) {
                l.add(new JdiReflective(i.next()));
            }
            if (l.isEmpty()) {
                l.add(new JdiReflective("java.lang.Object", this.rclass));
            }
            return l;
        }
        return new LinkedList();
    }

    public List getSuperTypes() {
        this.checkLoaded();
        ArrayList<GenTypeClass> rlist = new ArrayList<GenTypeClass>();
        if (JdiUtils.getJdiUtils().genericSignature(this.rclass) == null) {
            if (this.rclass instanceof ClassType) {
                ClassType ctClass = (ClassType)this.rclass;
                JdiReflective r = new JdiReflective(ctClass.superclass());
                rlist.add(new GenTypeClass(r));
                List<InterfaceType> interfaces = ctClass.interfaces();
                Iterator<InterfaceType> i = interfaces.iterator();
                while (i.hasNext()) {
                    r = new JdiReflective(i.next());
                    rlist.add(new GenTypeClass(r));
                }
                return rlist;
            }
            InterfaceType itClass = (InterfaceType)this.rclass;
            List<InterfaceType> interfaces = itClass.superinterfaces();
            Iterator<InterfaceType> i = interfaces.iterator();
            while (i.hasNext()) {
                JdiReflective r = new JdiReflective(i.next());
                rlist.add(new GenTypeClass(r));
            }
            if (rlist.isEmpty()) {
                rlist.add(new GenTypeClass(new JdiReflective("java.lang.Object", this.rclass)));
            }
            return rlist;
        }
        StringIterator s = new StringIterator(JdiUtils.getJdiUtils().genericSignature(this.rclass));
        List l = this.getTypeParams(s);
        HashMap<String, GenTypeDeclTpar> declTpars = new HashMap<String, GenTypeDeclTpar>();
        for (GenTypeDeclTpar declTpar : l) {
            declTpars.put(declTpar.getTparName(), declTpar);
        }
        while (s.hasNext()) {
            GenTypeClass t = (GenTypeClass)JdiReflective.fromSignature(s, declTpars, this.rclass);
            rlist.add(t);
        }
        return rlist;
    }

    public boolean isAssignableFrom(Reflective r) {
        if (this.equals(r)) {
            return true;
        }
        if (this.getName().equals("java.lang.Object")) {
            return true;
        }
        if (r instanceof JdiReflective) {
            JdiReflective jr = (JdiReflective)r;
            jr.checkLoaded();
            return JdiReflective.checkAssignability(this.rclass, jr.rclass);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static boolean checkAssignability(ReferenceType a, ReferenceType b) {
        List<InterfaceType> l;
        block12: {
            while (true) {
                if (a instanceof ClassType) {
                    if (b instanceof InterfaceType) {
                        l = ((ClassType)a).allInterfaces();
                        return l.contains(b);
                    }
                    break;
                }
                if (a instanceof InterfaceType) {
                    if (!(b instanceof InterfaceType)) {
                        return false;
                    }
                    break block12;
                }
                if (!(a instanceof ArrayType)) return false;
                if (!(b instanceof ArrayType)) {
                    return false;
                }
                try {
                    Type an = ((ArrayType)a).componentType();
                    Type bn = ((ArrayType)b).componentType();
                    if (!(an instanceof ReferenceType)) return false;
                    if (!(bn instanceof ReferenceType)) return false;
                    a = (ReferenceType)an;
                    b = (ReferenceType)bn;
                }
                catch (ClassNotLoadedException cnle) {
                    return false;
                }
            }
            if (!(b instanceof ClassType)) return false;
            ClassType classType = (ClassType)a;
            while (classType != null) {
                if (((Object)b).equals(classType)) {
                    return true;
                }
                classType = classType.superclass();
            }
            return false;
        }
        l = new LinkedList<InterfaceType>();
        l.addAll(((InterfaceType)a).superinterfaces());
        while (!l.isEmpty()) {
            InterfaceType it = l.get(0);
            if (((Object)a).equals(it)) {
                return true;
            }
            l.addAll(it.superinterfaces());
            l.remove(0);
        }
        return false;
    }

    private static ReferenceType findClass(String name, ClassLoaderReference cl, VirtualMachine vm) {
        if (cl != null) {
            for (ReferenceType ct : cl.visibleClasses()) {
                if (!ct.name().equals(name)) continue;
                return ct;
            }
        } else {
            for (ReferenceType ct : vm.classesByName(name)) {
                if (ct.classLoader() != null) continue;
                return ct;
            }
        }
        return null;
    }

    private static String readClassName(StringIterator i) {
        char c = i.next();
        String r = new String();
        while (c != '<' && c != ';' && c != ':') {
            r = c == '/' ? r + '.' : r + c;
            c = i.next();
        }
        return r;
    }

    private static JavaType fromSignature(StringIterator i, Map tparams, ReferenceType parent) {
        char c = i.next();
        if (c == '*') {
            return new GenTypeUnbounded();
        }
        if (c == '+') {
            GenTypeSolid t = (GenTypeSolid)JdiReflective.fromSignature(i, null, parent);
            if (tparams != null) {
                return new GenTypeExtends(t).mapTparsToTypes(tparams);
            }
            return new GenTypeExtends(t);
        }
        if (c == '-') {
            GenTypeSolid t = (GenTypeSolid)JdiReflective.fromSignature(i, null, parent);
            if (tparams != null) {
                return new GenTypeSuper(t).mapTparsToTypes(tparams);
            }
            return new GenTypeSuper(t);
        }
        if (c == '[') {
            JavaType t = JdiReflective.fromSignature(i, tparams, parent);
            String xName = "[" + t.arrayComponentName();
            JdiReflective areflective = new JdiReflective(xName, parent);
            t = new GenTypeArray(t, areflective);
            return t;
        }
        if (c == 'T') {
            String tname = JdiReflective.readClassName(i);
            if (tparams != null && tparams.get(tname) != null) {
                return (JavaType)tparams.get(tname);
            }
            return new GenTypeTpar(tname);
        }
        if (c == 'I') {
            return JavaPrimitiveType.getInt();
        }
        if (c == 'C') {
            return JavaPrimitiveType.getChar();
        }
        if (c == 'Z') {
            return JavaPrimitiveType.getBoolean();
        }
        if (c == 'B') {
            return JavaPrimitiveType.getByte();
        }
        if (c == 'S') {
            return JavaPrimitiveType.getShort();
        }
        if (c == 'J') {
            return JavaPrimitiveType.getLong();
        }
        if (c == 'F') {
            return JavaPrimitiveType.getFloat();
        }
        if (c == 'D') {
            return JavaPrimitiveType.getDouble();
        }
        if (c != 'L') {
            Debug.message("Generic signature begins without 'L'?? (got " + c + ")");
        }
        String basename = JdiReflective.readClassName(i);
        JdiReflective reflective = new JdiReflective(basename, parent);
        c = i.current();
        if (c == ';') {
            return new GenTypeClass((Reflective)reflective, (List)null);
        }
        if (c != '<') {
            Debug.message("Generic signature: expected '<', got '" + c + "' ??");
            return null;
        }
        ArrayList<JavaType> params = new ArrayList<JavaType>();
        do {
            JavaType ptype;
            if ((ptype = JdiReflective.fromSignature(i, tparams, parent)) == null) {
                return null;
            }
            params.add(ptype);
        } while (i.peek() != '>');
        i.next();
        c = i.next();
        GenTypeClass result = new GenTypeClass((Reflective)reflective, params);
        if (c == '.') {
            return JdiReflective.innerFromSignature(i, basename, result, tparams, parent);
        }
        return result;
    }

    private static GenTypeClass innerFromSignature(StringIterator i, String outerName, GenTypeClass outer, Map tparams, ReferenceType parent) {
        String basename = JdiReflective.readClassName(i);
        String innerName = outerName + '$' + basename;
        JdiReflective reflective = new JdiReflective(innerName, parent);
        char c = i.current();
        if (c == ';') {
            return new GenTypeClass(reflective, null, outer);
        }
        if (c == '<') {
            ArrayList<JavaType> params = new ArrayList<JavaType>();
            do {
                JavaType ptype;
                if ((ptype = JdiReflective.fromSignature(i, tparams, parent)) == null) {
                    return null;
                }
                params.add(ptype);
            } while (i.peek() != '>');
            i.next();
            c = i.next();
            GenTypeClass result = new GenTypeClass(reflective, params, outer);
            if (c == '.') {
                return JdiReflective.innerFromSignature(i, innerName, result, tparams, parent);
            }
            return result;
        }
        Debug.message("Generic signature: expected '<', got '" + c + "' ??");
        return null;
    }

    private static JavaType getNonGenericType(String typeName, Type t, ClassLoaderReference clr, VirtualMachine vm) {
        if (t instanceof BooleanType) {
            return JavaPrimitiveType.getBoolean();
        }
        if (t instanceof ByteType) {
            return JavaPrimitiveType.getByte();
        }
        if (t instanceof CharType) {
            return JavaPrimitiveType.getChar();
        }
        if (t instanceof DoubleType) {
            return JavaPrimitiveType.getDouble();
        }
        if (t instanceof FloatType) {
            return JavaPrimitiveType.getFloat();
        }
        if (t instanceof IntegerType) {
            return JavaPrimitiveType.getInt();
        }
        if (t instanceof LongType) {
            return JavaPrimitiveType.getLong();
        }
        if (t instanceof ShortType) {
            return JavaPrimitiveType.getShort();
        }
        JdiReflective ref = new JdiReflective(typeName, clr, vm);
        return new GenTypeClass((Reflective)ref, (List)null);
    }

    public static JavaType fromField(Field f, JdiObject parent) {
        Type t;
        block4: {
            t = null;
            Value v = parent.obj.getValue(f);
            try {
                t = f.type();
            }
            catch (ClassNotLoadedException cnle) {
                t = JdiReflective.findClass(f.typeName(), parent.obj.referenceType().classLoader(), parent.obj.virtualMachine());
                if (t != null || v == null) break block4;
                t = v.type();
            }
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(f);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(f.typeName(), t, parent.obj.referenceType().classLoader(), parent.obj.virtualMachine());
        }
        GenTypeClass genType = parent.getGenType();
        Map tparams = genType.mapToSuper(f.declaringType().name()).getMap();
        if (tparams == null) {
            JdiReflective r = new JdiReflective(f.typeName(), parent.obj.referenceType());
            return new GenTypeClass(r);
        }
        StringIterator iterator = new StringIterator(gensig);
        return JdiReflective.fromSignature(iterator, tparams, parent.obj.referenceType());
    }

    public static JavaType fromField(Field f, ReferenceType parent) {
        Type t;
        block3: {
            t = null;
            Value v = parent.getValue(f);
            try {
                t = f.type();
            }
            catch (ClassNotLoadedException cnle) {
                t = JdiReflective.findClass(f.typeName(), parent.classLoader(), parent.virtualMachine());
                if (t != null || v == null) break block3;
                t = v.type();
            }
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(f);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(f.typeName(), t, parent.classLoader(), parent.virtualMachine());
        }
        StringIterator iterator = new StringIterator(gensig);
        return JdiReflective.fromSignature(iterator, null, parent);
    }

    public static JavaType fromLocalVar(StackFrame sf, LocalVariable var) {
        ReferenceType declType;
        Type t;
        block3: {
            t = null;
            Value v = sf.getValue(var);
            Location l = sf.location();
            declType = l.declaringType();
            try {
                t = var.type();
            }
            catch (ClassNotLoadedException cnle) {
                t = JdiReflective.findClass(var.typeName(), declType.classLoader(), declType.virtualMachine());
                if (t != null || v == null) break block3;
                t = v.type();
            }
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(var);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(var.typeName(), t, declType.classLoader(), declType.virtualMachine());
        }
        StringIterator iterator = new StringIterator(gensig);
        HashMap tparams = new HashMap();
        JdiReflective.addDefaultParamBases(tparams, new JdiReflective(declType));
        return JdiReflective.fromSignature(iterator, tparams, declType);
    }

    private static void addDefaultParamBases(Map tparams, JdiReflective declaringType) {
        while (declaringType != null) {
            for (GenTypeDeclTpar tpar : declaringType.getTypeParams()) {
                String paramName = tpar.getTparName();
                GenTypeSolid[] ubounds = tpar.upperBounds();
                GenTypeWildcard type = new GenTypeWildcard(ubounds, new GenTypeSolid[0]);
                if (tparams.containsKey(paramName)) continue;
                tparams.put(paramName, type);
            }
            declaringType = declaringType.getOuterType();
        }
    }

    private JdiReflective getOuterType() {
        this.checkLoaded();
        String myName = this.getName();
        int x = myName.indexOf(36);
        if (x != -1 && !this.rclass.isStatic()) {
            String outerName = myName.substring(0, x);
            return (JdiReflective)this.getRelativeClass(outerName);
        }
        return null;
    }

    static class StringIterator {
        int i = 0;
        String s;

        public StringIterator(String s) {
            this.s = s;
            if (s == null) {
                Debug.message("StringIterator with null string??");
            }
        }

        public char current() {
            return this.s.charAt(this.i - 1);
        }

        public char next() {
            return this.s.charAt(this.i++);
        }

        public char peek() {
            return this.s.charAt(this.i);
        }

        public boolean hasNext() {
            return this.i < this.s.length();
        }

        public String getString() {
            return this.s;
        }
    }
}

