/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiArray;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdiObject
extends DebuggerObject {
    static boolean jvmSupportsGenerics = Config.isJava15();
    ObjectReference obj;
    GenTypeClass genType = null;
    List<Field> fields;

    public static JdiObject getDebuggerObject(ObjectReference obj) {
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj);
        }
        return new JdiObject(obj);
    }

    public static JdiObject getDebuggerObject(ObjectReference obj, JavaType expectedType) {
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj, expectedType);
        }
        if (expectedType instanceof GenTypeClass) {
            return new JdiObject(obj, (GenTypeClass)expectedType);
        }
        return new JdiObject(obj);
    }

    public static JdiObject getDebuggerObject(ObjectReference obj, Field field, JdiObject parent) {
        if (!jvmSupportsGenerics) {
            return JdiObject.getDebuggerObject(obj);
        }
        JavaType expectedType = JdiReflective.fromField(field, parent);
        if (obj instanceof ArrayReference) {
            return new JdiArray((ArrayReference)obj, expectedType);
        }
        if (expectedType instanceof GenTypeClass) {
            return new JdiObject(obj, (GenTypeClass)expectedType);
        }
        return new JdiObject(obj);
    }

    protected JdiObject() {
    }

    private JdiObject(ObjectReference obj) {
        this.obj = obj;
        obj.disableCollection();
        this.getRemoteFields();
    }

    private JdiObject(ObjectReference obj, GenTypeClass expectedType) {
        this.obj = obj;
        if (obj != null) {
            obj.disableCollection();
        }
        this.getRemoteFields();
        if (obj != null) {
            JdiReflective reflective = new JdiReflective(obj.referenceType());
            if (expectedType.isGeneric()) {
                this.genType = expectedType.mapToDerived(reflective);
            }
        }
    }

    protected void finalize() {
        this.obj.enableCollection();
    }

    public String toString() {
        return JdiUtils.getJdiUtils().getValueString(this.obj);
    }

    @Override
    public String getClassName() {
        if (this.obj == null) {
            return "";
        }
        return this.obj.referenceType().name();
    }

    @Override
    public String getGenClassName() {
        if (this.obj == null) {
            return "";
        }
        if (this.genType != null) {
            return this.genType.toString();
        }
        return this.getClassName();
    }

    @Override
    public String getStrippedGenClassName() {
        if (this.obj == null) {
            return "";
        }
        if (this.genType != null) {
            return this.genType.toString(true);
        }
        return JavaNames.stripPrefix(this.getClassName());
    }

    @Override
    public DebuggerClass getClassRef() {
        if (this.obj == null) {
            return null;
        }
        return new JdiClass(this.obj.referenceType());
    }

    @Override
    public GenTypeClass getGenType() {
        if (this.genType != null) {
            return this.genType;
        }
        JdiReflective r = new JdiReflective(this.obj.referenceType());
        return new GenTypeClass(r);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isNullObject() {
        return this.obj == null;
    }

    @Override
    public int getStaticFieldCount() {
        return this.getFieldCount(true);
    }

    @Override
    public int getInstanceFieldCount() {
        return this.getFieldCount(false);
    }

    @Override
    public String getStaticFieldName(int slot) {
        return this.getField(true, slot).name();
    }

    @Override
    public String getInstanceFieldName(int slot) {
        return this.getField(false, slot).name();
    }

    @Override
    public String getInstanceFieldType(int slot) {
        return JdiReflective.fromField(this.getField(false, slot), this).toString(false);
    }

    @Override
    public DebuggerObject getStaticFieldObject(int slot) {
        Field field = this.getField(true, slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    @Override
    public DebuggerObject getInstanceFieldObject(int slot) {
        Field field = this.getField(false, slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    @Override
    public DebuggerObject getInstanceFieldObject(int slot, JavaType expectedType) {
        Field field = this.getField(false, slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, expectedType);
    }

    @Override
    public DebuggerObject getFieldObject(int slot) {
        Field field = this.fields.get(slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    @Override
    public DebuggerObject getFieldObject(int slot, JavaType expectedType) {
        Field field = this.fields.get(slot);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, expectedType);
    }

    @Override
    public DebuggerObject getFieldObject(String name) {
        Field field = this.obj.referenceType().fieldByName(name);
        ObjectReference val = (ObjectReference)this.obj.getValue(field);
        return JdiObject.getDebuggerObject(val, field, this);
    }

    @Override
    public String getFieldValueString(int slot) {
        Field field = this.fields.get(slot);
        Value val = this.obj.getValue(field);
        return JdiUtils.getJdiUtils().getValueString(val);
    }

    @Override
    public String getFieldValueTypeString(int slot) {
        Field field = this.fields.get(slot);
        Value val = this.obj.getValue(field);
        return val.type().name();
    }

    @Override
    public ObjectReference getObjectReference() {
        return this.obj;
    }

    @Override
    public List<String> getStaticFields(boolean includeModifiers) {
        return this.getFields(false, true, includeModifiers);
    }

    @Override
    public List<String> getInstanceFields(boolean includeModifiers) {
        return this.getFields(false, false, includeModifiers);
    }

    @Override
    public List<String> getAllFields(boolean includeModifiers) {
        return this.getFields(true, true, includeModifiers);
    }

    @Override
    public boolean staticFieldIsPublic(int slot) {
        return this.getField(true, slot).isPublic();
    }

    @Override
    public boolean instanceFieldIsPublic(int slot) {
        return this.getField(false, slot).isPublic();
    }

    @Override
    public boolean staticFieldIsObject(int slot) {
        return this.checkFieldForObject(true, slot);
    }

    @Override
    public boolean instanceFieldIsObject(int slot) {
        return this.checkFieldForObject(false, slot);
    }

    @Override
    public boolean fieldIsObject(int slot) {
        Field field = this.fields.get(slot);
        Value val = this.obj.getValue(field);
        return val instanceof ObjectReference;
    }

    private int getFieldCount(boolean getStatic) {
        int count = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (this.checkIgnoreField(field) || field.isStatic() != getStatic) continue;
            ++count;
        }
        return count;
    }

    private List<String> getFields(boolean getAll, boolean getStatic, boolean includeModifiers) {
        ArrayList<String> fieldStrings = new ArrayList<String>(this.fields.size());
        if (this.obj == null) {
            return fieldStrings;
        }
        ReferenceType cls = this.obj.referenceType();
        List<Field> visible = cls.visibleFields();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (this.checkIgnoreField(field) || !getAll && field.isStatic() != getStatic) continue;
            Value val = this.obj.getValue(field);
            String valString = JdiUtils.getJdiUtils().getValueString(val);
            String fieldString = "";
            if (includeModifiers) {
                if (field.isPrivate()) {
                    fieldString = "private ";
                }
                if (field.isProtected()) {
                    fieldString = "protected ";
                }
                if (field.isPublic()) {
                    fieldString = "public ";
                }
            }
            fieldString = jvmSupportsGenerics ? fieldString + JdiReflective.fromField(field, this).toString(true) : fieldString + JavaNames.stripPrefix(field.typeName());
            if (!visible.contains(field)) {
                fieldString = fieldString + " (hidden)";
            }
            fieldString = fieldString + " " + field.name() + " = " + valString;
            fieldStrings.add(fieldString);
        }
        return fieldStrings;
    }

    private Field getField(boolean getStatic, int slot) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (this.checkIgnoreField(field) || field.isStatic() != getStatic) continue;
            if (slot == 0) {
                return field;
            }
            --slot;
        }
        Debug.reportError("invalid slot in remote object");
        return null;
    }

    private boolean checkIgnoreField(Field f) {
        return f.name().indexOf(36) >= 0;
    }

    protected void getRemoteFields() {
        ReferenceType cls;
        if (this.obj != null && (cls = this.obj.referenceType()) != null) {
            this.fields = cls.allFields();
            return;
        }
        this.fields = new ArrayList<Field>();
    }

    private boolean checkFieldForObject(boolean getStatic, int slot) {
        Field field = this.getField(getStatic, slot);
        Value val = this.obj.getValue(field);
        return val instanceof ObjectReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JdiObject test = (JdiObject)o;
        return ((Object)this.obj).equals(test.obj);
    }

    public int hashCode() {
        return ((Object)this.obj).hashCode();
    }
}

