/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.Debug;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdiClass
extends DebuggerClass {
    ReferenceType remoteClass;
    List<Field> staticFields;

    public JdiClass(ReferenceType remoteClass) {
        this.remoteClass = remoteClass;
        this.getRemoteFields();
    }

    @Override
    public String getName() {
        return this.remoteClass.name();
    }

    @Override
    public int getStaticFieldCount() {
        return this.staticFields.size();
    }

    @Override
    public String getStaticFieldName(int slot) {
        return this.staticFields.get(slot).name();
    }

    @Override
    public String getStaticFieldType(int slot) {
        Field field = this.staticFields.get(slot);
        return JdiReflective.fromField(field, this.remoteClass).toString(false);
    }

    @Override
    public DebuggerObject getStaticFieldObject(int slot) {
        Field field = this.staticFields.get(slot);
        ObjectReference val = (ObjectReference)this.remoteClass.getValue(field);
        GenTypeClass expectedType = (GenTypeClass)JdiReflective.fromField(field, this.remoteClass);
        return JdiObject.getDebuggerObject(val, expectedType);
    }

    @Override
    public List<String> getStaticFields(boolean includeModifiers) {
        return this.getFields(includeModifiers);
    }

    @Override
    public boolean staticFieldIsPublic(int slot) {
        return this.staticFields.get(slot).isPublic();
    }

    @Override
    public boolean staticFieldIsObject(int slot) {
        Field field = this.staticFields.get(slot);
        Value val = this.remoteClass.getValue(field);
        return val instanceof ObjectReference;
    }

    @Override
    public boolean isInterface() {
        return this.remoteClass instanceof InterfaceType;
    }

    @Override
    public boolean isEnum() {
        if (this.remoteClass instanceof ClassType) {
            return JdiUtils.getJdiUtils().isEnum((ClassType)this.remoteClass);
        }
        return false;
    }

    private List<String> getFields(boolean includeModifiers) {
        ArrayList<String> fieldStrings = new ArrayList<String>(this.staticFields.size());
        List<Field> visible = this.remoteClass.visibleFields();
        for (int i = 0; i < this.staticFields.size(); ++i) {
            Field field = this.staticFields.get(i);
            Value val = this.remoteClass.getValue(field);
            String valString = JdiUtils.getJdiUtils().getValueString(val);
            String fieldString = "";
            if (includeModifiers) {
                if (field.isPrivate()) {
                    fieldString = "private ";
                }
                if (field.isProtected()) {
                    fieldString = "protected ";
                }
                if (field.isPublic()) {
                    fieldString = "public ";
                }
            }
            fieldString = fieldString + JdiReflective.fromField(field, this.remoteClass).toString(true) + " " + field.name() + " = " + valString;
            if (!visible.contains(field)) {
                fieldString = fieldString + " (hidden)";
            }
            fieldStrings.add(fieldString);
        }
        return fieldStrings;
    }

    private void getRemoteFields() {
        this.staticFields = new ArrayList<Field>();
        if (this.remoteClass != null) {
            List<Field> allFields = this.remoteClass.allFields();
            for (int i = 0; i < allFields.size(); ++i) {
                Field field = allFields.get(i);
                if (!field.isStatic()) continue;
                this.staticFields.add(field);
            }
        } else {
            Debug.reportError("cannot get fields for remote class");
        }
    }
}

