/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IntersectionType
extends GenTypeSolid {
    private GenTypeSolid[] intersectTypes;

    private IntersectionType(GenTypeSolid[] types) {
        if (types.length == 0) {
            throw new IllegalArgumentException();
        }
        this.intersectTypes = types;
    }

    public static GenTypeSolid getIntersection(GenTypeSolid[] types) {
        if (types.length == 1) {
            return types[0];
        }
        ArrayList<GenTypeSolid> nonclasstypes = new ArrayList<GenTypeSolid>();
        GenTypeClass classtype = null;
        for (int i = 0; i < types.length; ++i) {
            GenTypeClass tclass = types[i].asClass();
            if (tclass != null && !tclass.isInterface()) {
                if (classtype == null) {
                    classtype = tclass;
                    continue;
                }
                classtype = IntersectionType.combineClasses(tclass, classtype);
                continue;
            }
            nonclasstypes.add(types[i]);
        }
        if (classtype != null) {
            nonclasstypes.listIterator().add(classtype);
        }
        if (nonclasstypes.size() == 1) {
            return (GenTypeSolid)nonclasstypes.get(0);
        }
        return new IntersectionType(nonclasstypes.toArray(new GenTypeSolid[nonclasstypes.size()]));
    }

    public static GenTypeSolid getIntersection(GenTypeSolid a, GenTypeSolid b) {
        return IntersectionType.getIntersection(new GenTypeSolid[]{a, b});
    }

    public static GenTypeClass combineClasses(GenTypeClass a, GenTypeClass b) {
        GenTypeClass bE;
        GenTypeClass aE = (GenTypeClass)a.getErasedType();
        if (!aE.equals(bE = (GenTypeClass)b.getErasedType())) {
            if (aE.isAssignableFrom(bE)) {
                a = a.mapToDerived(bE.reflective);
            } else {
                b = b.mapToDerived(aE.reflective);
            }
        }
        if (a.isRaw()) {
            return b;
        }
        if (b.isRaw()) {
            return a;
        }
        GenTypeClass outer = null;
        if (a.outer != null) {
            outer = IntersectionType.combineClasses(a.outer, b.outer);
        }
        ArrayList<GenTypeParameterizable> newParams = null;
        if (a.params != null) {
            newParams = new ArrayList<GenTypeParameterizable>();
            Iterator ia = a.params.iterator();
            Iterator ib = b.params.iterator();
            while (ia.hasNext()) {
                GenTypeParameterizable tpa = (GenTypeParameterizable)ia.next();
                GenTypeParameterizable tpb = (GenTypeParameterizable)ib.next();
                newParams.add(tpa.precisify(tpb));
            }
        }
        return new GenTypeClass(a.reflective, newParams, outer);
    }

    public String toString(NameTransform nt) {
        String xx = this.intersectTypes[0].toString();
        if (this.intersectTypes.length > 1 && xx.equals("java.lang.Object")) {
            return this.intersectTypes[1].toString(nt);
        }
        return this.intersectTypes[0].toString(nt);
    }

    public String toTypeArgString(NameTransform nt) {
        return "? extends " + this.toString(nt);
    }

    public boolean isInterface() {
        return false;
    }

    public GenTypeSolid[] getUpperBounds() {
        ArrayList<GenTypeSolid> ubounds = new ArrayList<GenTypeSolid>();
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            GenTypeSolid[] itUbounds = this.intersectTypes[i].getUpperBounds();
            ubounds.addAll(Arrays.asList(itUbounds));
        }
        return ubounds.toArray(new GenTypeSolid[ubounds.size()]);
    }

    public GenTypeSolid[] getLowerBounds() {
        return new GenTypeSolid[]{this};
    }

    public JavaType mapTparsToTypes(Map tparams) {
        GenTypeSolid[] newIsect = new GenTypeSolid[this.intersectTypes.length];
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            newIsect[i] = (GenTypeSolid)this.intersectTypes[i].mapTparsToTypes(tparams);
        }
        return new IntersectionType(newIsect);
    }

    public boolean equals(GenTypeParameterizable other) {
        if (other == null) {
            return false;
        }
        return this.isAssignableFrom(other) && other.isAssignableFrom(this);
    }

    public void getParamsFromTemplate(Map map, GenTypeParameterizable template) {
    }

    public GenTypeParameterizable precisify(GenTypeParameterizable other) {
        throw new UnsupportedOperationException();
    }

    public String arrayComponentName() {
        return this.getErasedType().arrayComponentName();
    }

    public JavaType getErasedType() {
        return this.intersectTypes[0].getErasedType();
    }

    public boolean isAssignableFrom(JavaType t) {
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            if (!this.intersectTypes[i].isAssignableFrom(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFromRaw(JavaType t) {
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            if (!this.intersectTypes[i].isAssignableFromRaw(t)) continue;
            return true;
        }
        return false;
    }

    public void erasedSuperTypes(Set s) {
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            this.intersectTypes[i].erasedSuperTypes(s);
        }
    }

    public GenTypeClass[] getReferenceSupertypes() {
        ArrayList<GenTypeClass> rsupTypes = new ArrayList<GenTypeClass>();
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            GenTypeClass[] isTypes = this.intersectTypes[i].getReferenceSupertypes();
            for (int j = 0; j < isTypes.length; ++j) {
                rsupTypes.add(isTypes[j]);
            }
        }
        return rsupTypes.toArray(new GenTypeClass[rsupTypes.size()]);
    }

    public boolean contains(GenTypeParameterizable other) {
        return this.equals(other);
    }
}

