/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class GenTypeDeclTpar
extends GenTypeTpar {
    protected GenTypeSolid[] upperBounds;
    protected GenTypeSolid lBound = null;

    public GenTypeDeclTpar(String parname, GenTypeSolid bound) {
        super(parname);
        this.upperBounds = new GenTypeSolid[]{bound};
    }

    public GenTypeDeclTpar(String parname, GenTypeSolid[] bounds) {
        super(parname);
        this.upperBounds = bounds;
    }

    public GenTypeDeclTpar(String parname, GenTypeSolid[] ubounds, GenTypeSolid lbound) {
        super(parname);
        this.upperBounds = ubounds;
        this.lBound = lbound;
    }

    public GenTypeSolid getBound() {
        return IntersectionType.getIntersection(this.upperBounds);
    }

    public GenTypeSolid[] upperBounds() {
        GenTypeSolid[] r = new GenTypeSolid[this.upperBounds.length];
        System.arraycopy(this.upperBounds, 0, r, 0, this.upperBounds.length);
        return r;
    }

    public GenTypeSolid lowerBound() {
        return this.lBound;
    }

    public GenTypeSolid[] lowerBounds() {
        if (this.lBound == null) {
            return new GenTypeSolid[0];
        }
        return new GenTypeSolid[]{this.lBound};
    }

    public JavaType mapTparsToTypes(Map tparams) {
        if (tparams == null) {
            return new GenTypeWildcard(this.upperBounds(), this.lowerBounds());
        }
        GenTypeParameterizable newType = (GenTypeParameterizable)tparams.get(this.getTparName());
        if (newType == null) {
            return new GenTypeWildcard(this.upperBounds(), this.lowerBounds());
        }
        return newType;
    }

    public String toString(boolean stripPrefix) {
        String bound = this.getBound().toString(false);
        if (bound.equals("java.lang.Object")) {
            return this.getTparName();
        }
        return this.getTparName() + " extends " + this.getBound().toString(stripPrefix);
    }

    public String arrayComponentName() {
        return this.getErasedType().arrayComponentName();
    }

    public JavaType getErasedType() {
        return this.upperBounds[0].getErasedType();
    }

    public void erasedSuperTypes(Set s) {
        for (int i = 0; i < this.upperBounds.length; ++i) {
            this.upperBounds[i].erasedSuperTypes(s);
        }
    }

    public GenTypeClass[] getReferenceSupertypes() {
        ArrayList<GenTypeClass> al = new ArrayList<GenTypeClass>();
        for (int i = 0; i < this.upperBounds.length; ++i) {
            GenTypeClass[] brs = this.upperBounds[i].getReferenceSupertypes();
            for (int j = 0; j < brs.length; ++j) {
                al.add(brs[j]);
            }
        }
        return al.toArray(new GenTypeClass[0]);
    }

    public boolean isAssignableFrom(JavaType t) {
        if (super.isAssignableFrom(t)) {
            return true;
        }
        if (this.lBound != null) {
            return this.lBound.isAssignableFrom(t);
        }
        return false;
    }
}

