/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.utility.DialogManager;
import java.io.IOException;
import java.io.Writer;

public class JavacErrorWriter
extends Writer {
    private boolean haserror = false;
    private boolean hasfollowup = false;
    private boolean hasWarnings = false;
    private int ignoreCount = 0;
    private String filename;
    private String message;
    private String warning = "";
    private int lineno;
    private boolean internal;
    private String lineBuf;
    private String newLineSequence = System.getProperty("line.separator");

    public JavacErrorWriter(boolean internal) {
        this.internal = internal;
        this.lineBuf = "";
    }

    public void reset() {
        this.haserror = false;
        this.hasfollowup = false;
        this.hasWarnings = false;
        this.ignoreCount = 0;
        this.warning = "";
    }

    public boolean hasError() {
        return this.haserror;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNo() {
        return this.lineno;
    }

    public String getMessage() {
        return this.message;
    }

    public String getWarning() {
        return this.warning;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int eolIndex;
        int lineBufLen = this.lineBuf.length();
        this.lineBuf = this.lineBuf + new String(cbuf, off, len);
        int startSearch = lineBufLen - this.newLineSequence.length() + 1;
        if (startSearch < 0) {
            startSearch = 0;
        }
        if ((eolIndex = this.lineBuf.indexOf(this.newLineSequence, startSearch)) != -1) {
            String line = this.lineBuf.substring(0, eolIndex);
            this.lineBuf = this.lineBuf.substring(eolIndex + this.newLineSequence.length());
            this.processLine(line);
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.lineBuf.length() != 0) {
            this.processLine(this.lineBuf);
            this.lineBuf = "";
        }
    }

    private void processLine(String msg) {
        int second_colon;
        if (this.haserror) {
            return;
        }
        if (this.ignoreCount > 0) {
            --this.ignoreCount;
            return;
        }
        if (this.hasfollowup) {
            int colonPoint = 9;
            String label = msg.substring(0, colonPoint);
            String info = msg.substring(colonPoint).trim();
            if (label.equals("found   :")) {
                this.message = this.message + " - found " + info;
            } else if (label.equals("required:")) {
                this.message = this.message + " but expected " + info;
                this.haserror = true;
            } else if (label.equals("symbol  :")) {
                this.message = this.message + " - " + info;
                this.haserror = true;
            } else {
                this.haserror = true;
            }
            return;
        }
        int first_colon = msg.indexOf(58, 0);
        if (first_colon == -1) {
            if (msg.trim().endsWith("warnings") || msg.trim().endsWith("warning")) {
                this.warning = this.warning + msg.trim() + this.newLineSequence;
                this.hasWarnings = true;
                return;
            }
            DialogManager.showErrorWithText(null, "compiler-error", msg);
            return;
        }
        if (msg.startsWith("Note: ")) {
            if (this.internal) {
                return;
            }
            int uses = msg.indexOf(".java uses");
            if (uses != -1) {
                this.filename = msg.substring(5, uses) + ".java";
            }
            this.warning = this.warning + msg.trim() + this.newLineSequence;
            this.hasWarnings = true;
            return;
        }
        this.filename = msg.substring(0, first_colon);
        if (!this.filename.endsWith(".java")) {
            if ((first_colon = msg.indexOf(58, first_colon + 1)) == -1) {
                DialogManager.showErrorWithText(null, "compiler-error", msg);
                return;
            }
            this.filename = msg.substring(0, first_colon);
        }
        if ((second_colon = msg.indexOf(58, first_colon + 1)) == -1) {
            DialogManager.showErrorWithText(null, "compiler-error", msg);
            return;
        }
        this.lineno = 0;
        try {
            this.lineno = Integer.parseInt(msg.substring(first_colon + 1, second_colon));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.message = msg.substring(second_colon + 1).trim();
        if (this.message.startsWith("warning:")) {
            this.warning = this.warning + msg.trim() + this.newLineSequence;
            this.ignoreCount = 2;
            if (this.message.startsWith("warning: [unchecked] unchecked cast")) {
                this.ignoreCount = 4;
            } else if (this.message.startsWith("warning: non-varargs call of varargs method with inexact argument type for last parameter")) {
                this.ignoreCount = 4;
            }
            if (!this.hasWarnings) {
                this.hasWarnings = true;
            }
            return;
        }
        if (this.message.equals("cannot resolve symbol") || this.message.equals("cannot find symbol") || this.message.equals("incompatible types")) {
            this.hasfollowup = true;
        } else {
            this.haserror = true;
        }
    }
}

