/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.compiler.CompileObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

abstract class Compiler {
    public static final String COMPILER_OPTIONS = "bluej.compiler.options";
    public static final String JAVAME_COMPILER_OPTIONS = "bluej.javame.compiler.options";
    private File destDir;
    private BPClassLoader bpClassLoader;
    private boolean debug;
    private boolean deprecation;

    Compiler() {
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setProjectClassLoader(BPClassLoader bpClassLoader) {
        this.bpClassLoader = bpClassLoader;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public BPClassLoader getProjectClassLoader() {
        return this.bpClassLoader;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public File getDestDir() {
        return this.destDir;
    }

    protected List getCompileOptions() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.getDestDir() != null) {
            args.add("-d");
            args.add(this.getDestDir().getPath());
        }
        boolean isJavaMEproject = false;
        if (this.getProjectClassLoader() != null) {
            args.add("-classpath");
            args.add(this.getProjectClassLoader().getClassPathAsString());
            if (this.getProjectClassLoader().loadsForJavaMEproject()) {
                isJavaMEproject = true;
            }
        }
        if (isJavaMEproject) {
            this.addUserSpecifiedOptions(args, JAVAME_COMPILER_OPTIONS);
            args.add("-bootclasspath");
            args.add(this.getProjectClassLoader().getJavaMElibsAsPath());
        } else {
            String majorVersion = System.getProperty("java.specification.version");
            args.add("-source");
            args.add(majorVersion);
        }
        if (this.isDebug()) {
            args.add("-g");
        }
        if (this.isDeprecation()) {
            args.add("-deprecation");
        }
        this.addUserSpecifiedOptions(args, COMPILER_OPTIONS);
        return args;
    }

    private void addUserSpecifiedOptions(List args, String options) {
        String compilerOptions = Config.getPropString(options, null);
        if (compilerOptions != null) {
            StringTokenizer st = new StringTokenizer(compilerOptions);
            while (st.hasMoreTokens()) {
                args.add(st.nextToken());
            }
        }
    }

    public abstract boolean compile(File[] var1, CompileObserver var2, boolean var3);
}

