/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.views.View;
import java.awt.EventQueue;
import java.io.File;

class Identifier {
    private File projectId;
    private String packageId;
    private String qualifiedClassName;

    Identifier(Project bluejProject) {
        this(bluejProject, null, null);
    }

    Identifier(Project bluejProject, Package bluejPackage) {
        this(bluejProject, bluejPackage, null);
    }

    Identifier(Project bluejProject, Package bluejPackage, String aQualifiedClassName) {
        this.projectId = bluejProject.getProjectDir();
        if (bluejPackage != null) {
            this.packageId = bluejPackage.getQualifiedName();
        }
        this.qualifiedClassName = aQualifiedClassName;
    }

    Project getBluejProject() throws ProjectNotOpenException {
        Project aProject = Project.getProject((File)this.projectId);
        if (aProject == null) {
            throw new ProjectNotOpenException("Project " + this.projectId + " is closed");
        }
        return aProject;
    }

    Package getBluejPackage() throws ProjectNotOpenException, PackageNotFoundException {
        Project bluejProject = this.getBluejProject();
        Package bluejPkg = bluejProject.getCachedPackage(this.packageId);
        if (bluejPkg == null) {
            throw new PackageNotFoundException("Package '" + this.packageId + "' is deleted");
        }
        return bluejPkg;
    }

    String getClassName() {
        return this.qualifiedClassName;
    }

    PkgMgrFrame getPackageFrame() throws ProjectNotOpenException, PackageNotFoundException {
        Package thisPkg = this.getBluejPackage();
        final PkgMgrFrame pmf = PkgMgrFrame.createFrame((Package)thisPkg);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!pmf.isVisible()) {
                    pmf.setVisible(true);
                }
            }
        });
        return pmf;
    }

    Class getJavaClass() throws ProjectNotOpenException, ClassNotFoundException {
        Project bluejPrj = this.getBluejProject();
        Class aClass = bluejPrj.loadClass(this.qualifiedClassName);
        if (aClass == null) {
            throw new ClassNotFoundException("Class " + this.qualifiedClassName + " Not Found");
        }
        return aClass;
    }

    ClassTarget getClassTarget() throws ProjectNotOpenException, PackageNotFoundException {
        Target aTarget;
        Package bluejPkg = this.getBluejPackage();
        String className = this.qualifiedClassName;
        int dotpos = this.qualifiedClassName.lastIndexOf(".");
        if (dotpos > 0) {
            className = this.qualifiedClassName.substring(dotpos + 1);
        }
        if ((aTarget = bluejPkg.getTarget(className)) == null) {
            throw new NullPointerException("Class " + this.qualifiedClassName + " has NO ClassTarget");
        }
        if (!(aTarget instanceof ClassTarget)) {
            throw new NullPointerException("Class " + this.qualifiedClassName + " is not of type ClassTarget");
        }
        return (ClassTarget)aTarget;
    }

    View getBluejView() throws ProjectNotOpenException, ClassNotFoundException {
        Class aClass = this.getJavaClass();
        return View.getView((Class)aClass);
    }
}

