/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.Identifier;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import com.sun.jdi.ObjectReference;
import java.util.HashMap;

public class BObject {
    private ObjectWrapper objectWrapper;
    private Identifier wrapperId;
    private static HashMap primiMap = new HashMap();

    BObject(ObjectWrapper aWrapper) {
        this.objectWrapper = aWrapper;
        Package bluejPkg = this.objectWrapper.getPackage();
        Project bluejProj = bluejPkg.getProject();
        String className = this.transJavaToClass(this.objectWrapper.getClassName());
        this.wrapperId = new Identifier(bluejProj, bluejPkg, className);
    }

    public BPackage getPackage() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.wrapperId.getBluejPackage();
        return bluejPkg.getBPackage();
    }

    public void removeFromBench() throws ProjectNotOpenException, PackageNotFoundException {
        Package aPackage = this.wrapperId.getBluejPackage();
        PkgMgrFrame aFrame = this.wrapperId.getPackageFrame();
        ObjectBench aBench = aFrame.getObjectBench();
        aBench.removeObject(this.objectWrapper, aPackage.getId());
        this.objectWrapper = null;
    }

    public void addToBench(String instanceName) throws ProjectNotOpenException, PackageNotFoundException {
        if (this.objectWrapper == null) {
            return;
        }
        if (this.objectWrapper.getObject().isNullObject()) {
            return;
        }
        if (instanceName != null) {
            this.objectWrapper.setName(instanceName);
        }
        Package aPackage = this.wrapperId.getBluejPackage();
        PkgMgrFrame aFrame = this.wrapperId.getPackageFrame();
        ObjectBench aBench = aFrame.getObjectBench();
        aBench.addObject(this.objectWrapper);
        aPackage.getDebugger().addObject(aPackage.getId(), this.objectWrapper.getName(), this.objectWrapper.getObject());
    }

    public String getInstanceName() {
        if (this.objectWrapper == null) {
            return null;
        }
        return this.objectWrapper.getName();
    }

    public BClass getBClass() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException {
        this.wrapperId.getJavaClass();
        ClassTarget classTarget = this.wrapperId.getClassTarget();
        return classTarget.getBClass();
    }

    PkgMgrFrame getPackageFrame() throws ProjectNotOpenException, PackageNotFoundException {
        return this.wrapperId.getPackageFrame();
    }

    ObjectWrapper getObjectWrapper() {
        return this.objectWrapper;
    }

    ObjectReference getObjectReference() {
        if (this.objectWrapper == null) {
            return null;
        }
        DebuggerObject obj = this.objectWrapper.getObject();
        if (obj == null) {
            return null;
        }
        return obj.getObjectReference();
    }

    public String toString() {
        String className = "";
        if (this.objectWrapper != null) {
            className = this.objectWrapper.getClassName();
        }
        return "BObject instanceName=" + this.getInstanceName() + " Class Name=" + className;
    }

    private String transJavaToClass(String javaStyle) {
        String className = javaStyle;
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount <= 0) {
            return className;
        }
        String replace = (String)primiMap.get(className);
        className = replace != null ? replace : "L" + className + ";";
        while (arrayCount-- > 0) {
            className = "[" + className;
        }
        return className;
    }

    static {
        primiMap.put("boolean", "Z");
        primiMap.put("byte", "B");
        primiMap.put("short", "S");
        primiMap.put("char", "C");
        primiMap.put("int", "I");
        primiMap.put("long", "J");
        primiMap.put("float", "F");
        primiMap.put("double", "D");
    }
}

