/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.dialogs.about;

import de.jangassen.dialogs.about.AboutController;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;

public class AboutStageBuilder {
    public static final String DEFAULT_APP_ICON = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/GenericApplicationIcon.icns";
    public static final int DEFAULT_ICON_SIZE = 120;
    private final Stage stage;
    private Label version;
    private Label name;
    private Label copyright;
    private Node credits;
    private ImageView image;

    private AboutStageBuilder(Stage stage) {
        this.stage = stage;
    }

    public Stage build() {
        try {
            this.prepareStage();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stage;
    }

    private void prepareStage() throws IOException {
        URL resource = AboutStageBuilder.class.getClassLoader().getResource("about.fxml");
        FXMLLoader loader = new FXMLLoader(resource);
        Parent root = (Parent)loader.load();
        AboutController controller = (AboutController)loader.getController();
        if (this.image != null) {
            controller.getContent().getChildren().add((Object)this.image);
        }
        if (this.name != null) {
            controller.getContent().getChildren().add((Object)this.name);
        }
        if (this.version != null) {
            controller.getContent().getChildren().add((Object)this.version);
        }
        if (this.credits != null) {
            controller.getContent().getChildren().add((Object)this.credits);
        }
        if (this.copyright != null) {
            controller.getContent().getChildren().add((Object)this.copyright);
        }
        this.stage.setScene(new Scene(root));
    }

    public AboutStageBuilder withCloseOnFocusLoss() {
        this.stage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.stage.close();
            }
        });
        return this;
    }

    public AboutStageBuilder withSize(int with, int height) {
        this.stage.setMinWidth((double)with);
        this.stage.setMaxWidth((double)height);
        return this;
    }

    public AboutStageBuilder withTitle(String title) {
        this.stage.setTitle(title);
        return this;
    }

    public AboutStageBuilder withVersionString(String version) {
        this.version = new Label(version);
        this.version.getStyleClass().add((Object)"version");
        return this;
    }

    public AboutStageBuilder withAppName(String name) {
        this.name = new Label(name);
        this.name.getStyleClass().add((Object)"app_name");
        return this;
    }

    public AboutStageBuilder withText(String text) {
        return this.withTexts(Collections.singleton(new Text(text)));
    }

    public AboutStageBuilder withTexts(Collection<Text> texts) {
        TextFlow creditsView = new TextFlow();
        creditsView.setBorder(Border.EMPTY);
        creditsView.setTextAlignment(TextAlignment.CENTER);
        creditsView.getChildren().addAll(texts);
        this.setCredits((Node)creditsView);
        return this;
    }

    public AboutStageBuilder withNode(Node node) {
        this.setCredits(node);
        return this;
    }

    private void setCredits(Node view) {
        BorderPane pane = new BorderPane();
        pane.setCenter(view);
        pane.getStyleClass().add((Object)"credits");
        this.credits = pane;
    }

    public AboutStageBuilder withCopyright(String copyright) {
        this.copyright = new Label(copyright);
        return this;
    }

    public AboutStageBuilder withImage(Image image) {
        return this.withImage(image, 120.0, 120.0);
    }

    public AboutStageBuilder withImage(Image image, double width, double height) {
        this.image = new ImageView(image);
        this.image.setFitWidth(width);
        this.image.setFitHeight(height);
        return this;
    }

    public static AboutStageBuilder start(String title) {
        Stage aboutStage = new Stage();
        aboutStage.setResizable(false);
        return new AboutStageBuilder(aboutStage).withTitle(title).withSize(300, 300);
    }
}

