/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.record;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import bluej.editor.Editor;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.VarElement;
import bluej.utility.javafx.FXPlatformFunction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GreenfootRecorder {
    private final HashMap<DebuggerObject, String> objectNames = new HashMap();
    private final ArrayList<CodeElement> code = new ArrayList();
    private DebuggerObject world;
    public static final String METHOD_ACCESS = "private";
    public static final String METHOD_RETURN = "void";
    public static final String METHOD_NAME = "prepare";
    private String lastWorldClass;
    private boolean validToSave = false;

    @OnThread(value=Tag.Any)
    public synchronized void createActor(DebuggerObject actor, String[] args, JavaType[] paramTypes) {
        String className = actor.getGenType().toString(true);
        String name = this.nameActor(actor);
        if (name != null) {
            this.code.add((CodeElement)new VarElement(null, className, name, "new " + className + "(" + GreenfootRecorder.withCommas(args, paramTypes, false) + ")"));
        }
    }

    private synchronized String nameActor(DebuggerObject actor) {
        if (this.objectNames.containsKey(actor)) {
            return this.objectNames.get(actor);
        }
        Object root = actor.getClassName().replace(".", "").replace("$", "");
        Object name = root = ((String)root).substring(0, 1).toLowerCase() + ((String)root).substring(1);
        int i = 2;
        while (this.objectNames.values().contains(name)) {
            name = (String)root + i;
            ++i;
        }
        this.objectNames.put(actor, (String)name);
        return name;
    }

    public synchronized void nameActors(List<DebuggerObject> actors) {
        for (DebuggerObject actor : actors) {
            this.nameActor(actor);
        }
    }

    @OnThread(value=Tag.Any)
    private static String withCommas(String[] args, JavaType[] paramTypes, boolean isVarArgs) {
        if (args == null) {
            return "";
        }
        StringBuffer commaArgs = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i].trim();
            if (((String)arg).startsWith("{") && ((String)arg).endsWith("}")) {
                String paramTypeName;
                if (isVarArgs && i >= paramTypes.length - 1) {
                    paramTypeName = paramTypes[paramTypes.length - 1].toString();
                    paramTypeName = paramTypeName.substring(0, paramTypeName.length() - 2);
                } else {
                    paramTypeName = paramTypes[i].toString();
                }
                arg = "new " + paramTypeName + " " + (String)arg;
            }
            commaArgs.append((String)arg);
            if (i == args.length - 1) continue;
            commaArgs.append(", ");
        }
        return commaArgs.toString();
    }

    @OnThread(value=Tag.Any)
    public synchronized void addActorToWorld(DebuggerObject actor, int x, int y) {
        String actorObjectName = this.objectNames.get(actor);
        if (null == actorObjectName) {
            return;
        }
        this.code.add((CodeElement)this.callElement("addObject(" + actorObjectName + "," + String.valueOf(x) + "," + String.valueOf(y) + ")"));
    }

    public synchronized void callActorOrWorldMethod(DebuggerObject obj, Method method, String[] args, JavaType[] paramTypes) {
        if (obj != null && !this.objectNames.containsKey(obj) && !obj.equals((Object)this.world)) {
            return;
        }
        Object name = this.world != null && this.world.equals((Object)obj) ? method.getName() : this.objectNames.get(obj) + "." + method.getName();
        this.code.add((CodeElement)this.callElement((String)name + "(" + GreenfootRecorder.withCommas(args, paramTypes, method.isVarArgs()) + ")"));
    }

    public void callStaticMethod(String className, Method method, String[] args, JavaType[] argTypes) {
        this.code.add((CodeElement)this.callElement(className + "." + method.getName() + "(" + GreenfootRecorder.withCommas(args, argTypes, method.isVarArgs()) + ")"));
    }

    public synchronized void clearCode(boolean clearObjectNames) {
        this.code.clear();
        if (clearObjectNames) {
            this.objectNames.clear();
        }
    }

    public synchronized void setWorld(DebuggerObject newWorld) {
        this.world = newWorld;
        this.lastWorldClass = newWorld.getClassName();
    }

    public synchronized void moveActor(DebuggerObject actor, int xCell, int yCell) {
        String actorObjectName = this.objectNames.get(actor);
        if (null == actorObjectName) {
            return;
        }
        this.code.add((CodeElement)this.callElement(actorObjectName + ".setLocation(" + String.valueOf(xCell) + "," + String.valueOf(yCell) + ")"));
    }

    public void removeActor(DebuggerObject obj) {
        String actorObjectName = this.objectNames.get(obj);
        if (null == actorObjectName) {
            return;
        }
        this.code.add((CodeElement)this.callElement("removeObject(" + actorObjectName + ")"));
        this.objectNames.remove(obj);
    }

    public synchronized List<CodeElement> getCode() {
        return new LinkedList<CodeElement>(this.code);
    }

    public NormalMethodElement getPrepareMethod() {
        StringBuffer documentation = new StringBuffer();
        documentation.append(Config.getString((String)"record.method.comment1")).append("\n");
        documentation.append(Config.getString((String)"record.method.comment2"));
        return new NormalMethodElement(METHOD_ACCESS, METHOD_RETURN, METHOD_NAME, null, this.code, documentation.toString());
    }

    public CallElement getPrepareMethodCall() {
        return this.callElement("prepare()");
    }

    private CallElement callElement(String content) {
        return new CallElement(content, content);
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean writeCode(FXPlatformFunction<String, Editor> getEditor) {
        if (!this.validToSave) {
            return false;
        }
        NormalMethodElement method = this.getPrepareMethod();
        CallElement methodCall = this.getPrepareMethodCall();
        Editor editor = (Editor)getEditor.apply((Object)this.lastWorldClass);
        editor.insertMethodCallInConstructor(this.lastWorldClass, methodCall, inserted -> {});
        editor.insertAppendMethod(method, inserted -> {
            if (inserted.booleanValue()) {
                editor.setEditorVisible(true, false);
            }
        });
        this.clearCode(false);
        return true;
    }

    public void invalidateRecording() {
        this.validToSave = false;
    }

    public void recordingValid() {
        this.validToSave = true;
    }
}

