/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.Config;
import bluej.extensions2.SourceType;
import bluej.utility.JavaNames;
import bluej.utility.javafx.HorizontalRadio;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.dialog.DialogPaneAnimateError;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class NewClassDialog
extends Dialog<NewClassInfo> {
    private final HorizontalRadio<SourceType> language;
    private static List<String> windowsRestrictedWords;
    private final TextField nameField;
    private final DialogPaneAnimateError dialogPane;
    private boolean fieldHasHadContent = false;
    private final Label errorLabel;

    public NewClassDialog(Window parent, SourceType defaultSourceType) {
        this.setTitle(Config.getString((String)"newclass.dialog.title"));
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        this.errorLabel = (Label)JavaFXUtil.withStyleClass((Styleable)new Label(), (String[])new String[]{"dialog-error-label"});
        this.dialogPane = new DialogPaneAnimateError(this.errorLabel, () -> this.updateOKButton(true));
        this.setDialogPane((DialogPane)this.dialogPane);
        Config.addDialogStylesheets((Pane)this.getDialogPane());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        VBox mainPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPanel, (String[])new String[]{"new-class-dialog"});
        this.nameField = new TextField();
        this.nameField.setMinWidth(250.0);
        this.nameField.setPromptText(Config.getString((String)"pkgmgr.newClass.prompt"));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.nameField.textProperty(), s -> {
            this.hideError();
            this.updateOKButton(false);
        });
        HBox nameBox = new HBox(new Node[]{new Label(Config.getString((String)"pkgmgr.newClass.label")), this.nameField});
        JavaFXUtil.addStyleClass((Styleable)nameBox, (String[])new String[]{"new-class-dialog-hbox"});
        nameBox.setAlignment(Pos.BASELINE_LEFT);
        mainPanel.getChildren().add((Object)nameBox);
        this.language = new HorizontalRadio(Arrays.asList(SourceType.Java, SourceType.Stride));
        this.language.select((Object)defaultSourceType);
        HBox langBox = new HBox();
        JavaFXUtil.addStyleClass((Styleable)langBox, (String[])new String[]{"new-class-dialog-hbox"});
        langBox.getChildren().add((Object)new Label(Config.getString((String)"pkgmgr.newClass.lang")));
        langBox.getChildren().addAll((Object[])new Node[]{this.language.getButtons()});
        langBox.setAlignment(Pos.BASELINE_LEFT);
        mainPanel.getChildren().add((Object)langBox);
        mainPanel.getChildren().add((Object)this.errorLabel);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.language.selectedProperty(), language -> {
            this.hideError();
            this.updateOKButton(false);
        });
        this.getDialogPane().setContent((Node)mainPanel);
        this.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.OK) {
                return new NewClassInfo(this.nameField.getText().trim(), (SourceType)this.language.selectedProperty().get());
            }
            return null;
        });
        this.updateOKButton(false);
        this.setOnShown(e -> Platform.runLater(() -> ((TextField)this.nameField).requestFocus()));
    }

    private void updateOKButton(boolean force) {
        String newClassName = this.nameField.getText().trim();
        this.fieldHasHadContent |= !newClassName.equals("");
        boolean enable = false;
        SourceType sourceType = (SourceType)this.language.selectedProperty().get();
        Properties localProperties = new Properties();
        localProperties.put("LANGUAGE", sourceType.toString());
        if (!JavaNames.isIdentifier((String)newClassName)) {
            if (this.fieldHasHadContent || force) {
                this.showError(Config.getString((String)"pkgmgr.newClass.error.notValidClassName", null, (Properties)localProperties, (boolean)false), true);
            }
        } else if (this.isWindowsRestrictedWord(newClassName)) {
            if (this.fieldHasHadContent || force) {
                this.showError(Config.getString((String)"pkgmgr.newClass.error.windowsRestricted"), true);
            }
        } else {
            this.hideError();
            enable = true;
        }
        this.setOKEnabled(enable);
    }

    private void hideError() {
        this.errorLabel.setText("");
        JavaFXUtil.setPseudoclass((String)"bj-dialog-error", (boolean)false, (Node[])new Node[]{this.nameField});
    }

    private void showError(String error, boolean problemIsName) {
        this.errorLabel.setText(error);
        JavaFXUtil.setPseudoclass((String)"bj-dialog-error", (boolean)problemIsName, (Node[])new Node[]{this.nameField});
    }

    private void setOKEnabled(boolean okEnabled) {
        this.dialogPane.getOKButton().setDisable(!okEnabled);
    }

    private boolean isWindowsRestrictedWord(String fileName) {
        this.initialiseRestrictedWordList();
        return windowsRestrictedWords.contains(fileName.toUpperCase());
    }

    private void initialiseRestrictedWordList() {
        if (windowsRestrictedWords == null) {
            windowsRestrictedWords = Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");
        }
    }

    public void setSuggestedClassName(String suggestedClassName) {
        this.nameField.setText(suggestedClassName);
    }

    public void disableLanguageBox(boolean value) {
        this.language.setDisable(value);
    }

    public SourceType getSelectedLanguage() {
        return (SourceType)this.language.selectedProperty().get();
    }

    public void setSelectedLanguage(SourceType type) {
        this.language.select((Object)type);
    }

    @OnThread(value=Tag.Any)
    public static class NewClassInfo {
        public final String className;
        public final SourceType sourceType;

        private NewClassInfo(String className, SourceType sourceType) {
            this.className = className;
            this.sourceType = sourceType;
        }
    }
}

