/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.BlueJPropStringSource;
import bluej.Config;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.UnfocusableScrollPane;
import greenfoot.World;
import greenfoot.core.ExportedProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationListener;
import greenfoot.guifx.ControlPanel;
import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.WorldDisplay;
import greenfoot.platforms.standalone.ActorDelegateStandAlone;
import greenfoot.platforms.standalone.GreenfootUtilDelegateStandAlone;
import greenfoot.platforms.standalone.WorldHandlerDelegateStandAlone;
import greenfoot.sound.SoundFactory;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.StandalonePropStringManager;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GreenfootScenarioViewer
extends BorderPane
implements ControlPanel.ControlPanelListener,
SimulationListener {
    private ExportedProjectProperties properties;
    private Simulation sim;
    private ControlPanel controls;
    private @OnThread(value=Tag.Any) Constructor<?> worldConstructor;
    private final WorldDisplay worldDisplay = new WorldDisplay();
    private boolean updatingSliderFromSimulation = false;

    public static void initProperties() {
        Properties p = new Properties();
        try {
            ClassLoader loader = GreenfootScenarioViewer.class.getClassLoader();
            InputStream is = loader.getResourceAsStream("standalone.properties");
            if (is != null) {
                p.load(is);
            }
            Config.initializeStandalone((BlueJPropStringSource)new StandalonePropStringManager(p));
            if (is != null) {
                is.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildGUI(boolean hideControls) {
        UnfocusableScrollPane worldViewScroll = new UnfocusableScrollPane((Node)new StackPane(new Node[]{this.worldDisplay}));
        JavaFXUtil.expandScrollPaneContent((ScrollPane)worldViewScroll);
        this.setCenter((Node)worldViewScroll);
        if (!hideControls) {
            this.setBottom((Node)this.controls);
        }
    }

    public GreenfootScenarioViewer() {
        GreenfootScenarioViewer.initProperties();
        String worldClassName = Config.getPropString((String)"main.class");
        boolean lockScenario = Config.getPropBoolean((String)"scenario.lock");
        boolean hideControls = Config.getPropBoolean((String)"scenario.hideControls", (boolean)false);
        try {
            GreenfootUtil.initialise(new GreenfootUtilDelegateStandAlone());
            this.properties = new ExportedProjectProperties();
            ActorDelegateStandAlone.setupAsActorDelegate();
            ActorDelegateStandAlone.initProperties(this.properties);
            Simulation.initialize();
            this.guiSetup(lockScenario, worldClassName);
            WorldHandler worldHandler = WorldHandler.getInstance();
            Class<?> worldClass = Class.forName(worldClassName);
            this.worldConstructor = worldClass.getConstructor(new Class[0]);
            World world = this.instantiateNewWorld();
            if (!worldHandler.checkWorldSet()) {
                worldHandler.setWorld(world, false);
            }
            this.buildGUI(hideControls);
            this.controls.updateState(GreenfootStage.State.PAUSED, false);
            JavaFXUtil.onceNotNull((ObservableValue)this.sceneProperty(), scene -> scene.addEventFilter(KeyEvent.ANY, e -> {
                if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                    worldHandler.getKeyboardManager().keyPressed(e.getCode(), e.getText());
                } else if (e.getEventType() == KeyEvent.KEY_RELEASED) {
                    worldHandler.getKeyboardManager().keyReleased(e.getCode(), e.getText());
                } else if (e.getEventType() == KeyEvent.KEY_TYPED) {
                    worldHandler.getKeyboardManager().keyTyped(e.getCode(), e.getText());
                }
            }));
            this.worldDisplay.addEventFilter(MouseEvent.ANY, e -> {
                MouseButton button = e.getButton();
                if (Config.isMacOS() && button == MouseButton.PRIMARY && e.isControlDown()) {
                    button = MouseButton.SECONDARY;
                }
                if (e.getEventType() == MouseEvent.MOUSE_CLICKED) {
                    worldHandler.getMouseManager().mouseClicked((int)e.getX(), (int)e.getY(), button, e.getClickCount());
                } else if (e.getEventType() == MouseEvent.MOUSE_MOVED) {
                    worldHandler.getMouseManager().mouseMoved((int)e.getX(), (int)e.getY());
                } else if (e.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                    worldHandler.getMouseManager().mouseDragged((int)e.getX(), (int)e.getY(), button);
                } else if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    worldHandler.getMouseManager().mousePressed((int)e.getX(), (int)e.getY(), button);
                } else if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                    worldHandler.getMouseManager().mouseReleased((int)e.getX(), (int)e.getY(), button);
                } else if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                    worldHandler.getMouseManager().mouseExited();
                }
            });
            if (hideControls) {
                Simulation.getInstance().setPaused(false);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e2) {
            e2.printStackTrace();
        }
    }

    private void guiSetup(boolean lockScenario, String worldClassName) {
        WorldHandler.initialise(new WorldHandlerDelegateStandAlone(this, lockScenario));
        WorldHandler worldHandler = WorldHandler.getInstance();
        this.sim = Simulation.getInstance();
        this.sim.attachWorldHandler(worldHandler);
        this.controls = new ControlPanel(this, null);
        if (lockScenario) {
            this.controls.lockControls();
        }
        this.sim.addSimulationListener(SoundFactory.getInstance().getSoundCollection());
        this.sim.addSimulationListener(this);
        try {
            int initialSpeed = this.properties.getInt("simulation.speed");
            this.sim.setSpeed(initialSpeed);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @OnThread(value=Tag.Any)
    public World instantiateNewWorld() {
        try {
            World world = (World)this.worldConstructor.newInstance(new Object[0]);
            return world;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
        return null;
    }

    @OnThread(value=Tag.Simulation)
    public String ask(String prompt) {
        CompletableFuture answer = new CompletableFuture();
        Platform.runLater(() -> this.worldDisplay.ensureAsking(prompt, (FXPlatformConsumer<String>)((FXPlatformConsumer)answer::complete)));
        try {
            return (String)answer.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void act() {
        Simulation.getInstance().runOnce();
    }

    @Override
    public void doRunPause() {
        Simulation.getInstance().togglePaused();
    }

    @Override
    public void userReset() {
        Simulation.getInstance().setEnabled(false);
        WorldHandler.getInstance().discardWorld();
        WorldHandler.getInstance().instantiateNewWorld(null);
    }

    @Override
    public void setSpeedFromSlider(int speed) {
        if (!this.updatingSliderFromSimulation) {
            Simulation.getInstance().setSpeed(speed);
        }
    }

    public void setWorldImage(BufferedImage worldImage) {
        if (this.worldDisplay.setImage(GreenfootScenarioViewer.bufferedImageToFX(worldImage))) {
            this.worldDisplay.getScene().getWindow().sizeToScene();
        }
    }

    private static Image bufferedImageToFX(BufferedImage worldImage) {
        WritableImage fxImage = new WritableImage(worldImage.getWidth(), worldImage.getHeight());
        int[] raw = ((DataBufferInt)worldImage.getData().getDataBuffer()).getData();
        int offset = 0;
        for (int y = 0; y < worldImage.getHeight(); ++y) {
            for (int x = 0; x < worldImage.getWidth(); ++x) {
                fxImage.getPixelWriter().setArgb(x, y, raw[offset++]);
            }
        }
        return fxImage;
    }

    @Override
    @OnThread(value=Tag.Simulation)
    public void simulationChangedSync(SimulationListener.SyncEvent eventType) {
        if (eventType == SimulationListener.SyncEvent.STARTED) {
            Platform.runLater(() -> this.controls.updateState(GreenfootStage.State.RUNNING, false));
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationChangedAsync(SimulationListener.AsyncEvent eventType) {
        if (eventType == SimulationListener.AsyncEvent.STOPPED) {
            Platform.runLater(() -> this.controls.updateState(GreenfootStage.State.PAUSED, false));
        } else if (eventType == SimulationListener.AsyncEvent.DISABLED) {
            Platform.runLater(() -> this.controls.updateState(GreenfootStage.State.NO_WORLD, false));
        } else if (eventType == SimulationListener.AsyncEvent.CHANGED_SPEED) {
            Platform.runLater(() -> {
                this.updatingSliderFromSimulation = true;
                this.controls.setSpeed(Simulation.getInstance().getSpeed());
                this.updatingSliderFromSimulation = false;
            });
        }
    }
}

