/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.Config;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.editor.Editor;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.DocPathEntry;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import greenfoot.core.GreenfootLauncherDebugVM;
import greenfoot.core.GreenfootMain;
import greenfoot.util.Version;
import greenfoot.vmcomm.GreenfootDebugHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ProjectManager {
    private static ProjectManager instance;
    private String launchClass = GreenfootLauncherDebugVM.class.getName();
    private static final String launcherName = "greenfootLauncher";
    private static volatile boolean launchFailed;
    private static FilenameFilter classFilter;

    private ProjectManager() {
    }

    public static ProjectManager instance() {
        if (instance == null) {
            instance = new ProjectManager();
        }
        return instance;
    }

    @OnThread(value=Tag.FXPlatform)
    public void launchProject(Project project) {
        ProjectAPIVersionAccess projectAPIVersionAccess = new ProjectAPIVersionAccess();
        GreenfootMain.VersionCheckInfo versionOK = this.checkVersion(project, projectAPIVersionAccess);
        if (versionOK.versionInfo != GreenfootMain.VersionInfo.VERSION_BAD) {
            try {
                File apiDir;
                File langlib;
                if (versionOK.versionInfo == GreenfootMain.VersionInfo.VERSION_UPDATED) {
                    project.getPackage("").reload();
                    if (versionOK.removeAWTImports) {
                        for (ClassTarget ctarget : project.getPackage("").getClassTargets()) {
                            Editor ed = ctarget.getEditor();
                            if (ed == null) continue;
                            ed.removeImports(Arrays.asList("java.awt.Color", "java.awt.Font"));
                        }
                        project.scheduleCompilation(true, CompileReason.EARLY, CompileType.INTERNAL_COMPILE, project.getPackage(""));
                    }
                }
                GreenfootDebugHandler.addDebuggerListener(project);
                List sourcePath = project.getSourcePath();
                String language = Config.getPropString((String)"bluej.language");
                if (!language.equals("english")) {
                    langlib = new File(Config.getBlueJLibDir(), language);
                    apiDir = new File(new File(langlib, "greenfoot"), "api");
                    sourcePath.add(new DocPathEntry(apiDir, ""));
                }
                langlib = new File(Config.getBlueJLibDir(), "english");
                apiDir = new File(new File(langlib, "greenfoot"), "api");
                sourcePath.add(new DocPathEntry(apiDir, ""));
            }
            catch (IOException e) {
                Debug.reportError((String)"Could not create greenfoot launcher.", (Throwable)e);
                ProjectManager.greenfootLaunchFailed(project);
            }
        } else {
            Project.cleanUp((Project)project);
        }
    }

    public static boolean checkLaunchFailed() {
        return launchFailed;
    }

    @OnThread(value=Tag.FXPlatform)
    public static void greenfootLaunchFailed(Project project) {
        launchFailed = true;
        String text = Config.getString((String)"greenfoot.launchFailed");
        DialogManager.showErrorTextFX(null, (String)text);
        System.exit(1);
    }

    @OnThread(value=Tag.FXPlatform)
    private GreenfootMain.VersionCheckInfo checkVersion(Project project, ProjectAPIVersionAccess projectAPIVersionAccess) {
        File greenfootLibDir = Config.getGreenfootLibDir();
        Version projectVersion = projectAPIVersionAccess.getAPIVersion(project);
        Version apiVersion = GreenfootMain.getAPIVersion();
        String greenfootApiVersion = "3.1.0";
        if (projectVersion.isBad()) {
            String message = projectVersion.getBadMessage();
            DialogManager.showInfoTextFX(null, (String)Config.getString((String)"project.version.mismatch"), (String)message, (boolean)false);
            Debug.message((String)("Bad version number in project: " + String.valueOf(greenfootLibDir)));
            ProjectManager.prepareGreenfootProject(greenfootLibDir, project, projectAPIVersionAccess, true, greenfootApiVersion);
            return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_UPDATED, false);
        }
        if (projectVersion.isOlderAndBreaking(apiVersion)) {
            boolean removeAWTImports;
            Object message = projectVersion.getChangesMessage(apiVersion);
            if (projectVersion.crosses300Boundary(apiVersion)) {
                removeAWTImports = DialogManager.askQuestionFX(null, (String)"greenfoot-importfix-question", (String)(message = (String)message + "\n")) == 0;
            } else {
                DialogManager.showInfoTextFX(null, (String)Config.getString((String)"project.version.mismatch"), (String)message, (boolean)false);
                removeAWTImports = false;
            }
            ProjectManager.prepareGreenfootProject(greenfootLibDir, project, projectAPIVersionAccess, true, greenfootApiVersion);
            return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_UPDATED, removeAWTImports);
        }
        if (apiVersion.isOlderAndBreaking(projectVersion)) {
            String message = projectVersion.getNewerMessage();
            int buttonIndex = DialogManager.showInfoTextFX(null, (String)Config.getString((String)"project.version.mismatch"), (String)message, (boolean)true);
            if (buttonIndex == 0) {
                return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_BAD, false);
            }
            ProjectManager.prepareGreenfootProject(greenfootLibDir, project, projectAPIVersionAccess, true, greenfootApiVersion);
            return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_UPDATED, false);
        }
        if (projectVersion.isNonBreaking(apiVersion)) {
            ProjectManager.prepareGreenfootProject(greenfootLibDir, project, projectAPIVersionAccess, true, greenfootApiVersion);
            return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_UPDATED, false);
        }
        if (projectVersion.isInternal(apiVersion)) {
            ProjectManager.prepareGreenfootProject(greenfootLibDir, project, projectAPIVersionAccess, false, greenfootApiVersion);
            return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_UPDATED, false);
        }
        ProjectManager.prepareGreenfootProject(greenfootLibDir, project, projectAPIVersionAccess, false, greenfootApiVersion);
        return new GreenfootMain.VersionCheckInfo(GreenfootMain.VersionInfo.VERSION_OK, false);
    }

    @OnThread(value=Tag.FXPlatform)
    private static void prepareGreenfootProject(File greenfootLibDir, Project project, ProjectAPIVersionAccess p, boolean deleteClassFiles, String greenfootApiVersion) {
        File dst = project.getProjectDir();
        File greenfootDir = new File(dst, "greenfoot");
        ProjectManager.deleteGreenfootDir(greenfootDir);
        if (deleteClassFiles) {
            ProjectManager.deleteAllClassFiles(dst);
        }
        try {
            File pkhFile;
            File pkgFile = new File(dst, "bluej.pkg");
            if (pkgFile.exists()) {
                pkgFile.delete();
            }
            if ((pkhFile = new File(dst, "bluej.pkh")).exists()) {
                pkhFile.delete();
            }
        }
        catch (SecurityException pkgFile) {
            // empty catch block
        }
        try {
            File images = new File(dst, "images");
            images.mkdir();
            File sounds = new File(dst, "sounds");
            sounds.mkdir();
        }
        catch (SecurityException e) {
            Debug.reportError((String)"SecurityException when trying to create images/sounds directories", (Throwable)e);
        }
        p.setAPIVersionAndSave(project, greenfootApiVersion);
    }

    private static void deleteAllClassFiles(File dir) {
        String[] classFiles = dir.list(classFilter);
        if (classFiles == null) {
            return;
        }
        for (int i = 0; i < classFiles.length; ++i) {
            String fileName = classFiles[i];
            int index = fileName.lastIndexOf(46);
            String javaFileName = fileName.substring(0, index) + "." + SourceType.Java.toString().toLowerCase();
            File file = new File(dir, fileName);
            File javaFile = new File(dir, javaFileName);
            if (!javaFile.exists()) continue;
            file.delete();
        }
    }

    private static void deleteGreenfootDir(File greenfootDir) {
        if (greenfootDir.exists()) {
            File worldJava2;
            File actorJava2;
            try {
                actorJava2 = new File(greenfootDir, "Actor.java");
                if (actorJava2.exists()) {
                    actorJava2.delete();
                }
            }
            catch (SecurityException actorJava2) {
                // empty catch block
            }
            try {
                worldJava2 = new File(greenfootDir, "World.java");
                if (worldJava2.exists()) {
                    worldJava2.delete();
                }
            }
            catch (SecurityException worldJava2) {
                // empty catch block
            }
            try {
                actorJava2 = new File(greenfootDir, "Actor.class");
                if (actorJava2.exists()) {
                    actorJava2.delete();
                }
            }
            catch (SecurityException actorJava3) {
                // empty catch block
            }
            try {
                worldJava2 = new File(greenfootDir, "World.class");
                if (worldJava2.exists()) {
                    worldJava2.delete();
                }
            }
            catch (SecurityException worldJava3) {
                // empty catch block
            }
            try {
                worldJava2 = new File(greenfootDir, "project.greenfoot");
                if (worldJava2.exists()) {
                    worldJava2.delete();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                greenfootDir.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void openGreenfoot(final Project project, final GreenfootDebugHandler greenfootDebugHandler) {
        File shmFile = greenfootDebugHandler.getShmFile();
        Properties debugVMProps = new Properties();
        for (String prop : List.of("bluej.language", "vm.language", "vm.country", "greenfoot.sound.device.input", "greenfoot.sound.device.output")) {
            debugVMProps.put(prop, Config.getPropString((String)prop, (String)""));
        }
        File tmpPropsFile = null;
        try {
            tmpPropsFile = File.createTempFile("debugvm", "props");
            tmpPropsFile.deleteOnExit();
            debugVMProps.store(new FileOutputStream(tmpPropsFile), "");
        }
        catch (IOException e) {
            Debug.reportError((Throwable)e);
        }
        String[] consParams = new String[]{project.getProjectDir().getPath(), Config.getBlueJLibDir().getAbsolutePath(), Config.getUserConfigDir().getAbsolutePath(), tmpPropsFile == null ? "" : tmpPropsFile.getAbsolutePath(), shmFile == null ? "" : shmFile.getAbsolutePath(), Integer.toString(greenfootDebugHandler.getShmFileSize()), Integer.toString(greenfootDebugHandler.getLastSeq())};
        final Package pkg = project.getPackage("");
        final Debugger debugger = pkg.getProject().getDebugger();
        final String[] argTypes = new String[consParams.length];
        final DebuggerObject[] argObjects = new DebuggerObject[consParams.length];
        for (int i = 0; i < consParams.length; ++i) {
            argTypes[i] = "java.lang.String";
            argObjects[i] = debugger.getMirror(consParams[i]);
        }
        new Thread("Opening Greenfoot"){

            @Override
            public void run() {
                DebuggerResult result = debugger.instantiateClass(ProjectManager.this.launchClass, argTypes, argObjects);
                Platform.runLater(() -> {
                    int status;
                    DebuggerObject debugObject = result.getResultObject();
                    if (debugObject != null) {
                        String wrappedName = greenfootDebugHandler.addObject(debugObject, debugObject.getGenType(), ProjectManager.launcherName);
                        pkg.getDebugger().addObject(pkg.getQualifiedName(), wrappedName, debugObject);
                        pkg.compileOnceIdle(null, CompileReason.LOADED, CompileType.INTERNAL_COMPILE);
                    }
                    if ((status = result.getExitStatus()) == 2) {
                        Debug.message((String)("Greenfoot launch failed due to exception in debug VM: " + result.getException().getText()));
                        ProjectManager.greenfootLaunchFailed(project);
                    } else if (status == 3 || status == 4) {
                        Debug.message((String)"Greenfoot launch failed due to debug VM terminating.");
                        ProjectManager.greenfootLaunchFailed(project);
                    }
                });
            }
        }.start();
    }

    static {
        launchFailed = false;
        classFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".class");
            }
        };
    }

    @OnThread(value=Tag.FXPlatform)
    public static class ProjectAPIVersionAccess {
        public Version getAPIVersion(Project project) {
            String versionString = project.getUnnamedPackage().getLastSavedProperties().getProperty("version");
            return new Version(versionString);
        }

        public void setAPIVersionAndSave(Project project, String version) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)project.getUnnamedPackage().getLastSavedProperties());
            if (!version.equals(props.get("version"))) {
                props.put("version", version);
                project.getUnnamedPackage().save(props);
            }
        }
    }
}

