/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.GreenfootImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class ImageCache {
    private static ImageCache instance = new ImageCache();
    private Map<String, CachedImageRef> imageCache = new HashMap<String, CachedImageRef>();
    private ReferenceQueue<GreenfootImage> imgCacheRefQueue = new ReferenceQueue();

    public static ImageCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCachedImage(String fileName, GreenfootImage image) {
        Map<String, CachedImageRef> map = this.imageCache;
        synchronized (map) {
            if (image != null) {
                CachedImageRef cr = new CachedImageRef(this, fileName, image, this.imgCacheRefQueue);
                this.imageCache.put(fileName, cr);
            } else {
                this.imageCache.put(fileName, null);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GreenfootImage getCachedImage(String fileName) {
        Map<String, CachedImageRef> map = this.imageCache;
        synchronized (map) {
            this.flushImgCacheRefQueue();
            CachedImageRef sr = this.imageCache.get(fileName);
            if (sr != null) {
                return (GreenfootImage)sr.get();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedImage(String fileName) {
        Map<String, CachedImageRef> map = this.imageCache;
        synchronized (map) {
            CachedImageRef cr = this.imageCache.remove(fileName);
            if (cr != null) {
                cr.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNullCachedImage(String fileName) {
        Map<String, CachedImageRef> map = this.imageCache;
        synchronized (map) {
            return this.imageCache.containsKey(fileName) && this.imageCache.get(fileName) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImageCache() {
        Map<String, CachedImageRef> map = this.imageCache;
        synchronized (map) {
            this.imageCache.clear();
            this.imgCacheRefQueue = new ReferenceQueue();
        }
    }

    private void flushImgCacheRefQueue() {
        Reference<GreenfootImage> ref = this.imgCacheRefQueue.poll();
        while (ref != null) {
            if (ref instanceof CachedImageRef) {
                CachedImageRef cr = (CachedImageRef)ref;
                this.imageCache.remove(cr.imgName);
            }
            ref = this.imgCacheRefQueue.poll();
        }
    }

    private class CachedImageRef
    extends SoftReference<GreenfootImage> {
        String imgName;

        public CachedImageRef(ImageCache imageCache, String imgName, GreenfootImage image, ReferenceQueue<GreenfootImage> queue) {
            super(image, queue);
            this.imgName = imgName;
        }
    }
}

