/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.Actor;
import greenfoot.ActorRemovedFromWorld;
import greenfoot.Color;
import greenfoot.GreenfootImage;
import greenfoot.TreeActorSet;
import greenfoot.collision.ColManager;
import greenfoot.collision.CollisionChecker;
import greenfoot.collision.ibsp.Rect;
import greenfoot.core.TextLabel;
import greenfoot.core.WorldHandler;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class World {
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private CollisionChecker collisionChecker = new ColManager();
    private TreeActorSet objectsDisordered = new TreeActorSet();
    private TreeActorSet objectsInPaintOrder;
    private TreeActorSet objectsInActOrder;
    List<TextLabel> textLabels = new ArrayList<TextLabel>();
    final int cellSize;
    final int width;
    final int height;
    private GreenfootImage backgroundImage;
    private boolean backgroundIsClassImage = true;
    private boolean isBounded;

    public World(int worldWidth, int worldHeight, int cellSize) {
        this(worldWidth, worldHeight, cellSize, true);
    }

    public World(int worldWidth, int worldHeight, int cellSize, boolean bounded) {
        this.width = worldWidth;
        this.height = worldHeight;
        this.cellSize = cellSize;
        this.collisionChecker.initialize(worldWidth, worldHeight, cellSize, false);
        this.isBounded = bounded;
        this.backgroundIsClassImage = true;
        this.setBackground(this.getClassImage());
        WorldHandler wHandler = WorldHandler.getInstance();
        if (wHandler != null) {
            wHandler.setInitialisingWorld(this);
        }
    }

    public final void setBackground(GreenfootImage image) {
        if (image != null) {
            boolean tile;
            int imgWidth = image.getWidth();
            int imgHeight = image.getHeight();
            int worldWidth = this.getWidthInPixels();
            int worldHeight = this.getHeightInPixels();
            boolean bl = tile = imgWidth < worldWidth || imgHeight < worldHeight;
            if (tile) {
                this.backgroundIsClassImage = false;
                this.backgroundImage = new GreenfootImage(worldWidth, worldHeight);
                this.backgroundImage.setColor(DEFAULT_BACKGROUND_COLOR);
                this.backgroundImage.fill();
                for (int x = 0; x < worldWidth; x += imgWidth) {
                    for (int y = 0; y < worldHeight; y += imgHeight) {
                        this.backgroundImage.drawImage(image, x, y);
                    }
                }
            } else {
                this.backgroundImage = image;
            }
        } else {
            this.backgroundIsClassImage = false;
            this.backgroundImage = null;
        }
    }

    public final void setBackground(String filename) throws IllegalArgumentException {
        GreenfootImage bg = new GreenfootImage(filename);
        this.setBackground(bg);
    }

    public GreenfootImage getBackground() {
        if (this.backgroundImage == null) {
            this.backgroundImage = new GreenfootImage(this.getWidthInPixels(), this.getHeightInPixels());
            this.backgroundImage.setColor(DEFAULT_BACKGROUND_COLOR);
            this.backgroundImage.fill();
            this.backgroundIsClassImage = false;
        } else if (this.backgroundIsClassImage) {
            this.backgroundImage = this.backgroundImage.getCopyOnWriteClone();
            this.backgroundIsClassImage = false;
        }
        return this.backgroundImage;
    }

    public Color getColorAt(int x, int y) {
        this.ensureWithinXBounds(x);
        this.ensureWithinYBounds(y);
        int xPixel = (int)Math.floor(this.getCellCenter(x));
        int yPixel = (int)Math.floor(this.getCellCenter(y));
        if (xPixel >= this.backgroundImage.getWidth()) {
            return DEFAULT_BACKGROUND_COLOR;
        }
        if (yPixel >= this.backgroundImage.getHeight()) {
            return DEFAULT_BACKGROUND_COLOR;
        }
        return this.backgroundImage.getColorAt(xPixel, yPixel);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setPaintOrder(Class ... classes) {
        if (classes == null) {
            if (this.objectsInPaintOrder == this.objectsDisordered) {
                if (this.objectsInActOrder == null) {
                    classes = new Class[]{};
                    this.objectsDisordered.setClassOrder(true, classes);
                } else {
                    this.objectsDisordered = this.objectsInActOrder;
                }
            }
            this.objectsInPaintOrder = null;
            return;
        }
        if (this.objectsInPaintOrder == null) {
            if (this.objectsInActOrder == this.objectsDisordered) {
                this.objectsInPaintOrder = new TreeActorSet();
                this.objectsInPaintOrder.setClassOrder(true, classes);
                this.objectsInPaintOrder.addAll(this.objectsDisordered);
                return;
            }
            this.objectsInPaintOrder = this.objectsDisordered;
        }
        this.objectsInPaintOrder.setClassOrder(true, classes);
    }

    public void setActOrder(Class ... classes) {
        if (classes == null) {
            if (this.objectsInActOrder == this.objectsDisordered) {
                if (this.objectsInPaintOrder == null) {
                    classes = new Class[]{};
                    this.objectsDisordered.setClassOrder(false, classes);
                } else {
                    this.objectsDisordered = this.objectsInPaintOrder;
                }
            }
            this.objectsInActOrder = null;
            return;
        }
        if (this.objectsInActOrder == null) {
            if (this.objectsInPaintOrder == this.objectsDisordered) {
                this.objectsInActOrder = new TreeActorSet();
                this.objectsInActOrder.setClassOrder(false, classes);
                this.objectsInActOrder.addAll(this.objectsDisordered);
                return;
            }
            this.objectsInActOrder = this.objectsDisordered;
        }
        this.objectsInActOrder.setClassOrder(false, classes);
    }

    public void addObject(Actor object, int x, int y) {
        if (object.world != null) {
            if (object.world == this) {
                return;
            }
            object.world.removeObject(object);
        }
        this.objectsDisordered.add(object);
        this.addInPaintOrder(object);
        this.addInActOrder(object);
        object.addToWorld(x, y, this);
        this.collisionChecker.addObject(object);
        object.addedToWorld(this);
        WorldHandler whInstance = WorldHandler.getInstance();
        if (whInstance != null) {
            WorldHandler.getInstance().objectAddedToWorld(object);
        }
    }

    public void removeObject(Actor object) {
        if (object == null || object.world != this) {
            return;
        }
        this.objectsDisordered.remove(object);
        this.collisionChecker.removeObject(object);
        if (this.objectsDisordered != this.objectsInActOrder && this.objectsInActOrder != null) {
            this.objectsInActOrder.remove(object);
        } else if (this.objectsDisordered != this.objectsInPaintOrder && this.objectsInPaintOrder != null) {
            this.objectsInPaintOrder.remove(object);
        }
        object.setWorld(null, new ActorRemovedFromWorld());
    }

    public void removeObjects(Collection<? extends Actor> objects) {
        for (Actor actor : objects) {
            this.removeObject(actor);
        }
    }

    public <A> List<A> getObjects(Class<A> cls) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        for (Actor actor : this.objectsDisordered) {
            if (cls != null && !cls.isInstance(actor)) continue;
            result.add(actor);
        }
        return result;
    }

    public int numberOfObjects() {
        return this.objectsDisordered.size();
    }

    public void repaint() {
        WorldHandler instance = WorldHandler.getInstance();
        if (instance != null) {
            instance.repaintAndWait();
        }
    }

    public void act() {
    }

    public void started() {
    }

    public void stopped() {
    }

    public <A> List<A> getObjectsAt(int x, int y, Class<A> cls) {
        return this.collisionChecker.getObjectsAt(x, y, cls);
    }

    public void showText(String text, int x, int y) {
        Iterator<TextLabel> i = this.textLabels.iterator();
        while (i.hasNext()) {
            TextLabel label = i.next();
            if (label.getX() != x || label.getY() != y) continue;
            if (label.getText().equals(text)) {
                return;
            }
            i.remove();
            break;
        }
        if (text != null && text.length() != 0) {
            this.textLabels.add(new TextLabel(text, x, y));
        }
    }

    GreenfootImage getBackgroundNoInit() {
        return this.backgroundImage;
    }

    boolean isBounded() {
        return this.isBounded;
    }

    <A> List<A> getIntersectingObjects(Actor actor, Class<A> cls) {
        return this.collisionChecker.getIntersectingObjects(actor, cls);
    }

    <A> List<A> getObjectsInRange(int x, int y, int r, Class<A> cls) {
        return this.collisionChecker.getObjectsInRange(x, y, r, cls);
    }

    <A> List<A> getNeighbours(Actor actor, int distance, boolean diag, Class<A> cls) {
        if (distance < 0) {
            throw new IllegalArgumentException("Distance must not be less than 0. It was: " + distance);
        }
        return this.collisionChecker.getNeighbours(actor, distance, diag, cls);
    }

    <A> List<A> getObjectsInDirection(int x0, int y0, int angle, int length, Class<A> cls) {
        return this.collisionChecker.getObjectsInDirection(x0, y0, angle, length, cls);
    }

    int getHeightInPixels() {
        return this.height * this.cellSize;
    }

    int getWidthInPixels() {
        return this.width * this.cellSize;
    }

    int toCellCeil(int pixel) {
        return (int)Math.ceil((double)pixel / (double)this.cellSize);
    }

    @OnThread(value=Tag.Any)
    int toCellFloor(int pixel) {
        return (int)Math.floor((double)pixel / (double)this.cellSize);
    }

    double getCellCenter(int l) {
        double cellCenter = (double)(l * this.cellSize) + (double)this.cellSize / 2.0;
        return cellCenter;
    }

    Collection<Actor> getObjectsAtPixel(int x, int y) {
        LinkedList<Actor> result = new LinkedList<Actor>();
        TreeActorSet objects = this.getObjectsListInPaintOrder();
        for (Actor actor : objects) {
            Rect bounds = actor.getBoundingRect();
            if (x < bounds.getX() || x > bounds.getRight() || y < bounds.getY() || y > bounds.getTop() || !actor.containsPoint(x, y)) continue;
            result.add(actor);
        }
        return result;
    }

    void updateObjectLocation(Actor object, int oldX, int oldY) {
        this.collisionChecker.updateObjectLocation(object, oldX, oldY);
    }

    void updateObjectSize(Actor object) {
        this.collisionChecker.updateObjectSize(object);
    }

    void startSequence() {
        this.collisionChecker.startSequence();
    }

    Actor getOneObjectAt(Actor object, int dx, int dy, Class<?> cls) {
        return this.collisionChecker.getOneObjectAt(object, dx, dy, cls);
    }

    Actor getOneIntersectingObject(Actor object, Class<?> cls) {
        return this.collisionChecker.getOneIntersectingObject(object, cls);
    }

    TreeActorSet getObjectsListInPaintOrder() {
        if (this.objectsInPaintOrder != null) {
            return this.objectsInPaintOrder;
        }
        return this.objectsDisordered;
    }

    TreeActorSet getObjectsListInActOrder() {
        if (this.objectsInActOrder != null) {
            return this.objectsInActOrder;
        }
        return this.objectsDisordered;
    }

    void paintDebug(Graphics g) {
    }

    private GreenfootImage getClassImage() {
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            GreenfootImage image = null;
            try {
                image = Actor.getDelegate().getImage(clazz.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (image == null) continue;
            return image;
        }
        return null;
    }

    private void ensureWithinXBounds(int x) throws IndexOutOfBoundsException {
        if (x >= this.getWidth()) {
            throw new IndexOutOfBoundsException("The x-coordinate is: " + x + ". It must be smaller than: " + this.getWidth());
        }
        if (x < 0) {
            throw new IndexOutOfBoundsException("The x-coordinate is: " + x + ". It must be larger than: 0");
        }
    }

    private void ensureWithinYBounds(int y) throws IndexOutOfBoundsException {
        if (y >= this.getHeight()) {
            throw new IndexOutOfBoundsException("The y-coordinate is: " + y + ". It must be smaller than: " + this.getHeight());
        }
        if (y < 0) {
            throw new IndexOutOfBoundsException("The x-coordinate is: " + y + ". It must be larger than: 0");
        }
    }

    private void addInActOrder(Actor object) {
        if (this.objectsInActOrder != null) {
            this.objectsInActOrder.add(object);
        }
    }

    private void addInPaintOrder(Actor object) {
        if (this.objectsInPaintOrder != null) {
            this.objectsInPaintOrder.add(object);
        }
    }
}

