/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import java.util.AbstractSet;
import java.util.Iterator;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ActorSet
extends AbstractSet<Actor> {
    private ListNode listHeadTail = new ListNode(this);
    private ListNode[] hashMap = new ListNode[0];
    private int numActors = 0;
    private int myHashCode = 0;

    @Override
    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public @OnThread(value=Tag.Simulation, ignoreParent=true) int hashCode() {
        return this.myHashCode;
    }

    @Override
    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public @OnThread(value=Tag.Simulation, ignoreParent=true) boolean add(Actor actor) {
        if (this.containsActor(actor)) {
            return false;
        }
        ++this.numActors;
        ListNode newNode = new ListNode(this, actor, this.listHeadTail.prev);
        int seq = ActorVisitor.getSequenceNumber(actor);
        if (this.numActors >= 2 * this.hashMap.length) {
            this.resizeHashmap();
        } else {
            int hash = seq % this.hashMap.length;
            ListNode hashHead = this.hashMap[hash];
            this.hashMap[hash] = newNode;
            newNode.setHashListHead(hashHead);
        }
        this.myHashCode += seq;
        return true;
    }

    private void resizeHashmap() {
        this.hashMap = new ListNode[this.numActors];
        ListNode currentActor = this.listHeadTail.next;
        while (currentActor != this.listHeadTail) {
            int seq = ActorVisitor.getSequenceNumber(currentActor.actor);
            int hash = seq % this.numActors;
            ListNode hashHead = this.hashMap[hash];
            this.hashMap[hash] = currentActor;
            currentActor.setHashListHead(hashHead);
            currentActor = currentActor.next;
        }
    }

    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public @OnThread(value=Tag.Simulation, ignoreParent=true) boolean containsActor(Actor actor) {
        return this.getActorNode(actor) != null;
    }

    @Override
    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public @OnThread(value=Tag.Simulation, ignoreParent=true) boolean contains(Object o) {
        if (o instanceof Actor) {
            Actor a = (Actor)o;
            return this.containsActor(a);
        }
        return false;
    }

    private ListNode getActorNode(Actor actor) {
        if (this.hashMap.length == 0) {
            return null;
        }
        int seq = ActorVisitor.getSequenceNumber(actor);
        int hash = seq % this.hashMap.length;
        ListNode hashHead = this.hashMap[hash];
        if (hashHead == null) {
            return null;
        }
        if (hashHead.actor == actor) {
            return hashHead;
        }
        ListNode curNode = hashHead.nextHash;
        while (curNode != hashHead) {
            if (curNode.actor == actor) {
                return curNode;
            }
            curNode = curNode.nextHash;
        }
        return null;
    }

    public boolean remove(Actor actor) {
        ListNode actorNode = this.getActorNode(actor);
        if (actorNode != null) {
            this.remove(actorNode);
            this.myHashCode -= ActorVisitor.getSequenceNumber(actor);
            return true;
        }
        return false;
    }

    private void remove(ListNode actorNode) {
        int seq = ActorVisitor.getSequenceNumber(actorNode.actor);
        int hash = seq % this.hashMap.length;
        if (this.hashMap[hash] == actorNode) {
            this.hashMap[hash] = actorNode.nextHash;
            if (this.hashMap[hash] == actorNode) {
                this.hashMap[hash] = null;
            }
        }
        actorNode.remove();
        --this.numActors;
        if (this.numActors <= this.hashMap.length / 2) {
            this.resizeHashmap();
        }
    }

    @Override
    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public @OnThread(value=Tag.Simulation, ignoreParent=true) int size() {
        return this.numActors;
    }

    @Override
    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public @OnThread(value=Tag.Simulation, ignoreParent=true) Iterator<Actor> iterator() {
        return new ActorSetIterator();
    }

    @OnThread(value=Tag.Simulation)
    private class ListNode {
        Actor actor;
        ListNode next;
        ListNode prev;
        ListNode nextHash;
        ListNode prevHash;

        public ListNode(ActorSet actorSet) {
            this.next = this;
            this.prev = this;
        }

        public ListNode(ActorSet actorSet, Actor actor, ListNode listTail) {
            this.actor = actor;
            this.next = listTail.next;
            this.prev = listTail;
            listTail.next = this;
            this.next.prev = this;
        }

        public void setHashListHead(ListNode oldHead) {
            if (oldHead == null) {
                this.nextHash = this;
                this.prevHash = this;
            } else {
                this.nextHash = oldHead;
                this.prevHash = oldHead.prevHash;
                oldHead.prevHash = this;
                this.prevHash.nextHash = this;
            }
        }

        public void remove() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.nextHash.prevHash = this.prevHash;
            this.prevHash.nextHash = this.nextHash;
        }
    }

    @OnThread(value=Tag.Simulation)
    private class ActorSetIterator
    implements Iterator<Actor> {
        ListNode currentNode;

        public ActorSetIterator() {
            this.currentNode = ActorSet.this.listHeadTail;
        }

        @Override
        @OnThread(value=Tag.Simulation, ignoreParent=true)
        public @OnThread(value=Tag.Simulation, ignoreParent=true) boolean hasNext() {
            return this.currentNode.next != ActorSet.this.listHeadTail;
        }

        @Override
        @OnThread(value=Tag.Simulation, ignoreParent=true)
        public @OnThread(value=Tag.Simulation, ignoreParent=true) Actor next() {
            this.currentNode = this.currentNode.next;
            return this.currentNode.actor;
        }

        @Override
        @OnThread(value=Tag.Simulation, ignoreParent=true)
        public void remove() {
            ActorSet.this.remove(this.currentNode);
        }
    }
}

