/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.javafx.JavaFXUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class VersionCheckDialog
extends Dialog<Void> {
    private static final String dialogTitle = Config.getString("pkgmgr.versionDlg.title");
    private static final String helpLine1 = Config.getString("pkgmgr.versionDlg.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.versionDlg.helpLine2");
    private static final String versionURL = Config.getPropString("bluej.url.versionCheck");
    private TextArea textArea;
    private String newVersion = null;
    private Thread versionThread = null;
    private boolean isClosed = false;

    public VersionCheckDialog(Window parent) {
        this.setTitle(dialogTitle);
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        this.setDialogPane(new DialogPane(this){

            @OnThread(value=Tag.FX)
            protected Node createButtonBar() {
                ButtonBar buttonBar = (ButtonBar)super.createButtonBar();
                buttonBar.setButtonOrder("_C_");
                return buttonBar;
            }
        });
        Config.addDialogStylesheets((Pane)this.getDialogPane());
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        this.makeDialog();
    }

    private void doVersionCheck() {
        this.textArea.setText(Config.getString("pkgmgr.checkingVersion"));
        this.versionThread = new VersionChecker();
        this.versionThread.start();
    }

    private void makeDialog() {
        VBox mainPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPanel, "version-check-dialog-content");
        Label helpLabel = new Label(helpLine1 + " " + helpLine2);
        helpLabel.setWrapText(true);
        helpLabel.setMaxWidth(400.0);
        mainPanel.getChildren().add((Object)helpLabel);
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.textArea.setWrapText(true);
        this.textArea.setMaxWidth(400.0);
        mainPanel.getChildren().add((Object)this.textArea);
        this.getDialogPane().setContent((Node)mainPanel);
        this.doVersionCheck();
    }

    @OnThread(value=Tag.Any)
    private void setTextLater(String txt) {
        Platform.runLater(() -> this.textArea.setText(txt));
    }

    private class VersionChecker
    extends Thread {
        @OnThread(value=Tag.Any)
        public VersionChecker() {
            super("Version Checker");
        }

        @Override
        @OnThread(value=Tag.Worker, ignoreParent=true)
        public void run() {
            try {
                InputStream is = new URL(versionURL).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                if (this.isOutOfDate(reader)) {
                    if (!VersionCheckDialog.this.isClosed) {
                        this.displayNewVersionInfo(reader);
                    }
                } else if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.setTextLater(Config.getString("pkgmgr.versionDlg.upToDate"));
                }
            }
            catch (IOException exc) {
                if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.setTextLater("Error: could not access remote version information");
                }
                Debug.reportError("IO error when trying to access URL\n" + String.valueOf(exc));
            }
        }

        @OnThread(value=Tag.Worker)
        private boolean isOutOfDate(BufferedReader versionReader) {
            try {
                VersionCheckDialog.this.newVersion = versionReader.readLine();
                if (VersionCheckDialog.this.newVersion != null) {
                    VersionCheckDialog.this.newVersion = VersionCheckDialog.this.newVersion.trim();
                }
            }
            catch (IOException exc) {
                VersionCheckDialog.this.setTextLater("Error: could not read remote version information");
                Debug.reportError("IO error when reading remote version info\n" + String.valueOf(exc));
            }
            return !"5.4.1".equals(VersionCheckDialog.this.newVersion);
        }

        @OnThread(value=Tag.Worker)
        private void displayNewVersionInfo(BufferedReader versionReader) {
            if (VersionCheckDialog.this.newVersion == null) {
                VersionCheckDialog.this.setTextLater("Error: could not read remote version info");
            } else {
                StringBuffer text = new StringBuffer(Config.getString("pkgmgr.versionDlg.currentVersion"));
                text.append(" ");
                text.append("5.4.1");
                text.append("\n");
                text.append(Config.getString("pkgmgr.versionDlg.newVersion"));
                text.append(" ");
                text.append(VersionCheckDialog.this.newVersion);
                text.append("\n");
                try {
                    String line = versionReader.readLine();
                    while (line != null) {
                        text.append(line);
                        text.append("\n");
                        line = versionReader.readLine();
                    }
                }
                catch (IOException exc) {
                    Debug.reportError("IO error when reading from version file");
                }
                Platform.runLater(() -> {
                    VersionCheckDialog.this.textArea.setText(text.toString());
                    VersionCheckDialog.this.textArea.positionCaret(0);
                });
            }
        }
    }
}

