/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.JavaParser;
import bluej.parser.Token;
import bluej.parser.TokenStream;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.JavaTokenFilter;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.ExpressionNode;
import bluej.parser.nodes.FieldNode;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParentParsedNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.nodes.ReparseableDocument;
import bluej.parser.nodes.VariableDeclaration;
import bluej.utility.GeneralCache;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class JavaParentNode
extends ParentParsedNode
implements EntityResolver {
    protected GeneralCache<String, JavaEntity> valueEntityCache = new GeneralCache(10);
    protected GeneralCache<String, PackageOrClass> pocEntityCache = new GeneralCache(10);
    protected JavaParentNode parentNode;
    protected Map<String, ParsedNode> classNodes = new HashMap<String, ParsedNode>();
    protected Map<String, Set<VariableDeclaration>> variables = new HashMap<String, Set<VariableDeclaration>>();
    private boolean isSwitchBlockNode = false;

    public JavaParentNode(JavaParentNode parent) {
        super(parent);
        this.parentNode = parent;
    }

    @Override
    public JavaParentNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public void insertNode(ParsedNode child, int position, int size, NodeStructureListener nodeStructureListener) {
        super.insertNode(child, position, size, nodeStructureListener);
        int childType = child.getNodeType();
        String childName = child.getName();
        if (childName != null && childType == 1) {
            this.classNodes.put(childName, child);
        }
    }

    public void insertField(FieldNode child, int position, int size, NodeStructureListener nodeStructureListener) {
        super.insertNode(child, position, size, nodeStructureListener);
        Set<VariableDeclaration> varList = this.variables.get(child.getName());
        if (varList == null) {
            varList = new HashSet<VariableDeclaration>(1);
            this.variables.put(child.getName(), varList);
        }
        varList.add(child);
    }

    public void insertInstanceofVar(VariableDeclaration variableDeclaration) {
        this.variables.computeIfAbsent(variableDeclaration.getName(), s -> new HashSet(1)).add(variableDeclaration);
    }

    @Override
    public void childChangedName(ParsedNode child, String oldName) {
        super.childChangedName(child, oldName);
        if (child.getNodeType() == 1) {
            if (this.classNodes.get(oldName) == child) {
                this.classNodes.remove(oldName);
            }
            this.classNodes.put(child.getName(), child);
        }
        if (child.getNodeType() == 5) {
            Set<VariableDeclaration> varset = this.variables.get(oldName);
            if (varset != null) {
                varset.remove(child);
                if (varset.isEmpty()) {
                    this.variables.remove(oldName);
                }
            }
            if ((varset = this.variables.get(child.getName())) == null) {
                varset = new HashSet<VariableDeclaration>();
                this.variables.put(child.getName(), varset);
            }
            varset.add((FieldNode)child);
        }
    }

    @Override
    protected void childRemoved(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        super.childRemoved(child, listener);
        String childName = child.getNode().getName();
        if (childName != null) {
            Set<VariableDeclaration> varset;
            if (this.classNodes.get(childName) == child.getNode()) {
                this.classNodes.remove(childName);
            }
            if ((varset = this.variables.get(childName)) != null) {
                varset.remove(child.getNode());
                if (varset.isEmpty()) {
                    this.variables.remove(childName);
                }
            }
        }
    }

    public ParsedNode getTypeNode(String name) {
        return this.classNodes.get(name);
    }

    public void markAsSwitchBlockNode() {
        this.isSwitchBlockNode = true;
    }

    public boolean isSwitchBlockNode() {
        return this.isSwitchBlockNode;
    }

    @Override
    public TypeEntity resolveQualifiedClass(String name) {
        if (this.parentNode != null) {
            return this.parentNode.resolveQualifiedClass(name);
        }
        return null;
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        ParsedNode cnode = this.classNodes.get(name);
        if (cnode != null) {
            return new TypeEntity(new ParsedReflective((ParsedTypeNode)cnode));
        }
        String accessp = name + ":" + (querySource != null ? querySource.getName() : "");
        PackageOrClass rval = this.pocEntityCache.get(accessp);
        if (rval != null || this.pocEntityCache.containsKey(accessp)) {
            return rval;
        }
        if (this.parentNode != null) {
            rval = this.parentNode.resolvePackageOrClass(name, querySource);
            this.pocEntityCache.put(accessp, rval);
        }
        return rval;
    }

    @OnThread(value=Tag.FXPlatform)
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource, int fromPosition) {
        return this.resolvePackageOrClass(name, querySource);
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        VariableDeclaration var;
        TypeEntity fieldType;
        Set<VariableDeclaration> varset = this.variables.get(name);
        if (varset != null && !varset.isEmpty() && (fieldType = (var = varset.iterator().next()).getFieldType().resolveAsType()) != null) {
            return new ValueEntity(((JavaEntity)fieldType).getType());
        }
        String accessp = name + ":" + (querySource != null ? querySource.getName() : "");
        JavaEntity rval = this.valueEntityCache.get(accessp);
        if (rval != null || this.valueEntityCache.containsKey(accessp)) {
            return rval;
        }
        if (this.parentNode != null) {
            rval = this.parentNode.getValueEntity(name, querySource, this.getOffsetFromParent());
        }
        if (rval == null) {
            rval = this.resolvePackageOrClass(name, querySource, this.getOffsetFromParent());
        }
        this.valueEntityCache.put(accessp, rval);
        return rval;
    }

    @OnThread(value=Tag.FXPlatform)
    public JavaEntity getValueEntity(String name, Reflective querySource, int fromPosition) {
        return this.getValueEntity(name, querySource);
    }

    @OnThread(value=Tag.FXPlatform)
    protected JavaEntity getPositionedValueEntity(String name, Reflective querySource, int fromPosition) {
        Set<VariableDeclaration> varset = this.variables.get(name);
        if (varset != null) {
            List sortedVars = varset.stream().sorted(Comparator.comparingInt(v -> -v.getOffsetFromParent())).collect(Collectors.toList());
            for (VariableDeclaration var : sortedVars) {
                TypeEntity fieldType;
                if (var.getOffsetFromParent() > fromPosition || (fieldType = var.getFieldType().resolveAsType()) == null) continue;
                return new ValueEntity(((JavaEntity)fieldType).getType());
            }
        }
        JavaEntity rval = null;
        if (this.parentNode != null) {
            rval = this.parentNode.getValueEntity(name, querySource, this.getOffsetFromParent());
        }
        if (rval == null) {
            rval = this.resolvePackageOrClass(name, querySource, fromPosition);
        }
        return rval;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected ExpressionTypeInfo getExpressionType(int pos, int nodePos, JavaEntity defaultType, ReparseableDocument document, ExpressionNode largestPlainExpressionNode) {
        boolean isStaticCtxt;
        GenTypeClass atype;
        this.valueEntityCache.clear();
        this.pocEntityCache.clear();
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNodeAtOrBefore(pos, nodePos);
        if (child != null && child.getEnd() >= pos) {
            return child.getNode().getExpressionType(pos, child.getPosition(), defaultType, document, null);
        }
        int startpos = nodePos;
        if (child != null) {
            startpos = child.getEnd();
        }
        ReparseableDocument.Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(pos) + 1;
        ReparseableDocument.Element lineEl = map.getElement(line - 1);
        startpos = Math.max(startpos, lineEl.getStartOffset());
        int col = startpos - map.getElement(line - 1).getStartOffset() + 1;
        Reader r = document.makeReader(startpos, pos);
        JavaLexer lexer = new JavaLexer(r, line, col, startpos);
        JavaTokenFilter filter = new JavaTokenFilter(lexer);
        LocatableToken token = filter.nextToken();
        LocatableToken prevToken = null;
        while (token.getType() != 1) {
            prevToken = token;
            token = filter.nextToken();
        }
        if (prevToken != null && prevToken.getEndLine() != token.getEndLine() && prevToken.getEndColumn() != token.getEndColumn()) {
            prevToken = null;
        }
        if (prevToken != null && startpos == nodePos && this.parentNode != null) {
            ExpressionTypeInfo suggests;
            int offset = this.getOffsetFromParent();
            int ppos = nodePos - offset;
            child = this.parentNode.getNodeTree().findNodeAtOrBefore(nodePos - 1, ppos);
            if (child != null && child.getNode().getNodeType() == 6 && child.getEnd() == nodePos && (suggests = ExpressionNode.suggestAsExpression(pos, child.getPosition(), this, defaultType, document)) != null) {
                return suggests;
            }
        }
        GenTypeClass genTypeClass = atype = defaultType != null ? defaultType.getType().asClass() : null;
        if (atype == null) {
            return null;
        }
        boolean bl = isStaticCtxt = defaultType.resolveAsType() != null;
        if (prevToken != null && !Character.isJavaIdentifierPart(prevToken.getText().codePointAt(0))) {
            prevToken = null;
        }
        return new ExpressionTypeInfo(atype, atype, prevToken, isStaticCtxt, true);
    }

    @Override
    public ParsedNode.TokenAndScope getMarkTokensFor(int pos, int length, int nodePos, ReparseableDocument document) {
        int nextTokLen;
        NodeTree.NodeAndPosition<ParsedNode> np;
        Token tok = new Token(0, Token.TokenType.END);
        if (length == 0) {
            return new ParsedNode.TokenAndScope(tok, pos);
        }
        Token dummyTok = tok;
        for (np = this.getNodeTree().findNodeAtOrAfter(pos, nodePos); np != null && np.getEnd() == pos; np = np.nextSibling()) {
        }
        int startLatestNode = 0;
        int cp = pos;
        while (np != null && np.getPosition() < pos + length) {
            if (np.getPosition() <= pos) {
                startLatestNode = Math.max(startLatestNode, np.getPosition());
            }
            if (cp < np.getPosition()) {
                nextTokLen = np.getPosition() - cp;
                tok.next = JavaParentNode.tokenizeText(document, cp, nextTokLen);
                while (tok.next.id != Token.TokenType.END) {
                    tok = tok.next;
                }
                cp = np.getPosition();
            }
            int remaining = pos + length - cp;
            if ((remaining = Math.min(remaining, np.getEnd() - cp)) != 0) {
                ParsedNode.TokenAndScope tas = np.getNode().getMarkTokensFor(cp, remaining, np.getPosition(), document);
                if (tas.startLatestScope() <= pos) {
                    startLatestNode = Math.max(startLatestNode, tas.startLatestScope());
                }
                tok.next = tas.tokenLinkedList();
                cp += remaining;
                while (tok.next.id != Token.TokenType.END) {
                    tok = tok.next;
                }
            }
            np = np.nextSibling();
        }
        if (cp < pos + length) {
            nextTokLen = pos + length - cp;
            tok.next = JavaParentNode.tokenizeText(document, cp, nextTokLen);
            while (tok.next.id != Token.TokenType.END) {
                tok = tok.next;
            }
        }
        tok.next = new Token(0, Token.TokenType.END);
        return new ParsedNode.TokenAndScope(dummyTok.next, startLatestNode);
    }

    protected static Token tokenizeText(ReparseableDocument document, int pos, int length) {
        Token dummyTok;
        Reader dr = document.makeReader(pos, pos + length);
        TokenStream lexer = JavaParser.getLexer(dr, true, false);
        JavaTokenFilter tokenStream = new JavaTokenFilter(lexer, null);
        Token token = dummyTok = new Token(0, Token.TokenType.END);
        boolean lastWasWildcard = false;
        int curcol = 1;
        while (length > 0) {
            LocatableToken lt = tokenStream.nextToken();
            if (lt.getLine() > 1 || lt.getColumn() - curcol >= length) {
                token = token.next = new Token(length, Token.TokenType.DEFAULT);
                break;
            }
            if (lt.getColumn() > curcol) {
                token = token.next = new Token(lt.getColumn() - curcol, Token.TokenType.DEFAULT);
                length -= token.length;
                curcol += token.length;
            }
            Token.TokenType tokType = Token.TokenType.DEFAULT;
            if (JavaParser.isPrimitiveType(lt)) {
                tokType = Token.TokenType.PRIMITIVE;
            } else if (JavaParser.isModifier(lt)) {
                tokType = Token.TokenType.KEYWORD1;
            } else if (lt.getType() == 161 || lt.getType() == 175) {
                tokType = Token.TokenType.STRING_LITERAL;
            } else if (lt.getType() == 160) {
                tokType = Token.TokenType.CHAR_LITERAL;
            } else {
                switch (lt.getType()) {
                    case 105: 
                    case 108: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 145: 
                    case 158: 
                    case 174: {
                        tokType = Token.TokenType.KEYWORD1;
                        break;
                    }
                    case 62: 
                    case 64: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 106: 
                    case 176: 
                    case 179: {
                        tokType = Token.TokenType.KEYWORD2;
                        break;
                    }
                    case 72: {
                        if (lastWasWildcard) {
                            tokType = Token.TokenType.KEYWORD2;
                            break;
                        }
                        tokType = Token.TokenType.KEYWORD3;
                        break;
                    }
                    case 107: 
                    case 155: 
                    case 156: 
                    case 157: {
                        tokType = Token.TokenType.KEYWORD3;
                        break;
                    }
                }
            }
            lastWasWildcard = lt.getType() == 70;
            int toklen = lt.getLength();
            if (lt.getEndLine() > 1) {
                toklen = length;
            }
            token = token.next = new Token(toklen, tokType);
            length -= toklen;
            curcol += toklen;
        }
        token.next = new Token(0, Token.TokenType.END);
        return dummyTok.next;
    }

    public Map<String, Set<VariableDeclaration>> getLocVarNodes() {
        return Map.copyOf(this.variables);
    }
}

