/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.groupwork.HistoryInfo;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class HistoryCell
extends ListCell<HistoryInfo> {
    public void updateItem(HistoryInfo info, boolean empty) {
        super.updateItem((Object)info, empty);
        if (empty || info == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(info.getDate() + "  " + info.getRevision() + "\n" + info.getUser() + "\n" + info.getComment());
            this.setGraphic(this.getGraphics(info));
        }
    }

    private Node getGraphics(HistoryInfo info) {
        ObservableList files = FXCollections.observableArrayList((Object[])info.getFiles());
        ListView filesListView = new ListView(files);
        int ROW_HEIGHT = 24;
        filesListView.setPrefHeight((double)(files.size() * 24 + 2));
        return filesListView;
    }
}

