/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.git.GitRepository;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class GitCommand
implements TeamworkCommand {
    private boolean cancelled = false;
    private final GitRepository repository;

    @OnThread(value=Tag.Any)
    public GitCommand(GitRepository repository) {
        this.repository = repository;
    }

    public void disableFingerprintCheck(TransportCommand command) {
        if (command != null && (this.repository.getReposUrl().startsWith("ssh") || this.repository.getReposUrl().startsWith("http"))) {
            command.setCredentialsProvider((CredentialsProvider)this.getRepository().getCredentialsProvider());
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected GitRepository getRepository() {
        return this.repository;
    }
}

