/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.BlueJEvent;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions2.BObject;
import bluej.extensions2.InvocationArgumentException;
import bluej.extensions2.InvocationErrorException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

class DirectInvoker {
    private final PkgMgrFrame pkgFrame;
    private @OnThread(value=Tag.Any, requireSynchronized=true) String resultName;

    DirectInvoker(PkgMgrFrame i_pkgFrame) {
        this.pkgFrame = i_pkgFrame;
    }

    @OnThread(value=Tag.FXPlatform)
    OffThreadWaiter invokeConstructor(ConstructorView callable, Object[] args) throws InvocationArgumentException, InvocationErrorException {
        if (!this.paramsAlmostMatch(args, callable.getParameters())) {
            throw new InvocationArgumentException("invokeConstructor: bad arglist");
        }
        DirectResultWatcher watcher = new DirectResultWatcher(this);
        Invoker invoker = new Invoker(this.pkgFrame, callable, watcher);
        String[] argStrings = this.convObjToString(args);
        invoker.invokeDirect(argStrings);
        return () -> {
            DebuggerObject result = watcher.getResult();
            Platform.runLater(() -> {
                ExecutionEvent.Result resultType = watcher.getResultType();
                if (resultType != null) {
                    ExecutionEvent ee = new ExecutionEvent(this.pkgFrame.getPackage(), callable.getClassName(), null);
                    DirectInvoker.raiseEvent(ee, callable, argStrings, watcher, result);
                }
            });
            if (watcher.isFailed()) {
                throw new InvocationErrorException("invokeConstructor: Error=" + watcher.getError());
            }
            if (result == null) {
                throw new InvocationErrorException("invokeConstructor: ERROR: result==null");
            }
            DirectInvoker directInvoker = this;
            synchronized (directInvoker) {
                this.resultName = watcher.getResultName();
            }
            return result;
        };
    }

    @OnThread(value=Tag.FXPlatform)
    OffThreadWaiter invokeMethod(ObjectWrapper onThisObjectInstance, MethodView callable, Object[] args) throws InvocationArgumentException, InvocationErrorException {
        if (!this.paramsAlmostMatch(args, callable.getParameters())) {
            throw new InvocationArgumentException("invokeMethod: bad arglist");
        }
        DirectResultWatcher watcher = new DirectResultWatcher(this);
        Invoker invoker = callable.isStatic() ? new Invoker(this.pkgFrame, callable, watcher) : new Invoker(this.pkgFrame, callable, onThisObjectInstance.getName(), onThisObjectInstance.getObject(), watcher);
        String[] argStrings = this.convObjToString(args);
        invoker.invokeDirect(this.convObjToString(args));
        return () -> {
            DebuggerObject result = watcher.getResult();
            Platform.runLater(() -> {
                ExecutionEvent.Result resultType = watcher.getResultType();
                if (resultType != null) {
                    ExecutionEvent ee = new ExecutionEvent(this.pkgFrame.getPackage(), callable.getClassName(), onThisObjectInstance == null ? null : onThisObjectInstance.getName());
                    ee.setMethodName(callable.getName());
                    DirectInvoker.raiseEvent(ee, callable, argStrings, watcher, result);
                }
            });
            if (watcher.isFailed()) {
                throw new InvocationErrorException("invokeMethod: Error=" + watcher.getError());
            }
            DirectInvoker directInvoker = this;
            synchronized (directInvoker) {
                this.resultName = watcher.getResultName();
            }
            return result;
        };
    }

    private static void raiseEvent(ExecutionEvent event, CallableView callable, String[] argStrings, DirectResultWatcher watcher, DebuggerObject result) {
        ExecutionEvent.Result resultType = watcher.getResultType();
        event.setParameters(callable.getParamTypes(false), argStrings);
        event.setResult(resultType);
        if (resultType == ExecutionEvent.Result.NORMAL_EXIT) {
            event.setResultObject(result);
            event.setObjectName(watcher.getResultName());
        } else if (resultType == ExecutionEvent.Result.EXCEPTION_EXIT) {
            event.setException(watcher.getException());
        }
        BlueJEvent.raiseEvent(5, event);
    }

    @OnThread(value=Tag.Any)
    synchronized String getResultName() {
        return this.resultName;
    }

    private String[] convObjToString(Object[] i_array) {
        if (i_array == null) {
            return null;
        }
        if (i_array.length <= 0) {
            return new String[0];
        }
        String[] o_array = new String[i_array.length];
        for (int index = 0; index < i_array.length; ++index) {
            o_array[index] = this.convOneObj(i_array[index]);
        }
        return o_array;
    }

    private String convOneObj(Object i_obj) {
        if (i_obj == null) {
            return null;
        }
        if (i_obj instanceof String) {
            return "\"" + Utility.quoteString(i_obj.toString()) + "\"";
        }
        if (i_obj instanceof BObject) {
            return ((BObject)i_obj).getInstanceName();
        }
        return i_obj.toString();
    }

    private boolean paramsAlmostMatch(Object[] params, Class<?>[] paramClass) {
        if (params != null && params.length < 1) {
            params = null;
        }
        if (paramClass != null && paramClass.length < 1) {
            paramClass = null;
        }
        if (params == null && paramClass == null) {
            return true;
        }
        if (params == null || paramClass == null) {
            return false;
        }
        return params.length == paramClass.length;
    }

    class DirectResultWatcher
    implements ResultWatcher {
        private boolean resultReady = false;
        private @OnThread(value=Tag.Any, requireSynchronized=true) boolean isFailed = false;
        private ExecutionEvent.Result resultType;
        private DebuggerObject result = null;
        private ExceptionDescription exception;
        private @OnThread(value=Tag.Any, requireSynchronized=true) String errorMsg = null;
        private @OnThread(value=Tag.Any, requireSynchronized=true) String resultName;

        public DirectResultWatcher(DirectInvoker this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnThread(value=Tag.Worker)
        public synchronized DebuggerObject getResult() {
            while (!this.resultReady) {
                try {
                    this.wait();
                }
                catch (InterruptedException exc) {
                    DirectResultWatcher directResultWatcher = this;
                    synchronized (directResultWatcher) {
                        this.isFailed = true;
                    }
                    this.errorMsg = "getResult: Interrupt: Exception=" + exc.getMessage();
                    return null;
                }
            }
            return this.result;
        }

        @OnThread(value=Tag.Any)
        public synchronized boolean isFailed() {
            return this.isFailed;
        }

        @Override
        public void beginCompile() {
        }

        @Override
        public void beginExecution(InvokerRecord ir) {
        }

        @Override
        public synchronized void putResult(DebuggerObject aResult, String anObjectName, InvokerRecord ir) {
            this.result = aResult;
            this.resultType = ExecutionEvent.Result.NORMAL_EXIT;
            this.resultName = anObjectName;
            this.resultReady = true;
            this.notifyAll();
        }

        @Override
        public synchronized void putError(String error, InvokerRecord ir) {
            this.errorMsg = "Invocation: Error=" + error;
            this.isFailed = true;
            this.resultReady = true;
            this.notifyAll();
        }

        @Override
        public synchronized void putException(ExceptionDescription exception, InvokerRecord ir) {
            this.exception = exception;
            this.resultType = ExecutionEvent.Result.EXCEPTION_EXIT;
            this.putError(exception.getText(), ir);
        }

        @Override
        public void putVMTerminated(InvokerRecord ir, boolean terminatedByUserCode) {
            this.resultType = terminatedByUserCode ? ExecutionEvent.Result.NORMAL_EXIT : ExecutionEvent.Result.TERMINATED_EXIT;
            this.putError("Terminated", ir);
        }

        @OnThread(value=Tag.Any)
        public synchronized String getError() {
            return this.errorMsg;
        }

        @OnThread(value=Tag.Any)
        public String getResultName() {
            return this.resultName;
        }

        public ExecutionEvent.Result getResultType() {
            return this.resultType;
        }

        public ExceptionDescription getException() {
            return this.exception;
        }
    }

    static interface OffThreadWaiter {
        @OnThread(value=Tag.Worker)
        public DebuggerObject waitForResult() throws InvocationErrorException;
    }
}

