/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.editor.stride.FXTabbedEditor;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableStringValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.Menu;
import javafx.scene.control.Tab;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
abstract class FXTab
extends Tab {
    private final boolean showCatalogue;

    public FXTab(boolean showCatalogue) {
        this.showCatalogue = showCatalogue;
        this.setOnSelectionChanged(e -> JavaFXUtil.runAfterCurrent(this::focusWhenShown));
        this.setOnClosed(e -> this.setParent(null, false));
    }

    @OnThread(value=Tag.FX)
    protected static ImageView makeClassGraphicIcon(ObjectExpression<Image> imageExpression, int maxSize, boolean scaleUp) {
        ImageView imageView = new ImageView();
        FXConsumer<Image> imageChanged = image -> {
            if (image == null) {
                imageView.setFitWidth(0.0);
                imageView.setFitHeight(0.0);
            } else if (scaleUp) {
                imageView.setFitHeight((double)maxSize);
                imageView.setFitWidth((double)maxSize);
            } else {
                imageView.setFitHeight(Math.min(image.getHeight(), (double)maxSize));
                imageView.setFitWidth(Math.min(image.getWidth(), (double)maxSize));
            }
            imageView.setImage(image);
        };
        imageView.setPreserveRatio(true);
        imageChanged.accept((Image)imageExpression.get());
        JavaFXUtil.addChangeListener(imageExpression, imageChanged);
        return imageView;
    }

    @OnThread(value=Tag.FXPlatform)
    abstract void initialiseFX();

    abstract void focusWhenShown();

    abstract List<Menu> getMenus();

    @OnThread(value=Tag.FXPlatform)
    abstract void setParent(FXTabbedEditor var1, boolean var2);

    abstract FXTabbedEditor getParent();

    @OnThread(value=Tag.FXPlatform)
    abstract String getWebAddress();

    abstract ObservableStringValue windowTitleProperty();

    @OnThread(value=Tag.FXPlatform)
    public abstract void notifySelected();

    @OnThread(value=Tag.FXPlatform)
    public abstract void notifyUnselected();

    public final boolean shouldShowCatalogue() {
        return this.showCatalogue;
    }

    @OnThread(value=Tag.FX)
    public boolean isTutorial() {
        return false;
    }

    public final Rectangle2D getScreenBoundsIfSelectedTab() {
        FXTabbedEditor parent;
        if (this.getParent() != null && this.isSelected() && (parent = this.getParent()).isWindowVisible() && !parent.getStage().isIconified()) {
            Stage window = parent.getStage();
            return new Rectangle2D(window.getX() * window.getRenderScaleX(), window.getY() * window.getRenderScaleY(), window.getWidth() * window.getRenderScaleX(), window.getHeight() * window.getRenderScaleY());
        }
        return null;
    }
}

