/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

public class Circle {
    private int x;
    private int y;
    private int radius;

    public Circle(int x, int y, int r) {
        if (r < 0) {
            throw new IllegalArgumentException("Radius must be larger than -1. It was: " + r);
        }
        this.setX(x);
        this.setY(y);
        this.setRadius(r);
    }

    public Circle() {
    }

    public boolean equals(Object other) {
        if (other instanceof Circle) {
            Circle oCircle = (Circle)other;
            return oCircle.x == this.x && oCircle.y == this.y && oCircle.radius == this.radius;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.x;
        result = 37 * result + this.y;
        result = 37 * result + this.radius;
        return result;
    }

    public double getVolume() {
        return Math.PI * (double)this.radius * (double)this.radius;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean intersects(Circle other) {
        int dy;
        int dySq;
        int dx;
        int dxSq;
        int circleDistSq;
        int r2;
        int r1 = this.getRadius();
        return (r1 + (r2 = other.getRadius())) * (r1 + r2) >= (circleDistSq = (dxSq = (dx = this.getX() - other.getX()) * dx) + (dySq = (dy = this.getY() - other.getY()) * dy));
    }

    public void merge(Circle one, Circle two) {
        int dx = one.getX() - two.getX();
        int dy = one.getY() - two.getY();
        int dxSq = dx * dx;
        int dySq = dy * dy;
        int circleDistSq = dxSq + dySq;
        int r2 = one.getRadius() - two.getRadius();
        if (r2 * r2 >= circleDistSq) {
            if (one.getRadius() < two.getRadius()) {
                this.setRadius(two.getRadius());
                this.setX(two.getX());
                this.setY(two.getY());
            } else {
                this.setRadius(one.getRadius());
                this.setX(one.getX());
                this.setY(one.getY());
            }
        } else {
            double circleDist = Math.sqrt(circleDistSq);
            double r = (circleDist + (double)one.getRadius() + (double)two.getRadius()) / 2.0;
            this.setRadius((int)Math.ceil(r));
            if (circleDist > 0.0) {
                double f = (r - (double)one.getRadius()) / circleDist;
                this.setX(one.getX() - (int)Math.ceil(f * (double)dx));
                this.setY(one.getY() - (int)Math.ceil(f * (double)dy));
            } else {
                this.setX(one.getX());
                this.setY(one.getY());
            }
        }
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ") [" + this.radius + "]" + super.toString();
    }
}

