/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

public class TimeTracker {
    private long startTime;
    private boolean tracking;
    private long timeElapsed;

    public void start() {
        if (this.tracking) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.tracking = true;
    }

    public void pause() {
        if (!this.tracking) {
            return;
        }
        long timeSincestart = this.getTimeSinceStart();
        this.timeElapsed += timeSincestart;
        this.tracking = false;
    }

    public void reset() {
        this.startTime = 0L;
        this.tracking = false;
        this.timeElapsed = 0L;
    }

    private long getTimeSinceStart() {
        if (this.tracking) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    public long getTimeTracked() {
        return this.timeElapsed + this.getTimeSinceStart();
    }

    public void setTimeTracked(long newTime) {
        if (this.tracking) {
            this.startTime = System.currentTimeMillis() - newTime;
            this.timeElapsed = 0L;
        } else {
            this.timeElapsed = newTime;
        }
    }
}

