/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.standalone;

import greenfoot.Actor;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.WorldHandler;
import greenfoot.export.GreenfootScenarioViewer;
import greenfoot.gui.WorldRenderer;
import greenfoot.platforms.WorldHandlerDelegate;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Simulation)
public class WorldHandlerDelegateStandAlone
implements WorldHandlerDelegate {
    private final @OnThread(value=Tag.Any) GreenfootScenarioViewer viewer;
    private boolean lockScenario;
    private final WorldRenderer worldRenderer = new WorldRenderer();
    private long lastFramePaint;
    private final @OnThread(value=Tag.Any) AtomicReference<BufferedImage> pendingImage = new AtomicReference<Object>(null);
    private final @OnThread(value=Tag.Any) ConcurrentLinkedQueue<BufferedImage> oldImages = new ConcurrentLinkedQueue();

    @OnThread(value=Tag.FXPlatform)
    public WorldHandlerDelegateStandAlone(final GreenfootScenarioViewer viewer, boolean lockScenario) {
        this.viewer = viewer;
        this.lockScenario = lockScenario;
        new AnimationTimer(){

            @OnThread(value=Tag.FXPlatform)
            public void handle(long now) {
                BufferedImage worldImage = WorldHandlerDelegateStandAlone.this.pendingImage.getAndSet(null);
                if (worldImage != null) {
                    viewer.setWorldImage(worldImage);
                    WorldHandlerDelegateStandAlone.this.oldImages.add(worldImage);
                }
            }
        }.start();
    }

    public boolean maybeShowPopup(MouseEvent e) {
        return false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    @Override
    @OnThread(value=Tag.Any)
    public void setWorld(World oldWorld, World newWorld) {
    }

    @Override
    @OnThread(value=Tag.Any)
    public void instantiateNewWorld(String className, Runnable runIfError) {
        WorldHandler.getInstance().clearWorldSet();
        World newWorld = this.viewer.instantiateNewWorld();
        if (!WorldHandler.getInstance().checkWorldSet()) {
            WorldHandler.getInstance().setWorld(newWorld, false);
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public void discardWorld(World world) {
        BufferedImage image = this.pendingImage.getAndSet(null);
        if (image != null) {
            this.oldImages.add(image);
        }
    }

    public void addActor(Actor actor, int x, int y) {
    }

    @Override
    public void objectAddedToWorld(Actor actor) {
    }

    @Override
    public String ask(String prompt) {
        String r = this.viewer.ask(prompt);
        return r;
    }

    @Override
    public void paint(World world, boolean forcePaint) {
        if (world == null) {
            return;
        }
        long now = System.nanoTime();
        if (now - this.lastFramePaint < 10000000L) {
            return;
        }
        this.lastFramePaint = now;
        int imageWidth = WorldVisitor.getWidthInPixels(world);
        int imageHeight = WorldVisitor.getHeightInPixels(world);
        BufferedImage worldImage = this.oldImages.poll();
        if (worldImage == null || worldImage.getHeight() != imageHeight || worldImage.getWidth() != imageWidth) {
            worldImage = new BufferedImage(imageWidth, imageHeight, 2);
        }
        this.worldRenderer.renderWorld(world, worldImage);
        BufferedImage oldImage = this.pendingImage.getAndSet(worldImage);
        if (oldImage != null) {
            this.oldImages.add(oldImage);
        }
    }

    @Override
    public void notifyStoppedWithError() {
    }
}

