/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.ide;

import bluej.runtime.ExecServer;
import greenfoot.Actor;
import greenfoot.World;
import greenfoot.core.ImageCache;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.platforms.WorldHandlerDelegate;
import greenfoot.util.GreenfootUtil;
import greenfoot.vmcomm.VMCommsSimulation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class WorldHandlerDelegateIDE
implements WorldHandlerDelegate {
    private final VMCommsSimulation vmCommsSimulation;
    private boolean worldInitialising;
    private final List<Actor> actorsToName = new ArrayList<Actor>();
    private String mostRecentlyInstantiatedWorldClassName;

    public WorldHandlerDelegateIDE(VMCommsSimulation vmCommsSimulation) {
        this.vmCommsSimulation = vmCommsSimulation;
    }

    @Override
    public void discardWorld(World world) {
        ImageCache.getInstance().clearImageCache();
        this.vmCommsSimulation.setWorld(null);
    }

    @Override
    public void setWorld(World oldWorld, World newWorld) {
        this.nameActors(this.actorsToName.toArray(new Actor[0]));
        if (oldWorld != null) {
            this.discardWorld(oldWorld);
        }
        this.vmCommsSimulation.setWorld(newWorld);
    }

    @Override
    public void initialisingWorld(String className) {
        this.worldInitialising = true;
        this.mostRecentlyInstantiatedWorldClassName = className;
        this.actorsToName.clear();
    }

    @Override
    public void finishedInitialisingWorld() {
        this.worldInitialising = false;
    }

    @Override
    @OnThread(value=Tag.Simulation)
    public void paint(World drawWorld, boolean forcePaint) {
        this.vmCommsSimulation.paintRemote(forcePaint ? VMCommsSimulation.PaintWhen.FORCE : VMCommsSimulation.PaintWhen.IF_DUE);
    }

    @Override
    public void notifyStoppedWithError() {
        this.vmCommsSimulation.notifyStoppedWithError();
    }

    @Override
    public void instantiateNewWorld(String className, Runnable runIfError) {
        if (className != null) {
            this.mostRecentlyInstantiatedWorldClassName = className;
        }
        this.worldInitialising = true;
        Class<? extends World> cls = this.getLastWorldClass();
        if (cls == null) {
            runIfError.run();
            return;
        }
        Class<? extends World> icls = cls;
        Simulation.getInstance().runLater(() -> {
            try {
                Constructor cons = icls.getConstructor(new Class[0]);
                WorldHandler.getInstance().clearWorldSet();
                World newWorld = (World)Simulation.newInstance(cons);
                if (!WorldHandler.getInstance().checkWorldSet()) {
                    ImageCache.getInstance().clearImageCache();
                    WorldHandler.getInstance().setWorld(newWorld, false);
                }
            }
            catch (IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException e) {
                runIfError.run();
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace();
                runIfError.run();
            }
            catch (Exception e) {
                System.err.println("Exception during World initialisation:");
                e.printStackTrace();
                runIfError.run();
            }
            this.worldInitialising = false;
        });
    }

    private Class<? extends World> getLastWorldClass() {
        if (this.mostRecentlyInstantiatedWorldClassName != null) {
            try {
                ClassLoader classLdr = ExecServer.getCurrentClassLoader();
                Class<?> cls = Class.forName(this.mostRecentlyInstantiatedWorldClassName, false, classLdr);
                if (GreenfootUtil.canBeInstantiated(cls)) {
                    return cls.asSubclass(World.class);
                }
            }
            catch (ClassNotFoundException classLdr) {
            }
            catch (ClassCastException classLdr) {
            }
            catch (LinkageError e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void objectAddedToWorld(Actor object) {
        if (this.worldInitialising) {
            StackTraceElement[] methods = Thread.currentThread().getStackTrace();
            boolean gonePastUs = false;
            String lastWorldClassName = this.mostRecentlyInstantiatedWorldClassName;
            if (lastWorldClassName == null) {
                return;
            }
            for (StackTraceElement item : methods) {
                if ("prepare".equals(item.getMethodName()) && item.getClassName().equals(lastWorldClassName)) {
                    this.actorsToName.add(object);
                    return;
                }
                if (gonePastUs && item.getClassName().startsWith("java.")) {
                    return;
                }
                gonePastUs = gonePastUs || "objectAddedToWorld".equals(item.getMethodName());
            }
        }
    }

    private void nameActors(Actor[] actor) {
    }

    public boolean initialising() {
        return this.worldInitialising;
    }

    @Override
    public String ask(String prompt) {
        if (!Simulation.getInstance().equals(Thread.currentThread())) {
            throw new RuntimeException("Greenfoot.ask can only be called from the main simulation thread");
        }
        int askId = this.vmCommsSimulation.getAskId();
        return this.vmCommsSimulation.doAsk(askId, prompt);
    }
}

