/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.importer.scratch;

import greenfoot.importer.scratch.ScratchObject;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;

public class ScratchImage
extends ScratchObject {
    private ScratchObject bitsRef;
    private int w;
    private int h;
    private int d;
    private int offset;
    private BufferedImage img;
    private ScratchObject paletteRef;
    private Color[] palette;
    private boolean isResolved = false;

    public ScratchImage(int w, int h, int d, int offset, ScratchObject bitsRef, ScratchObject paletteRef) {
        this.w = w;
        this.h = h;
        this.d = d;
        this.offset = offset;
        this.bitsRef = bitsRef;
        this.paletteRef = paletteRef;
    }

    @Override
    public ScratchObject resolve(ArrayList<ScratchObject> objects) {
        if (this.isResolved) {
            return this;
        }
        if (this.paletteRef != null) {
            ScratchObject resolvedPalette = this.paletteRef.resolve(objects);
            ScratchObject[] pal = (ScratchObject[])resolvedPalette.getValue();
            this.palette = new Color[pal.length];
            for (int i = 0; i < pal.length; ++i) {
                this.palette[i] = (Color)pal[i].resolve(objects).getValue();
            }
        }
        this.img = new BufferedImage(this.w, this.h, 2);
        ScratchObject resolved = this.bitsRef.resolve(objects);
        if (resolved.getValue() instanceof int[]) {
            int[] values = (int[])resolved.getValue();
            for (int pos = 0; pos < values.length; ++pos) {
                this.setBitmapEntry(pos, values[pos]);
            }
        } else if (resolved.getValue() instanceof byte[]) {
            ByteArrayInputStream bitsInput = new ByteArrayInputStream((byte[])resolved.getValue());
            int bitmapPos = 0;
            this.decodeLen(bitsInput);
            int rawN = this.decodeLen(bitsInput);
            while (rawN != -1) {
                int wordCount = rawN >> 2;
                switch (rawN & 3) {
                    case 0: {
                        bitmapPos += wordCount;
                        break;
                    }
                    case 1: {
                        int b = bitsInput.read();
                        int x = b << 24 | b << 16 | b << 8 | b;
                        int end = bitmapPos + wordCount;
                        while (bitmapPos < end) {
                            this.setBitmapEntry(bitmapPos++, x);
                        }
                        break;
                    }
                    case 2: {
                        int x = 0;
                        for (int i = 0; i < 4; ++i) {
                            x <<= 8;
                            x |= bitsInput.read();
                        }
                        int end = bitmapPos + wordCount;
                        while (bitmapPos < end) {
                            this.setBitmapEntry(bitmapPos++, x);
                        }
                        break;
                    }
                    case 3: {
                        int x;
                        int end = bitmapPos + wordCount;
                        while (bitmapPos < end) {
                            x = 0;
                            for (int i = 0; i < 4; ++i) {
                                x <<= 8;
                                x |= bitsInput.read();
                            }
                            this.setBitmapEntry(bitmapPos++, x);
                        }
                        break;
                    }
                }
                rawN = this.decodeLen(bitsInput);
            }
        }
        this.isResolved = true;
        return this;
    }

    private void setBitmapEntry(int pos, int val) {
        int pixelsPerWord = 32 / this.d;
        for (int i = 0; i < pixelsPerWord; ++i) {
            int index = this.d == 32 ? val : val & (1 << this.d) - 1;
            int realWidth = (this.w + (pixelsPerWord - 1)) / pixelsPerWord;
            int x = pos % realWidth * pixelsPerWord + (pixelsPerWord - i);
            int y = pos / realWidth;
            if (x < this.w && y < this.h) {
                if (this.palette != null) {
                    this.img.setRGB(x, y, this.palette[index].getRGB());
                } else {
                    if (index >> 24 == 0 && (index & 0xFFFFFF) != 0) {
                        index |= 0xFF000000;
                    }
                    this.img.setRGB(x, y, index);
                }
            }
            val >>= this.d;
        }
    }

    private int decodeLen(ByteArrayInputStream bitsInput) {
        int x = 0;
        int first = bitsInput.read();
        if (first == -1) {
            return -1;
        }
        if (first == 255) {
            for (int i = 0; i < 4; ++i) {
                x <<= 8;
                x |= bitsInput.read();
            }
            return x;
        }
        if (first >= 224) {
            x = (first & 0x1F) << 8;
            x |= bitsInput.read();
        } else {
            x = first;
        }
        return x;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public BufferedImage getBufferedImage() {
        return this.img;
    }
}

