/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.images;

import greenfoot.guifx.images.ImageListEntry;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ImageLibList
extends ListView<ImageListEntry> {
    private File directory;
    private final String[] imageFileExtensions = new String[]{"jpg", "jpeg", "png", "gif"};
    private boolean projectList;

    public ImageLibList(boolean projectList) {
        this.projectList = projectList;
        this.setCellFactory(param -> new ImageLibCell());
    }

    public ImageLibList(File directory, boolean projectList) {
        this(projectList);
        this.setDirectory(directory);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
        this.loadImages();
    }

    private boolean loadImages() {
        FilenameFilter filter = (dir, name) -> Stream.of(this.imageFileExtensions).anyMatch(extension -> name.toLowerCase().endsWith((String)extension));
        Object[] imageFiles = this.directory.listFiles(filter);
        if (imageFiles == null) {
            imageFiles = new File[]{};
        }
        Arrays.sort(imageFiles);
        List newEntries = Arrays.stream(imageFiles).map(file -> new ImageListEntry((File)file, this.projectList)).collect(Collectors.toList());
        if (this.getItems().equals(newEntries)) {
            return false;
        }
        this.setItems(FXCollections.observableArrayList(newEntries));
        return true;
    }

    public File getDirectory() {
        return this.directory;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void refresh() {
        if (this.loadImages()) {
            super.refresh();
        }
    }

    public void select(File imageFile) {
        this.refresh();
        this.getSelectionModel().select((Object)new ImageListEntry(imageFile, this.projectList));
    }

    @OnThread(value=Tag.FXPlatform)
    static class ImageLibCell
    extends ListCell<ImageListEntry> {
        ImageLibCell() {
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void updateItem(ImageListEntry item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                if (item.isInProjectList()) {
                    this.setText(GreenfootUtil.removeExtension(item.getImageName()));
                } else {
                    this.setAlignment(Pos.CENTER);
                }
                this.setTooltip(new Tooltip(item.getImageName()));
                this.setGraphic((Node)item.getIcon());
            } else {
                this.setText(null);
                this.setTooltip(null);
                this.setGraphic(null);
            }
        }
    }
}

