/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Config;
import bluej.debugger.gentype.Reflective;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.export.Exporter;
import greenfoot.export.ScenarioSaver;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.guifx.export.ExportException;
import greenfoot.guifx.export.ExportProjectTab;
import greenfoot.guifx.export.ExportPublishTab;
import greenfoot.guifx.export.ExportTab;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ExportDialog
extends FXCustomizedDialog<Void> {
    private static final String dialogTitle = Config.getApplicationName() + ": " + Config.getString((String)"export.dialog.title");
    private final Project project;
    private final ScenarioSaver scenarioSaver;
    private final ScenarioInfo scenarioInfo;
    private final ClassTarget currentWorld;
    private final Image snapshot;
    private int uploadSize;
    private final BooleanProperty exportingProperty = new SimpleBooleanProperty(false);
    private BooleanBinding tabInvalidity;
    private final TabPane tabbedPane = new TabPane();
    private final Label progressLabel = new Label();
    private final ProgressBar progressBar = new ProgressBar();
    private final Map<Exporter.ExportFunction, ExportTab> exportTabs = new LinkedHashMap<Exporter.ExportFunction, ExportTab>();
    private final Button exportButton = new Button(Config.getString((String)"export.dialog.export"));

    public ExportDialog(Window parent, Project project, ScenarioSaver scenarioSaver, ScenarioInfo scenarioInfo, ClassTarget currentWorld, Image snapshot) throws ExportException {
        super(parent, dialogTitle, "export-dialog");
        this.project = project;
        this.scenarioSaver = scenarioSaver;
        this.scenarioInfo = scenarioInfo;
        this.currentWorld = currentWorld;
        this.snapshot = snapshot;
        this.setModal(true);
        this.makeDialog();
    }

    private void makeDialog() throws ExportException {
        BorderPane contentPane = new BorderPane();
        this.setContentPane((Node)contentPane);
        contentPane.setTop((Node)this.tabbedPane);
        this.progressBar.setProgress(-1.0);
        this.progressBar.setVisible(false);
        this.progressBar.setPrefWidth(100.0);
        this.progressLabel.setVisible(false);
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        Button closeButton = (Button)this.getDialogPane().lookupButton(ButtonType.CLOSE);
        closeButton.setOnAction(event -> Config.putPropString((String)"greenfoot.lastExportPane", (String)this.getSelectedFunction().name()));
        closeButton.disableProperty().bind((ObservableValue)this.exportingProperty);
        this.exportButton.setOnAction(event -> this.doExport());
        HBox bottomBox = new HBox(new Node[]{this.exportButton, this.progressLabel, this.progressBar});
        bottomBox.getStyleClass().add((Object)"bottom-box");
        contentPane.setBottom((Node)bottomBox);
        if (this.currentWorld == null) {
            throw new ExportException(Config.getString((String)"export.noworld.dialog.msg"));
        }
        boolean hasZeroArgConstructor = false;
        Reflective currentWorldType = this.currentWorld.getTypeReflective();
        if (currentWorldType != null) {
            List constructors = currentWorldType.getDeclaredConstructors();
            hasZeroArgConstructor = constructors.stream().anyMatch(con -> con.getParamTypes().isEmpty());
        }
        if (!hasZeroArgConstructor) {
            throw new ExportException(Config.getString((String)"export.noconstructor.dialog.msg"));
        }
        this.createTabs();
        if (this.snapshot != null) {
            ExportPublishTab publishPane = (ExportPublishTab)this.exportTabs.get((Object)Exporter.ExportFunction.PUBLISH);
            publishPane.setImage(this.snapshot);
        }
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)((SingleSelectionModel)this.tabbedPane.selectionModelProperty().get()).selectedItemProperty(), tab -> this.updateControls((ExportTab)((Object)tab)));
        this.selectTab(Config.getPropString((String)"greenfoot.lastExportPane"));
    }

    @OnThread(value=Tag.Any)
    public void setProgress(boolean showProgress, String text) {
        Platform.runLater(() -> {
            this.progressBar.setVisible(showProgress);
            if (!showProgress) {
                this.progressBar.setProgress(-1.0);
            }
            if (text == null) {
                this.progressLabel.setVisible(false);
            } else {
                this.progressLabel.setText(text);
                this.progressLabel.setVisible(true);
            }
        });
    }

    public void setExportButtonText(String s) {
        this.exportButton.setText(s);
    }

    private void doExport() {
        if (this.getSelectedTab().prePublish()) {
            ExportInfo info = this.getSelectedTab().getExportInfo();
            this.exportingProperty.set(true);
            this.scenarioSaver.doSave();
            new ExportThread(info).start();
        }
    }

    private void clearStatus() {
        if (!this.progressBar.isVisible()) {
            this.progressLabel.setVisible(false);
        }
    }

    private Exporter.ExportFunction getSelectedFunction() {
        return this.getSelectedTab().getFunction();
    }

    private ExportTab getSelectedTab() {
        return (ExportTab)((Object)this.tabbedPane.getSelectionModel().getSelectedItem());
    }

    private void selectTab(String name) {
        ExportTab tab = this.exportTabs.get((Object)Exporter.ExportFunction.getFunction(name));
        this.tabbedPane.getSelectionModel().select((Object)tab);
        this.updateControls(tab);
    }

    private void updateControls(ExportTab tab) {
        this.exportButton.disableProperty().unbind();
        this.tabInvalidity = tab.validProperty.not();
        this.exportButton.disableProperty().bind((ObservableValue)this.tabInvalidity.or((ObservableBooleanValue)this.exportingProperty));
        this.exportButton.setText(Config.getString((String)"export.dialog.export"));
        this.clearStatus();
    }

    private void createTabs() {
        Window asWindow = this.asWindow();
        String projectName = this.project.getProjectName();
        File defaultExportDir = this.project.getProjectDir().getParentFile();
        this.addTab(new ExportPublishTab(this.project, this, this.scenarioSaver, this.scenarioInfo));
        this.addTab(new ExportProjectTab(asWindow, this.scenarioInfo, projectName, defaultExportDir));
        this.tabbedPane.getTabs().setAll(this.exportTabs.values());
        this.tabbedPane.tabMinWidthProperty().bind((ObservableValue)this.widthProperty().divide(this.tabbedPane.getTabs().size()).subtract(30));
    }

    private void addTab(ExportTab exportTab) {
        this.exportTabs.put(exportTab.getFunction(), exportTab);
    }

    public void publishFinished(boolean success, String msg) {
        this.getSelectedTab().postPublish(success);
        this.setProgress(false, msg);
        if (success) {
            JavaFXUtil.runAfterCurrent(() -> Utility.openWebBrowser((String)(Config.getPropString((String)"greenfoot.gameserver.address") + "/home")));
        }
    }

    public void setUploadSize(int bytes) {
        this.uploadSize = bytes;
        this.progressBar.setProgress(0.0);
    }

    public void progressMade(int bytes) {
        this.progressBar.setProgress(this.progressBar.getProgress() + (double)bytes / (double)this.uploadSize);
    }

    class ExportThread
    extends Thread {
        private final double snapshotWidth;
        private final double snapshotHeight;
        private final String displayName;
        private final Exporter.ExportFunction function;
        private final ExportInfo info;

        @OnThread(value=Tag.FXPlatform)
        public ExportThread(ExportInfo info) {
            super("Export scenario");
            this.snapshotWidth = ExportDialog.this.snapshot.getWidth();
            this.snapshotHeight = ExportDialog.this.snapshot.getHeight();
            this.displayName = ExportDialog.this.currentWorld.getDisplayName();
            this.function = ExportDialog.this.getSelectedFunction();
            this.info = info;
        }

        @Override
        @OnThread(value=Tag.Worker, ignoreParent=true)
        public void run() {
            try {
                Exporter exporter = Exporter.getInstance();
                exporter.doExport(ExportDialog.this.project, ExportDialog.this, ExportDialog.this.scenarioSaver, this.info, this.function, this.displayName, this.snapshotWidth, this.snapshotHeight);
            }
            finally {
                Platform.runLater(() -> ExportDialog.this.exportingProperty.set(false));
            }
        }
    }
}

