/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.utility.javafx.FXPlatformConsumer;
import greenfoot.guifx.AskPaneFX;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class WorldDisplay
extends StackPane {
    private final ImageView imageView = new ImageView();
    private final AskPaneFX askPane = new AskPaneFX();
    private final Rectangle actorHighlight = new Rectangle();
    private final Animation actorHighlightAnimation;

    public WorldDisplay() {
        Pane highlightPane = new Pane(new Node[]{this.actorHighlight});
        highlightPane.setMouseTransparent(true);
        StackPane stackPane = new StackPane(new Node[]{this.imageView, this.askPane, highlightPane});
        stackPane.getStyleClass().add((Object)"world-display-wrapper");
        stackPane.setMaxWidth(Double.NEGATIVE_INFINITY);
        stackPane.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.getChildren().addAll((Object[])new Node[]{stackPane});
        this.setMinWidth(200.0);
        this.setMinHeight(200.0);
        this.actorHighlight.setVisible(false);
        this.actorHighlight.getStyleClass().add((Object)"actor-highlight");
        this.actorHighlight.getStrokeDashArray().setAll((Object[])new Double[]{6.0, 10.0});
        this.actorHighlightAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.actorHighlight.strokeDashOffsetProperty(), (Object)0), new KeyValue((WritableValue)this.actorHighlight.strokeProperty(), (Object)Color.BLACK)}), new KeyFrame(Duration.seconds((double)2.0), new KeyValue[]{new KeyValue((WritableValue)this.actorHighlight.strokeProperty(), (Object)Color.WHITE, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)4.0), new KeyValue[]{new KeyValue((WritableValue)this.actorHighlight.strokeDashOffsetProperty(), (Object)16, Interpolator.LINEAR), new KeyValue((WritableValue)this.actorHighlight.strokeProperty(), (Object)Color.BLACK, Interpolator.EASE_BOTH)})});
        this.actorHighlightAnimation.setCycleCount(-1);
    }

    public boolean setImage(Image image) {
        Image oldImage = this.imageView.getImage();
        boolean newSize = oldImage == null || image == null || image.getWidth() != oldImage.getWidth() || image.getHeight() != oldImage.getHeight();
        this.imageView.setImage(image);
        this.imageView.setEffect(null);
        return newSize;
    }

    public void greyOutWorld() {
        ColorAdjust grey = new ColorAdjust(0.0, -1.0, -0.1, 0.0);
        GaussianBlur blur = new GaussianBlur();
        blur.setInput((Effect)grey);
        this.imageView.setEffect((Effect)blur);
    }

    @OnThread(value=Tag.FXPlatform)
    public void ensureAsking(String prompt, FXPlatformConsumer<String> withAnswer) {
        this.imageView.setDisable(true);
        this.greyOutWorld();
        this.askPane.setVisible(true);
        this.askPane.setPrompt(prompt);
        this.askPane.focusTextEntry();
        this.askPane.setWithAnswer((FXPlatformConsumer<String>)((FXPlatformConsumer)ans -> {
            this.cancelAsk();
            withAnswer.accept(ans);
        }));
    }

    public void cancelAsk() {
        boolean wasAsking = this.askPane.isVisible();
        if (wasAsking) {
            this.askPane.setVisible(false);
            this.imageView.setDisable(false);
            this.imageView.setEffect(null);
            this.requestFocus();
        }
    }

    public boolean isAsking() {
        return this.askPane.isVisible();
    }

    public Point2D sceneToWorld(Point2D point2D) {
        return this.imageView.sceneToLocal(point2D);
    }

    public Point2D worldToScreen(Point2D point2D) {
        return this.imageView.localToScreen(point2D);
    }

    public boolean worldContains(Point2D point2D) {
        return this.imageView.contains(point2D);
    }

    public boolean isGreyedOut() {
        return this.imageView.getEffect() != null;
    }

    public Image getSnapshot() {
        return this.imageView.snapshot(null, null);
    }

    public Node getImageView() {
        return this.imageView;
    }

    public void setActorHighlight(int x, int y, int width, int height, int rotation) {
        if (x < -width || (double)x > this.imageView.getImage().getWidth() + (double)width || y < -height || (double)y > this.imageView.getImage().getHeight() + (double)height || width <= 0 || (double)width > this.imageView.getImage().getWidth() || height <= 0 || (double)height > this.imageView.getImage().getHeight()) {
            return;
        }
        this.actorHighlight.setX((double)x - (double)width / 2.0);
        this.actorHighlight.setY((double)y - (double)height / 2.0);
        this.actorHighlight.setWidth((double)width);
        this.actorHighlight.setHeight((double)height);
        this.actorHighlight.getTransforms().setAll((Object[])new Transform[]{new Rotate((double)rotation, (double)x, (double)y)});
        this.actorHighlight.setVisible(true);
        this.actorHighlightAnimation.playFromStart();
    }

    public void clearActorHighlight() {
        this.actorHighlightAnimation.stop();
        this.actorHighlight.setVisible(false);
    }
}

