/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import greenfoot.guifx.ControlPanel;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class GreenfootStageContentPane
extends Pane {
    private static final int CLASS_DIAGRAM_PADDING = 12;
    private static final int IDEAL_WORLD_PADDING = 30;
    private final Pane worldViewScroll;
    private final Button shareButton;
    private final ScrollPane classDiagramScroll;
    private final Pane controlPanel;

    public GreenfootStageContentPane(Pane worldViewScroll, Button shareButton, ScrollPane classDiagramScroll, ControlPanel controlPanel) {
        this.worldViewScroll = worldViewScroll;
        this.shareButton = shareButton;
        this.classDiagramScroll = classDiagramScroll;
        this.controlPanel = controlPanel;
        this.getChildren().addAll((Object[])new Node[]{worldViewScroll, shareButton, classDiagramScroll, controlPanel});
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected void layoutChildren() {
        double classDiagramWidth;
        double ourWidth = this.getWidth();
        double ourHeight = this.getHeight();
        double idealWorldWidth = this.worldViewScroll.prefWidth(-1.0);
        double shareButtonWidth = this.shareButton.prefWidth(-1.0);
        double shareButtonHeight = this.shareButton.prefHeight(-1.0);
        double classDiagramHeight = ourHeight - 36.0 - shareButtonHeight;
        double idealClassDiagramWidth = this.classDiagramScroll.prefWidth(classDiagramHeight);
        if (idealClassDiagramWidth + 24.0 + idealWorldWidth > ourWidth) {
            double minClassDiagramWidth = this.classDiagramScroll.minWidth(classDiagramHeight);
            classDiagramWidth = Math.max(minClassDiagramWidth, ourWidth - idealWorldWidth - 24.0);
        } else {
            classDiagramWidth = idealClassDiagramWidth;
        }
        classDiagramWidth = this.snapSizeX(classDiagramWidth);
        classDiagramWidth = Math.max(classDiagramWidth, shareButtonWidth + 24.0);
        double worldWidth = ourWidth - (classDiagramWidth + 24.0);
        double controlPanelHeight = this.controlPanel.prefHeight(worldWidth);
        this.worldViewScroll.resizeRelocate(0.0, 0.0, worldWidth, ourHeight - controlPanelHeight);
        this.shareButton.resizeRelocate(worldWidth + 12.0, 12.0, classDiagramWidth, shareButtonHeight);
        this.classDiagramScroll.resizeRelocate(worldWidth + 12.0, 24.0 + shareButtonHeight, classDiagramWidth, classDiagramHeight);
        this.controlPanel.resizeRelocate(0.0, ourHeight - controlPanelHeight, worldWidth, controlPanelHeight);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computePrefWidth(double height) {
        return this.worldViewScroll.prefWidth(height) + 60.0 + Math.max(this.shareButton.prefWidth(-1.0), this.classDiagramScroll.prefWidth(height)) + 24.0;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computePrefHeight(double width) {
        return Math.max(this.shareButton.prefHeight(-1.0) + this.classDiagramScroll.prefHeight(-1.0) + 36.0, this.worldViewScroll.prefHeight(-1.0) + 60.0 + this.controlPanel.prefHeight(-1.0));
    }
}

