/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.Config;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.Package;
import bluej.utility.JavaNames;
import java.util.Properties;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.StringProperty;

public class ClassNameVerifier {
    private Package pkg;
    private String message;
    private String illegalClassName;
    private Properties localProperties = new Properties();
    private final String classExists = Config.getString((String)"newclass.dialog.err.classExists");
    private final StringProperty textProperty;
    private final ReadOnlyObjectProperty<SourceType> sourceTypeProperty;

    public ClassNameVerifier(Package pkg, StringProperty textProperty, ReadOnlyObjectProperty<SourceType> sourceTypeProperty) {
        this.pkg = pkg;
        this.textProperty = textProperty;
        this.sourceTypeProperty = sourceTypeProperty;
        this.checkValidity();
    }

    public String getMessage() {
        return this.message;
    }

    private void buildTheErrorMessage() {
        SourceType sourceType = (SourceType)this.sourceTypeProperty.get();
        this.localProperties.put("LANGUAGE", sourceType != null ? sourceType.toString() : "");
        this.illegalClassName = Config.getString((String)"newclass.dialog.err.classNameIllegal", null, (Properties)this.localProperties, (boolean)false);
    }

    public boolean checkValidity() {
        boolean valid;
        this.buildTheErrorMessage();
        String className = (String)this.textProperty.get();
        boolean bl = valid = !className.isEmpty() && JavaNames.isIdentifier((String)className) && !this.classNameExist(className) && !this.isGreenfootClassName(className);
        this.message = valid || className.isEmpty() ? "" : (this.classNameExist(className) || this.isGreenfootClassName(className) ? this.classExists : this.illegalClassName);
        return valid;
    }

    private boolean isGreenfootClassName(String className) {
        return className.equals("Actor") || className.equals("World");
    }

    private boolean classNameExist(String className) {
        return this.pkg.getTarget(className) != null;
    }
}

