/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class ScenarioInfo {
    private String title;
    private String shortDescription;
    private String longDescription;
    private List<String> tags = Collections.emptyList();
    private String url;
    private boolean includeSource;
    private boolean locked;
    private boolean hideControls;
    private static final String PUBLISH_TITLE = "publish.title";
    private static final String PUBLISH_SHORT_DESC = "publish.shortDesc";
    private static final String PUBLISH_LONG_DESC = "publish.longDesc";
    private static final String PUBLISH_URL = "publish.url";
    private static final String PUBLISH_TAGS = "publish.tags";
    private static final String PUBLISH_HAS_SOURCE = "publish.hasSource";
    private static final String PUBLISH_LOCKED = "publish.locked";

    public ScenarioInfo() {
    }

    public ScenarioInfo(ScenarioInfo src) {
        this.title = src.title;
        this.shortDescription = src.shortDescription;
        this.longDescription = src.longDescription;
        this.tags = new ArrayList<String>(src.tags);
        this.url = src.url;
        this.includeSource = src.includeSource;
        this.locked = src.locked;
    }

    public ScenarioInfo(Properties properties) {
        this.load(properties);
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title.trim();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortDescription(String shortDesc) {
        this.shortDescription = shortDesc;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setLongDescription(String longDesc) {
        this.longDescription = longDesc;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isIncludeSource() {
        return this.includeSource;
    }

    public void setIncludeSource(boolean includeSource) {
        this.includeSource = includeSource;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isHideControls() {
        return this.hideControls;
    }

    public void setHideControls(boolean hideControls) {
        this.hideControls = hideControls;
    }

    public void store(Properties properties) {
        this.setPropertyIfNotNull(properties, PUBLISH_TITLE, this.getTitle());
        this.setPropertyIfNotNull(properties, PUBLISH_SHORT_DESC, this.getShortDescription());
        this.setPropertyIfNotNull(properties, PUBLISH_LONG_DESC, this.getLongDescription());
        this.setPropertyIfNotNull(properties, PUBLISH_URL, this.getUrl());
        this.setPropertyIfNotNull(properties, PUBLISH_TAGS, this.getTagsAsString());
        this.setPropertyIfNotNull(properties, PUBLISH_HAS_SOURCE, Boolean.toString(this.isIncludeSource()));
        this.setPropertyIfNotNull(properties, PUBLISH_LOCKED, Boolean.toString(this.isLocked()));
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    private String getTagsAsString() {
        List<String> tags = this.getTags();
        return tags == null ? null : String.join((CharSequence)" ", tags);
    }

    public void load(Properties properties) {
        this.setTitle(properties.getProperty(PUBLISH_TITLE, ""));
        this.setShortDescription(properties.getProperty(PUBLISH_SHORT_DESC, ""));
        this.setLongDescription(properties.getProperty(PUBLISH_LONG_DESC, ""));
        this.setUrl(properties.getProperty(PUBLISH_URL, ""));
        LinkedList<String> tagList = new LinkedList<String>();
        String tags = properties.getProperty(PUBLISH_TAGS);
        if (tags != null) {
            Collections.addAll(tagList, tags.split(" "));
        }
        this.setTags(tagList);
        this.setIncludeSource(Boolean.parseBoolean(properties.getProperty(PUBLISH_HAS_SOURCE, "false")));
        this.setLocked(Boolean.parseBoolean(properties.getProperty(PUBLISH_LOCKED, "true")));
    }
}

