/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.Config;
import bluej.pkgmgr.Project;
import greenfoot.event.PublishEvent;
import greenfoot.event.PublishListener;
import greenfoot.export.JarCreator;
import greenfoot.export.ScenarioSaver;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.MyGameClient;
import greenfoot.guifx.export.ExportDialog;
import greenfoot.guifx.export.ProxyAuthDialog;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import org.glavo.png.javafx.PNGJavaFXUtils;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Exporter
implements PublishListener {
    private static final String GREENFOOT_CORE_JAR = Exporter.getGreenfootCoreJar();
    private static final String GALLERY_SHARED_JARS = "sharedjars/";
    private static Exporter instance;
    private File tmpJarFile;
    private File tmpImgFile;
    private File tmpZipFile;
    private MyGameClient webPublisher;
    private Project project;
    private ExportInfo scenarioInfo;
    private String worldName;
    private double worldWidth;
    private double worldHeight;
    private ExportDialog dialog;

    private static String getGreenfootCoreJar() {
        Object coreJar = "Greenfoot-core-";
        int lastDot = "3.1.0".lastIndexOf(46);
        coreJar = (String)coreJar + "3.1.0".substring(0, lastDot) + ".jar";
        return coreJar;
    }

    public static synchronized Exporter getInstance() {
        if (instance == null) {
            instance = new Exporter();
        }
        return instance;
    }

    private Exporter() {
    }

    @OnThread(value=Tag.Worker)
    public void doExport(Project project, ExportDialog dialog, ScenarioSaver scenarioSaver, ExportInfo scenarioInfo, ExportFunction function, String worldName, double worldWidth, double worldHeight) {
        this.project = project;
        this.dialog = dialog;
        this.scenarioInfo = scenarioInfo;
        this.worldName = worldName;
        this.worldWidth = worldWidth;
        this.worldHeight = worldHeight;
        if (function.equals((Object)ExportFunction.PUBLISH)) {
            this.publishToWebServer();
        }
        if (function.equals((Object)ExportFunction.PROJECT)) {
            this.makeProject();
        }
    }

    @OnThread(value=Tag.Worker)
    private void publishToWebServer() {
        this.dialog.setProgress(true, Config.getString((String)"export.progress.bundling"));
        try {
            this.tmpJarFile = File.createTempFile("greenfoot", ".jar", null);
            this.tmpJarFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        File exportDir = this.tmpJarFile.getParentFile();
        String jarName = this.tmpJarFile.getName();
        Object hostAddress = Config.getPropString((String)"greenfoot.gameserver.address", (String)"https://www.greenfoot.org/");
        if (!((String)hostAddress).endsWith("/")) {
            hostAddress = (String)hostAddress + "/";
        }
        boolean lockScenario = this.scenarioInfo.isLocked();
        JarCreator jarCreator = new JarCreator(this.project, exportDir, jarName, this.worldName, lockScenario);
        jarCreator.includeSource(false);
        jarCreator.addToClassPath((String)hostAddress + GALLERY_SHARED_JARS + GREENFOOT_CORE_JAR);
        Set<File> thirdPartyLibs = GreenfootUtil.get3rdPartyLibs();
        for (File lib : thirdPartyLibs) {
            jarCreator.addToClassPath((String)hostAddress + GALLERY_SHARED_JARS + lib.getName());
        }
        jarCreator.putManifestEntry("title", this.scenarioInfo.getTitle());
        jarCreator.putManifestEntry("short-description", this.scenarioInfo.getShortDescription());
        jarCreator.putManifestEntry("description", this.scenarioInfo.getLongDescription());
        jarCreator.putManifestEntry("url", this.scenarioInfo.getUrl());
        jarCreator.putManifestEntry("greenfoot-version", "3.8.2");
        jarCreator.putManifestEntry("java-version", System.getProperty("java.version"));
        jarCreator.putManifestEntry("java-vm-name", System.getProperty("java.vm.name"));
        jarCreator.putManifestEntry("java-vm-version", System.getProperty("java.vm.version"));
        jarCreator.putManifestEntry("java-vm-vendor", System.getProperty("java.vm.vendor"));
        jarCreator.putManifestEntry("os-name", System.getProperty("os.name"));
        jarCreator.putManifestEntry("os-version", System.getProperty("os.version"));
        jarCreator.putManifestEntry("os-arch", System.getProperty("os.arch"));
        jarCreator.putManifestEntry("java-home", System.getProperty("java.home"));
        Dimension2D size = this.getSize(!lockScenario);
        jarCreator.putManifestEntry("width", "" + size.getWidth());
        jarCreator.putManifestEntry("height", "" + size.getHeight());
        jarCreator.create();
        if (this.scenarioInfo.isIncludeSource()) {
            try {
                this.tmpZipFile = File.createTempFile("greenfootSource", ".zip", null);
                this.tmpZipFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            String zipName = this.tmpZipFile.getName();
            JarCreator zipCreator = new JarCreator(this.project, exportDir, zipName);
            zipCreator.create();
        }
        if (!this.scenarioInfo.isKeepSavedScreenshot()) {
            String formatName = "png";
            try {
                this.tmpImgFile = File.createTempFile("greenfoot", "." + formatName, null);
                PNGJavaFXUtils.writeImage((Image)this.scenarioInfo.getImage(), (Path)this.tmpImgFile.toPath());
                this.tmpImgFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        String login = this.scenarioInfo.getUserName();
        String password = this.scenarioInfo.getPassword();
        String scenarioName = this.scenarioInfo.getTitle();
        if (scenarioName != null && scenarioName.length() < 1) {
            scenarioName = "NO_NAME";
        }
        if (this.webPublisher == null) {
            this.webPublisher = new MyGameClient(this);
        }
        this.dialog.setProgress(true, Config.getString((String)"export.progress.publishing"));
        try {
            ExportInfo exportedInfo = this.scenarioInfo;
            int uploadSize = (int)this.tmpJarFile.length();
            if (this.tmpImgFile != null) {
                uploadSize += (int)this.tmpImgFile.length();
            }
            if (this.tmpZipFile != null) {
                uploadSize += (int)this.tmpZipFile.length();
            }
            this.setUploadSize(uploadSize);
            this.webPublisher.submit((String)hostAddress, login, password, this.tmpJarFile.getAbsolutePath(), this.tmpZipFile, this.tmpImgFile, (int)size.getWidth(), (int)size.getHeight(), exportedInfo);
        }
        catch (UnknownHostException e) {
            this.dialog.setProgress(false, Config.getString((String)"export.publish.unknownHost") + " (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            this.dialog.setProgress(false, Config.getString((String)"export.publish.fail") + " " + e.getMessage());
        }
    }

    private static File[] getJarsInPlusLib(Project project) {
        File plusLibsDir = new File(project.getProjectDir(), "+libs");
        return plusLibsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
    }

    @OnThread(value=Tag.Worker)
    private void makeProject() {
        this.dialog.setProgress(true, Config.getString((String)"export.progress.writingGfar"));
        File exportFile = new File(this.scenarioInfo.getExportFileName());
        File exportDir = exportFile.getParentFile();
        String gfarName = exportFile.getName();
        JarCreator gfarCrator = new JarCreator(this.project, exportDir, gfarName);
        gfarCrator.create();
        this.dialog.setProgress(false, Config.getString((String)"export.progress.complete"));
    }

    private Dimension2D getSize(boolean includeControls) {
        int EMPTY_BORDER_SIZE = 5;
        Dimension2D controlsBorder = new Dimension2D(10.0, 10.0);
        double controlsWidth = controlsBorder.getWidth() + (double)(includeControls ? 560 : 410);
        double controlHeight = controlsBorder.getHeight() + 48.0;
        Dimension2D worldBorder = new Dimension2D(12.0, 12.0);
        double width = Math.max(this.worldWidth + worldBorder.getWidth() + 2.0, controlsWidth);
        double height = controlHeight + this.worldHeight + worldBorder.getHeight() + 2.0;
        return new Dimension2D(width, height);
    }

    @Override
    public void errorRecieved(PublishEvent event) {
        this.deleteTmpFiles();
        Platform.runLater(() -> this.dialog.publishFinished(false, Config.getString((String)"export.publish.fail") + " " + event.getMessage()));
    }

    @Override
    public void uploadComplete(PublishEvent event) {
        this.deleteTmpFiles();
        Platform.runLater(() -> this.dialog.publishFinished(true, Config.getString((String)"export.publish.complete")));
    }

    private void deleteTmpFiles() {
        if (this.tmpJarFile != null) {
            this.tmpJarFile.delete();
            this.tmpJarFile = null;
        }
        if (this.tmpImgFile != null) {
            this.tmpImgFile.delete();
            this.tmpImgFile = null;
        }
        if (this.tmpZipFile != null) {
            this.tmpZipFile.delete();
            this.tmpZipFile = null;
        }
    }

    public void setUploadSize(int size) {
        Platform.runLater(() -> this.dialog.setUploadSize(size));
    }

    @Override
    public void progressMade(PublishEvent event) {
        Platform.runLater(() -> this.dialog.progressMade(event.getBytes()));
    }

    @Override
    public String[] needProxyAuth() {
        CompletableFuture detailsFuture = new CompletableFuture();
        Platform.runLater(() -> {
            Optional infoOptional = new ProxyAuthDialog(this.dialog.asWindow()).showAndWait();
            if (infoOptional.isPresent()) {
                ProxyAuthDialog.ProxyAuthInfo info = (ProxyAuthDialog.ProxyAuthInfo)infoOptional.get();
                detailsFuture.complete(new String[]{info.getUsername(), info.getPassword()});
            } else {
                detailsFuture.complete(null);
            }
        });
        try {
            return (String[])detailsFuture.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static enum ExportFunction {
        PUBLISH,
        PROJECT;


        public static ExportFunction getFunction(String name) {
            try {
                return ExportFunction.valueOf(name);
            }
            catch (IllegalArgumentException ex) {
                return PUBLISH;
            }
        }
    }
}

