/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.TreeActorSet;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.ActInterruptedException;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.util.HDTimer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Simulation)
public class Simulation
extends Thread
implements WorldListener {
    private @OnThread(value=Tag.Any) WorldHandler worldHandler;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean paused;
    private volatile boolean enabled;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean runOnce;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Queue<SimulationRunnable> queuedTasks = new LinkedList<SimulationRunnable>();
    private final @OnThread(value=Tag.Any) List<SimulationListener> listenerList = new ArrayList<SimulationListener>();
    private static @OnThread(value=Tag.Any, requireSynchronized=true) Simulation instance;
    public static final int MAX_SIMULATION_SPEED = 100;
    private @OnThread(value=Tag.Any, requireSynchronized=true) int speed;
    private long lastDelayTime;
    private long delay;
    private @OnThread(value=Tag.Any) Object interruptLock = new Object();
    private @OnThread(value=Tag.Any) boolean delaying;
    private @OnThread(value=Tag.Any) boolean interruptDelay;
    private boolean isRunning = false;
    private volatile boolean abort;
    public static final String PAUSED = "simulationWait";
    public static final String WORLD_STARTED = "worldStarted";
    public static final String WORLD_STOPPED = "worldStopped";
    public static String RUN_QUEUED_TASKS;
    public static final String ACT_ACTOR = "actActor";
    public static final String ACT_WORLD = "actWorld";
    public static final String NEW_INSTANCE = "newInstance";

    @OnThread(value=Tag.Any)
    private Simulation() {
        super("SimulationThread");
        this.setPriority(1);
        this.paused = true;
        this.speed = 50;
        this.delay = Simulation.calculateDelay(this.speed);
        HDTimer.init();
    }

    @OnThread(value=Tag.Any)
    public static synchronized void initialize() {
        instance = new Simulation();
    }

    @OnThread(value=Tag.Any)
    public static synchronized Simulation getInstance() {
        return instance;
    }

    @OnThread(value=Tag.Any)
    public void attachWorldHandler(WorldHandler worldHandler) {
        this.worldHandler = worldHandler;
        worldHandler.addWorldListener(this);
        this.addSimulationListener(worldHandler);
        this.start();
    }

    @Override
    @OnThread(value=Tag.Simulation, ignoreParent=true)
    public void run() {
        this.runContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContent() {
        while (!this.abort) {
            Simulation simulation;
            try {
                boolean currentlyPaused;
                this.maybePause();
                if (this.worldHandler.hasWorld()) {
                    this.runOneLoop(this.worldHandler.getWorld());
                }
                simulation = this;
                synchronized (simulation) {
                    currentlyPaused = this.paused;
                }
                if (currentlyPaused) continue;
                this.delay();
            }
            catch (ActInterruptedException currentlyPaused) {
            }
            catch (InterruptedException currentlyPaused) {
            }
            catch (Throwable t) {
                simulation = this;
                synchronized (simulation) {
                    this.paused = true;
                }
                t.printStackTrace();
                WorldHandler.getInstance().notifyStoppedWithError();
                this.paintRemote(true);
            }
        }
        Simulation simulation = this;
        synchronized (simulation) {
            if (this.isRunning) {
                World world = this.worldHandler.getWorld();
                if (world != null) {
                    Simulation.worldStopped(world);
                }
                this.isRunning = false;
            }
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized void runLater(SimulationRunnable r) {
        this.queuedTasks.add(r);
        if (this.paused || !this.enabled) {
            this.notify();
        }
    }

    private void simulationWait() throws InterruptedException {
        this.paintRemote(true);
        this.wait();
    }

    private static void worldStarted(World world) {
        world.started();
    }

    private static void worldStopped(World world) {
        world.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybePause() throws InterruptedException {
        while (!this.abort) {
            boolean doResumeRunning;
            Object object;
            World world;
            boolean checkStop;
            this.runQueuedTasks();
            Simulation simulation = this;
            synchronized (simulation) {
                checkStop = (this.paused || !this.enabled) && this.isRunning;
                world = this.worldHandler.getWorld();
                if (checkStop) {
                    this.isRunning = false;
                    object = this.interruptLock;
                    synchronized (object) {
                        this.interruptDelay = false;
                    }
                } else if (this.isRunning) {
                    return;
                }
            }
            if (checkStop) {
                try {
                    this.signalStopping(world);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                Simulation ie = this;
                synchronized (ie) {
                    this.runOnce = false;
                    if (!this.paused) {
                        this.isRunning = this.enabled;
                    }
                }
            }
            object = this;
            synchronized (object) {
                boolean bl = doResumeRunning = !this.paused && this.enabled && !this.abort && !this.isRunning;
                if (!(this.isRunning || doResumeRunning || this.runOnce)) {
                    if (this.enabled) {
                        this.fireSimulationEventAsync(SimulationListener.AsyncEvent.STOPPED);
                    }
                    if (this.worldHandler != null) {
                        this.worldHandler.repaint();
                    }
                    if (!this.queuedTasks.isEmpty()) {
                        continue;
                    }
                    System.gc();
                    try {
                        this.simulationWait();
                        this.lastDelayTime = System.nanoTime();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (doResumeRunning) {
                this.resumeRunning();
            }
            object = this;
            synchronized (object) {
                if (this.runOnce || this.isRunning) {
                    this.runOnce = false;
                    return;
                }
            }
        }
        this.runQueuedTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeRunning() throws InterruptedException {
        this.isRunning = true;
        this.lastDelayTime = System.nanoTime();
        this.fireSimulationEventSync(SimulationListener.SyncEvent.STARTED);
        World world = this.worldHandler.getWorld();
        if (world != null) {
            try {
                Simulation.worldStarted(world);
            }
            catch (Throwable t) {
                this.isRunning = false;
                Object object = this.interruptLock;
                synchronized (object) {
                    Thread.interrupted();
                    this.interruptDelay = false;
                }
                this.setPaused(true);
                t.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalStopping(World world) throws InterruptedException {
        if (world != null) {
            try {
                Simulation.worldStopped(world);
            }
            catch (ActInterruptedException aie) {
                Simulation simulation = this;
                synchronized (simulation) {
                    this.paused = true;
                }
                throw aie;
            }
            catch (Throwable t) {
                Simulation simulation = this;
                synchronized (simulation) {
                    this.paused = true;
                }
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueuedTasks() {
        SimulationRunnable r;
        Simulation simulation = this;
        synchronized (simulation) {
            r = this.queuedTasks.poll();
        }
        while (r != null) {
            this.fireSimulationEventSync(SimulationListener.SyncEvent.QUEUED_TASK_BEGIN);
            try {
                r.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.fireSimulationEventSync(SimulationListener.SyncEvent.QUEUED_TASK_END);
            simulation = this;
            synchronized (simulation) {
                r = this.queuedTasks.poll();
            }
        }
    }

    private void runOneLoop(World world) {
        this.fireSimulationEventSync(SimulationListener.SyncEvent.NEW_ACT_ROUND);
        ActInterruptedException interruptedException = null;
        try {
            Simulation.actWorld(world);
            if (world != this.worldHandler.getWorld()) {
                this.paintRemote(false);
                return;
            }
        }
        catch (ActInterruptedException e) {
            interruptedException = e;
        }
        TreeActorSet allObjects = WorldVisitor.getObjectsListInActOrder(world);
        ArrayList<Actor> awakeObjects = new ArrayList<Actor>(allObjects.size());
        for (Actor possiblySleepingActor : allObjects) {
            if (!ActorVisitor.decrementSleepForIfPositive(possiblySleepingActor)) continue;
            awakeObjects.add(possiblySleepingActor);
        }
        for (Actor actor : awakeObjects) {
            if (!this.enabled) {
                return;
            }
            if (ActorVisitor.getWorld(actor) == null) continue;
            try {
                Simulation.actActor(actor);
                if (world == this.worldHandler.getWorld()) continue;
                return;
            }
            catch (ActInterruptedException e) {
                if (interruptedException != null) continue;
                interruptedException = e;
            }
        }
        this.worldHandler.getKeyboardManager().clearLatchedKeys();
        if (interruptedException != null) {
            throw interruptedException;
        }
        this.repaintIfNeeded();
        this.fireSimulationEventSync(SimulationListener.SyncEvent.END_ACT_ROUND);
    }

    private static void actActor(Actor actor) {
        actor.act();
    }

    private static void actWorld(World world) {
        world.act();
    }

    public static Object newInstance(Constructor<?> constructor) throws InvocationTargetException, IllegalArgumentException, InstantiationException, IllegalAccessException {
        return constructor.newInstance(null);
    }

    private void repaintIfNeeded() {
        this.paintRemote(false);
    }

    protected void paintRemote(boolean forcePaint) {
        WorldHandler.getInstance().paint(forcePaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public synchronized void runOnce() {
        if (this.enabled) {
            Object object = this.interruptLock;
            synchronized (object) {
                this.interruptDelay = false;
            }
        }
        this.runOnce = true;
        this.notifyAll();
    }

    @OnThread(value=Tag.Any)
    public synchronized void togglePaused() {
        this.setPaused(!this.paused);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public synchronized void setPaused(boolean b) {
        if (this.paused == b) {
            return;
        }
        this.paused = b;
        if (this.enabled) {
            if (!this.paused) {
                Object object = this.interruptLock;
                synchronized (object) {
                    this.interruptDelay = false;
                }
            }
            this.notifyAll();
            if (this.paused) {
                this.interruptDelay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private void interruptDelay() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.delaying) {
                this.interrupt();
            } else {
                this.interruptDelay = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public synchronized void setEnabled(boolean b) {
        if (b == this.enabled) {
            return;
        }
        this.enabled = b;
        if (b) {
            this.notifyAll();
            if (this.paused) {
                this.fireSimulationEventAsync(SimulationListener.AsyncEvent.STOPPED);
            }
        } else {
            this.interruptDelay();
            if (!this.paused) {
                this.paused = true;
            } else {
                Object object = this.interruptLock;
                synchronized (object) {
                    this.interruptDelay = false;
                }
            }
            this.fireSimulationEventAsync(SimulationListener.AsyncEvent.DISABLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Simulation)
    private void fireSimulationEventSync(SimulationListener.SyncEvent event) {
        List<SimulationListener> list = this.listenerList;
        synchronized (list) {
            for (SimulationListener listener : this.listenerList) {
                listener.simulationChangedSync(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private void fireSimulationEventAsync(SimulationListener.AsyncEvent event) {
        List<SimulationListener> list = this.listenerList;
        synchronized (list) {
            for (SimulationListener listener : this.listenerList) {
                listener.simulationChangedAsync(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void addSimulationListener(SimulationListener l) {
        List<SimulationListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(0, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void setSpeed(int newSpeed) {
        boolean speedChanged;
        if (newSpeed < 0) {
            newSpeed = 0;
        } else if (newSpeed > 100) {
            newSpeed = 100;
        }
        Simulation simulation = this;
        synchronized (simulation) {
            boolean bl = speedChanged = this.speed != newSpeed;
            if (speedChanged) {
                this.speed = newSpeed;
                this.delay = Simulation.calculateDelay(newSpeed);
                if (!this.paused) {
                    Object object = this.interruptLock;
                    synchronized (object) {
                        if (this.delaying) {
                            this.interrupt();
                        }
                    }
                }
            }
        }
        if (speedChanged) {
            this.fireSimulationEventAsync(SimulationListener.AsyncEvent.CHANGED_SPEED);
        }
    }

    @OnThread(value=Tag.Any)
    private static long calculateDelay(int curSpeed) {
        long rawDelay = 100 - curSpeed;
        long min = 30000L;
        long max = 10000000000L;
        double a = Math.pow((double)max / (double)min, 0.010101010101010102);
        long calcDelay = 0L;
        if (rawDelay > 0L) {
            calcDelay = (long)(Math.pow(a, rawDelay - 1L) * (double)min);
        }
        return calcDelay;
    }

    @OnThread(value=Tag.Any)
    public synchronized int getSpeed() {
        return this.speed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Simulation)
    public void sleep(int numCycles) {
        Simulation simulation = this;
        synchronized (simulation) {
            if (this.paused && this.isRunning && !this.runOnce) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            Object object = this.interruptLock;
            synchronized (object) {
                if (this.interruptDelay) {
                    return;
                }
                this.delaying = true;
            }
        }
        this.fireSimulationEventSync(SimulationListener.SyncEvent.DELAY_LOOP_ENTERED);
        try {
            this.worldHandler.paint((long)numCycles * this.delay > 100000000L);
            for (int i = 0; i < numCycles; ++i) {
                HDTimer.sleep(this.delay);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Object object = this.interruptLock;
            synchronized (object) {
                Thread.interrupted();
                this.interruptDelay = false;
                this.delaying = false;
            }
            this.fireSimulationEventSync(SimulationListener.SyncEvent.DELAY_LOOP_COMPLETED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay() {
        Object object;
        long currentTime = System.nanoTime();
        long timeElapsed = currentTime - this.lastDelayTime;
        long actualDelay = Math.max(this.delay - timeElapsed, 0L);
        Object object2 = this;
        synchronized (object2) {
            object = this.interruptLock;
            synchronized (object) {
                if (this.interruptDelay) {
                    this.interruptDelay = false;
                    if (this.paused || this.abort) {
                        this.lastDelayTime = currentTime;
                        return;
                    }
                }
                this.delaying = true;
            }
        }
        this.fireSimulationEventSync(SimulationListener.SyncEvent.DELAY_LOOP_ENTERED);
        while (actualDelay > 0L) {
            try {
                HDTimer.sleep(actualDelay);
            }
            catch (InterruptedException ie) {
                object = this;
                synchronized (object) {
                    if (!this.enabled || this.paused || this.abort) {
                        break;
                    }
                }
            }
            currentTime = System.nanoTime();
            timeElapsed = currentTime - this.lastDelayTime;
            actualDelay = this.delay - timeElapsed;
        }
        this.lastDelayTime = currentTime;
        object2 = this.interruptLock;
        synchronized (object2) {
            Thread.interrupted();
            this.interruptDelay = false;
            this.delaying = false;
        }
        this.fireSimulationEventSync(SimulationListener.SyncEvent.DELAY_LOOP_COMPLETED);
    }

    @OnThread(value=Tag.Any)
    public void abort() {
        this.abort = true;
        this.setEnabled(false);
    }

    @Override
    public void worldCreated(WorldEvent e) {
        this.setEnabled(true);
    }

    @Override
    public void worldRemoved(WorldEvent e) {
        this.setEnabled(false);
    }

    static {
        RUN_QUEUED_TASKS = "runQueuedTasks";
    }

    public static interface SimulationRunnable {
        @OnThread(value=Tag.Simulation)
        public void run();
    }
}

