/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.views.MemberView;
import java.util.function.Predicate;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class ViewFilter
implements Predicate<MemberView> {
    private final StaticOrInstance staticOrInstance;
    private final String callingPackage;

    public ViewFilter(StaticOrInstance staticOrInstance, String callingPackage) {
        this.staticOrInstance = staticOrInstance;
        this.callingPackage = callingPackage;
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) boolean test(MemberView member) {
        boolean isStatic;
        boolean wantStatic = this.staticOrInstance == StaticOrInstance.STATIC;
        if (wantStatic != (isStatic = member.isStatic())) {
            return false;
        }
        if ((member.getModifiers() & 1) != 0) {
            return true;
        }
        boolean samePackage = member.getDeclaringView().getPackageName().equals(this.callingPackage);
        if (!samePackage) {
            return false;
        }
        return (member.getModifiers() & 2) == 0;
    }

    public static enum StaticOrInstance {
        STATIC,
        INSTANCE;

    }
}

