/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import java.util.Objects;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class FXAbstractAction {
    private final String name;
    private final String menuText;
    private boolean hasMenuItem = false;
    private final BooleanProperty unavailable = new SimpleBooleanProperty(false);
    private final BooleanProperty disabled = new SimpleBooleanProperty(false);
    private final BooleanBinding disabledOrUnavailable = this.disabled.or((ObservableBooleanValue)this.unavailable);
    protected final ObjectProperty<KeyCombination> accelerator;
    private final Node buttonGraphic;

    protected FXAbstractAction(String name) {
        this(name, name, null);
    }

    protected FXAbstractAction(String name, String menuText, KeyCombination accelerator) {
        this.name = name;
        this.menuText = menuText;
        this.accelerator = new SimpleObjectProperty((Object)accelerator);
        this.buttonGraphic = null;
    }

    protected FXAbstractAction(String name, Node buttonGraphic) {
        this.name = name;
        this.menuText = name;
        this.accelerator = new SimpleObjectProperty(null);
        this.buttonGraphic = buttonGraphic;
    }

    protected FXAbstractAction(String name, Image buttonImage) {
        this(name, (Node)new ImageView(buttonImage));
    }

    public abstract void actionPerformed(boolean var1);

    public void bindDisabled(BooleanExpression disabled) {
        if (disabled != null) {
            this.disabled.bind((ObservableValue)disabled);
        } else {
            this.disabled.unbind();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.disabled.isBound()) {
            this.disabled.unbind();
        }
        this.disabled.set(!enabled);
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public void setAvailable(boolean available) {
        this.unavailable.set(!available);
    }

    public String getName() {
        return this.name;
    }

    public KeyCombination getAccelerator() {
        return (KeyCombination)this.accelerator.get();
    }

    public Button makeButton() {
        Button button = new Button(this.name);
        button.disableProperty().bind((ObservableValue)this.disabledOrUnavailable);
        button.setOnAction(e -> this.actionPerformed(false));
        if (this.buttonGraphic != null) {
            button.setGraphic(this.buttonGraphic);
        }
        return button;
    }

    public MenuItem makeMenuItem() {
        MenuItem menuItem = new MenuItem(this.menuText);
        this.prepareMenuItem(menuItem);
        return menuItem;
    }

    private void prepareMenuItem(MenuItem menuItem) {
        boolean cmdPlusMinusOnMac;
        this.setMenuActionAndDisable(menuItem, false);
        boolean bl = cmdPlusMinusOnMac = Config.isMacOS() && this.accelerator.get() != null && (((KeyCombination)this.accelerator.get()).equals((Object)new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})) || ((KeyCombination)this.accelerator.get()).equals((Object)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})) || ((KeyCombination)this.accelerator.get()).equals((Object)new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.META_DOWN})) || ((KeyCombination)this.accelerator.get()).equals((Object)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.META_DOWN})));
        if (!cmdPlusMinusOnMac) {
            menuItem.acceleratorProperty().bind(this.accelerator);
            this.hasMenuItem = true;
        }
    }

    public MenuItem makeContextMenuItem(String nameOverride) {
        MenuItem menuItem = new MenuItem(nameOverride != null ? nameOverride : this.menuText);
        this.setMenuActionAndDisable(menuItem, true);
        return menuItem;
    }

    private void setMenuActionAndDisable(MenuItem menuItem, boolean contextMenu) {
        menuItem.disableProperty().bind((ObservableValue)this.disabledOrUnavailable);
        menuItem.setOnAction(e -> this.actionPerformed(true));
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FXAbstractAction that = (FXAbstractAction)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean hasMenuItemWithAccelerator(KeyCombination shortcut) {
        return this.hasMenuItem && Objects.equals(this.accelerator.get(), shortcut);
    }
}

