/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.StringConverter;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class NotAProjectDialog {
    private static final ButtonType OPEN_BUTTON = ButtonType.NEXT;
    private final ListView<File> subDirList;
    private final Dialog<ChoiceAndFile> dialog = new Dialog();
    private ChoiceAndFile selected;

    public NotAProjectDialog(Window parent, File original, List<File> possibilities) {
        this.dialog.initOwner(parent);
        this.dialog.initModality(Modality.WINDOW_MODAL);
        String labelRoot = "notAProject." + (Config.isGreenfoot() ? "greenfoot" : "bluej");
        this.dialog.setTitle(Config.getString(labelRoot + ".title"));
        this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        Config.addDialogStylesheets((Pane)this.dialog.getDialogPane());
        VBox content = new VBox(new Node[]{new Label(Config.getString(labelRoot + ".message") + "\n    " + original.getAbsolutePath())});
        JavaFXUtil.addStyleClass((Styleable)content, "not-a-project");
        content.setFillWidth(true);
        if (possibilities != null && !possibilities.isEmpty()) {
            this.dialog.getDialogPane().getButtonTypes().add((Object)OPEN_BUTTON);
            Button openButton = (Button)this.dialog.getDialogPane().lookupButton(OPEN_BUTTON);
            openButton.setText(Config.getString(labelRoot + ".subDirButton"));
            content.getChildren().add((Object)new Label(Config.getString(labelRoot + ".subDirs")));
            this.subDirList = new ListView(FXCollections.observableArrayList(possibilities));
            this.subDirList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            this.subDirList.setEditable(false);
            this.subDirList.setCellFactory(v -> {
                TextFieldListCell cell = new TextFieldListCell((StringConverter)new StringConverter<File>(){

                    public String toString(File object) {
                        return object.getAbsolutePath();
                    }

                    public File fromString(String string) {
                        throw new UnsupportedOperationException();
                    }
                });
                cell.setOnMouseClicked(arg_0 -> this.lambda$new$0((ListCell)cell, openButton, arg_0));
                return cell;
            });
            this.subDirList.prefHeightProperty().set((double)(possibilities.size() * 26 + 20));
            this.subDirList.setMaxHeight(300.0);
            openButton.disableProperty().bind((ObservableValue)this.subDirList.getSelectionModel().selectedItemProperty().isNull());
            JavaFXUtil.addStyleClass(this.subDirList, new String[]{"subDirs"});
            content.getChildren().add(this.subDirList);
        } else {
            this.subDirList = null;
        }
        ((Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK)).setText(Config.getString(labelRoot + ".button"));
        this.dialog.getDialogPane().setContent((Node)content);
        this.dialog.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return new ChoiceAndFile(Choice.CHOOSE_AGAIN, null);
            }
            if (button == OPEN_BUTTON) {
                return new ChoiceAndFile(Choice.SELECTED_FILE, (File)this.subDirList.getSelectionModel().getSelectedItem());
            }
            if (button == ButtonType.CANCEL) {
                return new ChoiceAndFile(Choice.CANCEL, null);
            }
            return this.selected;
        });
    }

    public void showAndWait() {
        this.selected = this.dialog.showAndWait().orElse(new ChoiceAndFile(Choice.CANCEL, null));
    }

    public boolean isCancel() {
        return this.selected.choice == Choice.CANCEL;
    }

    public boolean isChooseAgain() {
        return this.selected.choice == Choice.CHOOSE_AGAIN;
    }

    public File getSelectedDir() {
        return this.selected.file;
    }

    private /* synthetic */ void lambda$new$0(ListCell cell, Button openButton, MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == MouseButton.PRIMARY) {
            this.subDirList.getSelectionModel().select((Object)((File)cell.getItem()));
            openButton.fire();
        }
    }

    private static class ChoiceAndFile {
        private final Choice choice;
        private final File file;

        public ChoiceAndFile(Choice choice, File file) {
            this.choice = choice;
            this.file = file;
        }
    }

    private static enum Choice {
        CANCEL,
        CHOOSE_AGAIN,
        SELECTED_FILE;

    }
}

