/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TypeList {
    private final ObservableList<HeaderItem> headerItems = FXCollections.observableArrayList();
    protected final ObservableList<TypeSlot> typeSlots = FXCollections.observableArrayList();
    private final Supplier<TypeSlot> slotGenerator;
    private final Frame parentFrame;
    private final FXRunnable focusOnNext;
    private InteractionManager editor;
    private final BooleanProperty focusedProperty = new SimpleBooleanProperty(false);

    protected TypeList(String label, Frame parentFrame, Supplier<TypeSlot> slotGenerator, FXRunnable focusOnNext, InteractionManager editor) {
        this.parentFrame = parentFrame;
        this.slotGenerator = slotGenerator;
        this.focusOnNext = focusOnNext;
        this.editor = editor;
        final SlotLabel prefixLabel = new SlotLabel(label, new String[0]);
        new DeepListBinding<HeaderItem>(this.headerItems){

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.of(TypeList.this.typeSlots);
            }

            @Override
            protected Stream<HeaderItem> calculateValues() {
                if (TypeList.this.typeSlots.isEmpty()) {
                    return Stream.empty();
                }
                ArrayList<SlotLabel> commas = new ArrayList<SlotLabel>();
                for (int i = 0; i < TypeList.this.typeSlots.size() - 1; ++i) {
                    commas.add(new SlotLabel(", ", new String[0]));
                }
                return Utility.concat(Stream.of(prefixLabel), Utility.interleave(TypeList.this.typeSlots.stream().map(h -> h), commas.stream()));
            }
        }.startListening();
        ChangeListener focusListener = (a, b, newVal) -> this.updateFocusedProperty();
        this.typeSlots.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(slot -> slot.effectivelyFocusedProperty().addListener(focusListener));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(slot -> slot.effectivelyFocusedProperty().removeListener(focusListener));
            }
            this.updateFocusedProperty();
        });
    }

    private void updateFocusedProperty() {
        this.focusedProperty.set(this.typeSlots.stream().anyMatch(slot -> (Boolean)slot.effectivelyFocusedProperty().getValue()));
    }

    public ObservableList<HeaderItem> getHeaderItems() {
        return this.headerItems;
    }

    private TypeSlot addTypeSlot(int index) {
        TypeSlot slot = this.slotGenerator.get();
        slot.addBackspaceAtStartListener(() -> this.backSpacePressedAtStart(slot));
        slot.addDeleteAtEndListener(() -> this.deletePressedAtEnd(slot));
        slot.onTopLevelComma((before, after) -> {
            TypeSlot newSlot = this.addTypeSlot(this.typeSlots.indexOf((Object)slot) + 1);
            slot.setText((String)before);
            newSlot.setText((String)after);
            newSlot.requestFocus(Focus.LEFT);
        });
        slot.addFocusListener(this.parentFrame);
        slot.addClosingChar(' ');
        this.typeSlots.add(index, (Object)slot);
        return slot;
    }

    private boolean backSpacePressedAtStart(TypeSlot slot) {
        int index = this.typeSlots.indexOf((Object)slot);
        String remainder = this.delete(slot);
        if (index - 1 >= 0 && index - 1 < this.typeSlots.size()) {
            TypeSlot prev = (TypeSlot)this.typeSlots.get(index - 1);
            prev.setText(prev.getText() + remainder);
            prev.requestFocus();
            prev.recallFocus(prev.getText().length() - remainder.length());
            return true;
        }
        this.focusOnNext.run();
        return true;
    }

    private boolean deletePressedAtEnd(TypeSlot slot) {
        int index = this.typeSlots.indexOf((Object)slot);
        if (index < this.typeSlots.size() - 1) {
            String remainder = this.delete((TypeSlot)this.typeSlots.get(index + 1));
            String prev = ((TypeSlot)this.typeSlots.get(index)).getText();
            ((TypeSlot)this.typeSlots.get(index)).setText(prev + remainder);
            ((TypeSlot)this.typeSlots.get(index)).recallFocus(prev.length());
            return false;
        }
        this.delete(slot);
        this.focusOnNext.run();
        return true;
    }

    private String delete(TypeSlot slot) {
        slot.cleanup();
        this.typeSlots.remove((Object)slot);
        this.editor.modifiedFrame(this.parentFrame, false);
        return slot.getText();
    }

    public void addTypeSlotAtEnd(String content, boolean requestFocus) {
        TypeSlot slot = this.addTypeSlot(this.typeSlots.size());
        slot.setText(content);
        if (requestFocus) {
            slot.requestFocus(Focus.LEFT);
        }
    }

    public void setTypes(List<String> types) {
        while (this.typeSlots.size() > 0) {
            this.delete((TypeSlot)this.typeSlots.get(this.typeSlots.size() - 1));
        }
        types.forEach(t -> this.addTypeSlotAtEnd((String)t, false));
    }

    public Stream<TypeSlot> getTypeSlots() {
        return this.typeSlots.stream();
    }

    public void ensureAtLeastOneSlot() {
        if (this.typeSlots.isEmpty()) {
            this.addTypeSlotAtEnd("", false);
        }
    }

    public void clearIfSingleEmpty() {
        if (this.typeSlots.size() == 1 && ((TypeSlot)this.typeSlots.get(0)).isEmpty()) {
            this.delete((TypeSlot)this.typeSlots.get(0));
        }
    }

    public ReadOnlyBooleanProperty focusedProperty() {
        return this.focusedProperty;
    }

    public void removeIndex(int index) {
        if (index >= 0 && index < this.typeSlots.size()) {
            this.delete((TypeSlot)this.typeSlots.get(index));
        }
    }
}

