/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.editor.fixes.SuggestionList;
import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorAndFixDisplay;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.framedjava.slots.UnderlineContainer;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.CopyableHeaderItem;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.SlotValueListener;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.AnnotatableTextField;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class TextSlot<SLOT_FRAGMENT extends TextSlotFragment>
implements EditableSlot,
ErrorAndFixDisplay.ErrorFixListener,
CopyableHeaderItem {
    private final List<SlotValueListener> listeners = new ArrayList<SlotValueListener>();
    protected final InteractionManager editor;
    protected final Frame frameParent;
    private final CodeFrame<? extends CodeElement> codeFrameParent;
    private final FrameContentRow row;
    private final SlotTextField field;
    private final ObjectProperty<SuggestionList> suggestionDisplayProperty = new SimpleObjectProperty();
    private final CompletionCalculator completionCalculator;
    private final SimpleDoubleProperty suggestionXOffset = new SimpleDoubleProperty();
    private SLOT_FRAGMENT slotElement;
    private ErrorAndFixDisplay errorAndFixDisplay;
    private final @OnThread(value=Tag.FXPlatform) List<CodeError> allErrors = new ArrayList<CodeError>();
    private final @OnThread(value=Tag.FXPlatform) List<CodeError> shownErrors = new ArrayList<CodeError>();
    private final List<UnderlineContainer.Underline> underlines = new ArrayList<UnderlineContainer.Underline>();
    private final ObservableList<String> recentValues = FXCollections.observableArrayList();
    private CodeError hoverErrorCurrentlyShown;
    private final BooleanBinding effectivelyFocusedProperty;
    private String slotName;

    protected TextSlot(InteractionManager editor, Frame frameParent, CodeFrame<? extends CodeElement> codeFrameParent, FrameContentRow row, CompletionCalculator completionCalculator, String stylePrefix, List<FrameCatalogue.Hint> hints) {
        this.editor = editor;
        this.completionCalculator = completionCalculator;
        this.frameParent = frameParent;
        this.codeFrameParent = codeFrameParent;
        if (frameParent != codeFrameParent) {
            throw new IllegalArgumentException("frameParent and codeFrameParent are not same object");
        }
        this.row = row;
        this.field = new SlotTextField(stylePrefix, row.getOverlay());
        editor.setupFocusableSlotComponent(this, this.field.getFocusableNode(), completionCalculator != null, row::getExtensions, hints);
        this.listeners.add((slot, oldValue, newValue, parent) -> {
            if (newValue.contains(";")) {
                return false;
            }
            this.setScreenReaderHelpSlots();
            return true;
        });
        this.effectivelyFocusedProperty = this.field.focusedProperty().or((ObservableBooleanValue)this.suggestionDisplayProperty.isNotNull());
    }

    @Override
    public ObservableBooleanValue effectivelyFocusedProperty() {
        return this.effectivelyFocusedProperty;
    }

    public Region getNode() {
        return this.field.getNode();
    }

    public Node getField() {
        return this.field.getFocusableNode();
    }

    public void setSlotName(String name) {
        this.slotName = name;
    }

    public void addValueListener(SlotValueListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Frame getParentFrame() {
        return this.frameParent;
    }

    public final String getText() {
        return (String)this.field.textProperty().get();
    }

    public final SLOT_FRAGMENT getSlotElement() {
        if (this.slotElement == null) {
            this.slotElement = this.createFragment(this.getText());
        }
        return this.slotElement;
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
        this.requestFocus();
        this.field.positionCaret(err.getStartPosition());
    }

    public final void setPromptText(String arg0) {
        this.field.promptTextProperty().set((Object)arg0);
    }

    public final void setText(String arg0) {
        this.field.textProperty().set((Object)arg0);
    }

    public void setText(SLOT_FRAGMENT f) {
        this.field.textProperty().set((Object)((StringSlotFragment)f).getContent());
        ((TextSlotFragment)f).registerSlot(this);
    }

    public final ReadOnlyStringProperty textProperty() {
        return this.field.textProperty();
    }

    @Override
    public void requestFocus(Focus on) {
        this.field.requestFocus();
        if (null != on) {
            switch (on) {
                case LEFT: {
                    this.field.positionCaret(0);
                    break;
                }
                case RIGHT: {
                    this.field.positionCaret(this.field.getLength());
                    break;
                }
                case SELECT_ALL: {
                    this.field.selectAll();
                    break;
                }
            }
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void addError(CodeError err) {
        this.allErrors.add(err);
        err.bindFresh((ObservableBooleanValue)this.getFreshExtra(err).or(this.getParentFrame().freshProperty()), this.editor);
        this.recalculateShownErrors();
    }

    protected BooleanExpression getFreshExtra(CodeError err) {
        return new ReadOnlyBooleanWrapper(false);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void flagErrorsAsOld() {
        this.allErrors.forEach(CodeError::flagAsOld);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeOldErrors() {
        this.allErrors.removeIf(CodeError::isFlaggedAsOld);
        this.recalculateShownErrors();
    }

    @OnThread(value=Tag.FXPlatform)
    private void recalculateShownErrors() {
        this.shownErrors.clear();
        List sortedErrors = this.allErrors.stream().sorted((a, b) -> CodeError.compareErrors(a, b)).collect(Collectors.toList());
        for (CodeError e2 : sortedErrors) {
            if (this.shownErrors.stream().allMatch(shown -> !shown.overlaps(e2))) {
                this.shownErrors.add(e2);
                e2.setShowingIndicator(true);
                continue;
            }
            e2.setShowingIndicator(false);
        }
        this.field.clearErrorMarkers(this);
        this.shownErrors.forEach(e -> this.field.drawErrorMarker(this, e.getStartPosition(), e.getEndPosition(), e.isJavaPos(), b -> this.showErrorHover(b != false ? e : null), e.visibleProperty()));
        if (this.field.isFocused()) {
            this.showErrorAtCaret(this.field.getCaretPosition());
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void showErrorHover(CodeError error) {
        if (this.errorAndFixDisplay != null) {
            if (error != null && this.errorAndFixDisplay.getError().equals(error)) {
                this.hoverErrorCurrentlyShown = error;
                return;
            }
            int caretPosition = this.field.getCaretPosition();
            Optional<CodeError> errorAtCaret = this.shownErrors.stream().filter(e -> e.getStartPosition() <= caretPosition && caretPosition <= e.getEndPosition()).findFirst();
            if (error == null && this.field.isFocused() && errorAtCaret.isPresent() && errorAtCaret.get().equals(this.errorAndFixDisplay.getError())) {
                this.hoverErrorCurrentlyShown = null;
                return;
            }
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
        if (error != null && error.visibleProperty().get()) {
            this.hoverErrorCurrentlyShown = error;
            this.errorAndFixDisplay = new ErrorAndFixDisplay(this.editor, error, this);
            this.errorAndFixDisplay.showBelow(this.field.getNode(), Duration.ZERO);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void showErrorAtCaret(int caretPosition) {
        Optional<CodeError> errorAtCaret = this.shownErrors.stream().filter(e -> e.getStartPosition() <= caretPosition && caretPosition <= e.getEndPosition()).findFirst();
        if (errorAtCaret.isPresent() && this.errorAndFixDisplay != null && this.errorAndFixDisplay.getError().equals(errorAtCaret.get())) {
            return;
        }
        if (this.errorAndFixDisplay != null) {
            this.errorAndFixDisplay.hide();
            this.errorAndFixDisplay = null;
        }
        if (errorAtCaret.isPresent() && errorAtCaret.get().visibleProperty().get()) {
            this.errorAndFixDisplay = new ErrorAndFixDisplay(this.editor, errorAtCaret.get(), this);
            this.errorAndFixDisplay.showBelow(this.field.getNode());
        }
    }

    public int getStartOfCurWord() {
        for (int i = Math.min(this.field.getCaretPosition(), this.getText().length()) - 1; i >= 0; --i) {
            if (Character.isJavaIdentifierPart(this.getText().charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public void cleanup() {
        if (this.editor.getCodeOverlayPane() != null && this.errorAndFixDisplay != null) {
            ErrorAndFixDisplay errorAndFixDisplayToHide = this.errorAndFixDisplay;
            JavaFXUtil.runNowOrLater(() -> errorAndFixDisplayToHide.hide());
            this.errorAndFixDisplay = null;
        }
        JavaFXUtil.runNowOrLater(() -> this.field.clearErrorMarkers(this));
    }

    public void replace(int startPosInSlot, int endPosInSlot, String replacement) {
        String before = this.getText().substring(0, startPosInSlot);
        String after = this.getText().substring(endPosInSlot);
        this.setText(before + replacement + after);
        this.field.positionCaret(before.length() + replacement.length());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void fixedError(CodeError err) {
        this.allErrors.remove(err);
        this.recalculateShownErrors();
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean executeSuggestion(SuggestionList suggestionList, int highlighted) {
        int position = this.getStartOfCurWord();
        String word = this.field.getCurWord();
        boolean success = this.field.executeCompletion(this.completionCalculator, highlighted, position);
        if (success) {
            this.editor.recordCodeCompletionEnded((SlotFragment)this.getSlotElement(), position, word, this.getText(), suggestionList.getRecordingId());
        }
        return success;
    }

    public boolean isEmpty() {
        return ((String)this.field.textProperty().get()).isEmpty();
    }

    public void addFocusListener(Frame frame) {
        this.field.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                frame.checkForEmptySlot();
            }
        });
    }

    @Override
    public boolean isFocused() {
        return this.field.isFocused();
    }

    @Override
    public int getFocusInfo() {
        return this.field.getCaretPosition();
    }

    @Override
    public Node recallFocus(int info) {
        this.requestFocus(Focus.LEFT);
        this.field.positionCaret(info);
        return this.field.getNode();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Stream<CodeError> getCurrentErrors() {
        return this.shownErrors.stream();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void addUnderline(UnderlineContainer.Underline u) {
        this.underlines.add(u);
        this.drawUnderlines();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeAllUnderlines() {
        this.underlines.clear();
        this.drawUnderlines();
    }

    @OnThread(value=Tag.FXPlatform)
    private void drawUnderlines() {
        this.field.clearUnderlines();
        this.underlines.forEach(u -> this.field.drawUnderline(this, u.getStartPosition(), u.getEndPosition(), u.getOnClick()));
    }

    @Override
    public void saved() {
    }

    public ObservableList<Node> getComponents() {
        return FXCollections.observableArrayList((Object[])new Node[]{this.field.getNode()});
    }

    @Override
    public TextOverlayPosition getOverlayLocation(int caretPos, boolean javaPos) {
        return this.field.getOverlayLocation(caretPos);
    }

    @Override
    public abstract List<? extends PossibleLink> findLinks();

    @Override
    public void lostFocus() {
        this.field.setTransparent(!this.getText().isEmpty());
    }

    protected abstract SLOT_FRAGMENT createFragment(String var1);

    @OnThread(value=Tag.FXPlatform)
    public abstract void valueChangedLostFocus(String var1, String var2);

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.field.editableProperty().set(newView == Frame.View.NORMAL);
        this.field.disableProperty().set(newView != Frame.View.NORMAL);
        if (newView == Frame.View.JAVA_PREVIEW) {
            animate.addOnStopped(() -> JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, this.field.getFocusableNode()));
        } else {
            JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, this.field.getFocusableNode());
        }
    }

    protected Map<EditableSlot.TopLevelMenu, AbstractOperation.MenuItems> getExtraContextMenuItems() {
        return Collections.emptyMap();
    }

    @Override
    public final Map<EditableSlot.TopLevelMenu, AbstractOperation.MenuItems> getMenuItems(boolean contextMenu) {
        HashMap<EditableSlot.TopLevelMenu, AbstractOperation.MenuItems> itemMap = new HashMap<EditableSlot.TopLevelMenu, AbstractOperation.MenuItems>(this.getExtraContextMenuItems());
        ObservableList menuItems = FXCollections.observableArrayList();
        if (contextMenu) {
            menuItems.add((Object)this.getRecentValuesMenu());
        }
        final MenuItem cutItem = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.cut"), this.field::cut, (KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        final MenuItem copyItem = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.copy"), this.field::copy, (KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN}));
        final MenuItem pasteItem = JavaFXUtil.makeMenuItem(Config.getString("frame.slot.paste"), this.field::paste, (KeyCombination)(Config.isMacOS() ? null : new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCodeCombination.SHORTCUT_DOWN})));
        menuItems.addAll((Object[])new AbstractOperation.SortedMenuItem[]{AbstractOperation.MenuItemOrder.CUT.item(cutItem), AbstractOperation.MenuItemOrder.COPY.item(copyItem), AbstractOperation.MenuItemOrder.PASTE.item(pasteItem)});
        itemMap.put(EditableSlot.TopLevelMenu.EDIT, AbstractOperation.MenuItems.concat(new AbstractOperation.MenuItems(menuItems){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void onShowing() {
                boolean selectionPresent;
                if (TextSlot.this.hoverErrorCurrentlyShown != null) {
                    TextSlot.this.errorAndFixDisplay.hide();
                }
                cutItem.setDisable(!(selectionPresent = TextSlot.this.field.hasSelection()));
                copyItem.setDisable(!selectionPresent);
                pasteItem.setDisable(!Clipboard.getSystemClipboard().hasString());
            }
        }, (AbstractOperation.MenuItems)itemMap.get((Object)EditableSlot.TopLevelMenu.EDIT)));
        return itemMap;
    }

    private AbstractOperation.SortedMenuItem getRecentValuesMenu() {
        Menu recent = new Menu(Config.getString("frame.slot.recent"));
        recent.setDisable(true);
        this.recentValues.addListener(c -> {
            recent.getItems().clear();
            if (this.recentValues.isEmpty()) {
                recent.setDisable(true);
            } else {
                recent.setDisable(false);
                this.recentValues.forEach(v -> {
                    MenuItem item = new MenuItem(v);
                    item.setOnAction(e -> {
                        this.editor.recordEdits(StrideEditReason.FLUSH);
                        this.setText((String)v);
                        this.editor.recordEdits(StrideEditReason.UNDO_LOCAL);
                    });
                    recent.getItems().add((Object)item);
                });
            }
        });
        return AbstractOperation.MenuItemOrder.RECENT_VALUES.item((MenuItem)recent);
    }

    @Override
    public boolean isAlmostBlank() {
        return this.getText().isEmpty();
    }

    @Override
    public boolean isEditable() {
        return !this.field.disableProperty().get();
    }

    @Override
    public void setEditable(boolean editable) {
        this.field.disableProperty().set(!editable);
    }

    public Stream<Node> makeDisplayClone(InteractionManager editor) {
        TextField f = new TextField();
        f.textProperty().bind((ObservableValue)this.field.textProperty());
        f.prefWidthProperty().bind((ObservableValue)this.field.prefWidthProperty());
        JavaFXUtil.bindList(f.getStyleClass(), this.field.getStyleClass());
        JavaFXUtil.bindPseudoclasses((Node)f, this.field.getPseudoClassStates());
        JavaFXUtil.setPseudoclass("bj-pinned", true, new Node[]{f});
        f.styleProperty().bind((ObservableValue)this.field.styleProperty().concat((Object)editor.getFontCSS()));
        return Stream.of(f);
    }

    @Override
    public int calculateEffort() {
        return Math.min(4, this.getText().length());
    }

    public void setScreenReaderHelpSlots() {
        Object text = "TextSlot";
        try {
            text = "You are in the " + this.slotName + " in the " + this.getParentFrame().getFrameName() + " frame " + this.getParentFrame().getParentCanvas().getParentLocationDescription();
        }
        catch (NullPointerException e) {
            text = "You are in the " + this.slotName;
        }
        this.field.setscreenReaderHelp((String)text);
    }

    public class SlotTextField
    extends AnnotatableTextField {
        private String lastBeforePrefix;
        private String valueOnGain;

        private SlotTextField(String stylePrefix, ErrorUnderlineCanvas overlay) {
            super(overlay);
            this.addStyleClasses("text-slot", stylePrefix + "text-slot");
            this.prefWidthProperty().set(10.0);
            SuggestionList.SuggestionListListener suggestionListener = new SuggestionList.SuggestionListListener(){

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void suggestionListChoiceClicked(SuggestionList suggestionList, int highlighted) {
                    TextSlot.this.executeSuggestion(suggestionList, highlighted);
                    TextSlot.this.row.focusRight(TextSlot.this);
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public SuggestionList.SuggestionListListener.Response suggestionListKeyTyped(SuggestionList suggestionList, KeyEvent event, int highlighted) {
                    if (event.getCharacter().equals(" ") && this.completeIfPossible(suggestionList, highlighted)) {
                        TextSlot.this.row.focusRight(TextSlot.this);
                        return SuggestionList.SuggestionListListener.Response.DISMISS;
                    }
                    if (!event.getCharacter().equals("\b")) {
                        SlotTextField.this.injectEvent(event);
                    }
                    return SuggestionList.SuggestionListListener.Response.CONTINUE;
                }

                @OnThread(value=Tag.FXPlatform)
                private boolean completeIfPossible(SuggestionList suggestionList, int highlighted) {
                    if (highlighted != -1) {
                        return TextSlot.this.executeSuggestion(suggestionList, highlighted);
                    }
                    if (((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).eligibleCount() == 1 && TextSlot.this.getText().length() > 0) {
                        return TextSlot.this.executeSuggestion(suggestionList, ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).getFirstEligible());
                    }
                    return false;
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public SuggestionList.SuggestionListListener.Response suggestionListKeyPressed(SuggestionList suggestionList, KeyEvent event, int highlighted) {
                    switch (event.getCode()) {
                        case BACK_SPACE: {
                            SlotTextField.this.backspace();
                            return SuggestionList.SuggestionListListener.Response.CONTINUE;
                        }
                        case LEFT: {
                            if (SlotTextField.this.getCaretPosition() == 0) {
                                TextSlot.this.row.focusLeft(TextSlot.this);
                                return SuggestionList.SuggestionListListener.Response.DISMISS;
                            }
                            SlotTextField.this.positionCaret(SlotTextField.this.getCaretPosition() - 1);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case RIGHT: {
                            Optional<String> common = ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).getLongestCommonPrefix();
                            if (common.isPresent()) {
                                boolean single = ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).eligibleCount() == 1;
                                TextSlot.this.field.replaceText(TextSlot.this.getStartOfCurWord(), TextSlot.this.field.getCaretPosition(), common.get());
                                if (!single) break;
                                return SuggestionList.SuggestionListListener.Response.DISMISS;
                            }
                            TextSlot.this.row.focusRight(TextSlot.this);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case ENTER: {
                            if (!TextSlot.this.executeSuggestion(suggestionList, highlighted)) break;
                            TextSlot.this.row.focusRight(TextSlot.this);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case ESCAPE: {
                            SlotTextField.this.setTransparent(false);
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                        case TAB: {
                            if (event.isShiftDown()) {
                                TextSlot.this.row.focusLeft(TextSlot.this);
                            } else {
                                TextSlot.this.row.focusRight(TextSlot.this);
                                this.completeIfPossible(suggestionList, highlighted);
                            }
                            return SuggestionList.SuggestionListListener.Response.DISMISS;
                        }
                    }
                    return SuggestionList.SuggestionListListener.Response.CONTINUE;
                }

                @Override
                public void hidden() {
                    TextSlot.this.suggestionDisplayProperty.set(null);
                    SlotTextField.this.setFakeCaretShowing(false);
                }
            };
            this.onKeyPressedProperty().set(event -> {
                if (event.isShiftDown() && event.isControlDown() && event.getCharacter().length() > 0 && event.getCode() != KeyCode.CONTROL && event.getCode() != KeyCode.SHIFT) {
                    TextSlot.this.row.notifyModifiedPress(event.getCode());
                    event.consume();
                    return;
                }
                switch (event.getCode()) {
                    case UP: {
                        if (TextSlot.this.errorAndFixDisplay != null && TextSlot.this.errorAndFixDisplay.hasFixes() && TextSlot.this.errorAndFixDisplay.isShowing()) {
                            TextSlot.this.errorAndFixDisplay.up();
                        } else {
                            TextSlot.this.row.focusUp(TextSlot.this, false);
                        }
                        event.consume();
                        break;
                    }
                    case DOWN: {
                        if (TextSlot.this.errorAndFixDisplay != null && TextSlot.this.errorAndFixDisplay.hasFixes() && TextSlot.this.errorAndFixDisplay.isShowing()) {
                            TextSlot.this.errorAndFixDisplay.down();
                        } else {
                            TextSlot.this.row.focusDown(TextSlot.this);
                        }
                        event.consume();
                        break;
                    }
                    case LEFT: {
                        if (this.getSelection().getStart() != 0) break;
                        TextSlot.this.row.focusLeft(TextSlot.this);
                        event.consume();
                        break;
                    }
                    case RIGHT: {
                        if (this.getSelection().getEnd() != this.getLength()) break;
                        TextSlot.this.row.focusRight(TextSlot.this);
                        event.consume();
                        break;
                    }
                    case ENTER: {
                        if (TextSlot.this.errorAndFixDisplay != null) {
                            TextSlot.this.errorAndFixDisplay.executeSelected();
                        } else {
                            TextSlot.this.row.focusEnter(TextSlot.this);
                        }
                        event.consume();
                        break;
                    }
                    case BACK_SPACE: {
                        if (this.getCaretPosition() != 0 || this.hasSelection()) break;
                        for (SlotValueListener listener : TextSlot.this.listeners) {
                            listener.backSpacePressedAtStart(TextSlot.this);
                        }
                        event.consume();
                        break;
                    }
                    case DELETE: {
                        if (this.getCaretPosition() != this.getLength() || this.anchorProperty().get() != this.getCaretPosition()) break;
                        for (SlotValueListener listener : TextSlot.this.listeners) {
                            listener.deletePressedAtEnd(TextSlot.this);
                        }
                        event.consume();
                        break;
                    }
                    case SPACE: {
                        if (!event.isControlDown()) break;
                        this.showSuggestionDisplay(suggestionListener);
                        event.consume();
                        break;
                    }
                    case ESCAPE: {
                        TextSlot.this.row.escape(TextSlot.this);
                        break;
                    }
                }
            });
            JavaFXUtil.addFocusListener(this.getFocusableNode(), newValue -> {
                if (newValue.booleanValue()) {
                    this.valueOnGain = TextSlot.this.getText();
                    TextSlot.this.editor.beginRecordingState(TextSlot.this);
                    this.setTransparent(false);
                    Platform.runLater(this::deselect);
                    TextSlot.this.showErrorAtCaret(this.getCaretPosition());
                } else {
                    this.setTransparent(!TextSlot.this.getText().isEmpty() && TextSlot.this.suggestionDisplayProperty.get() == null);
                    TextSlot.this.editor.endRecordingState(TextSlot.this);
                    if (TextSlot.this.errorAndFixDisplay != null) {
                        TextSlot.this.errorAndFixDisplay.hide();
                        TextSlot.this.errorAndFixDisplay = null;
                    }
                    if (!TextSlot.this.getText().equals(this.valueOnGain)) {
                        TextSlot.this.recentValues.removeAll((Object[])new String[]{TextSlot.this.getText()});
                        TextSlot.this.recentValues.removeAll((Object[])new String[]{this.valueOnGain});
                        TextSlot.this.recentValues.add(0, (Object)this.valueOnGain);
                        while (TextSlot.this.recentValues.size() > 3) {
                            TextSlot.this.recentValues.remove(3);
                        }
                        TextSlot.this.valueChangedLostFocus(this.valueOnGain, TextSlot.this.getText());
                    }
                }
            });
            this.textProperty().addListener((observable, oldValue, newValue) -> {
                TextSlot.this.slotElement = null;
                if (!this.isFocused() && TextSlot.this.suggestionDisplayProperty.get() == null && newValue.length() > 0) {
                    this.setTransparent(true);
                }
                boolean allowed = true;
                for (SlotValueListener listener : TextSlot.this.listeners) {
                    boolean listenerAllow = listener.valueChanged(TextSlot.this, (String)oldValue, (String)newValue, TextSlot.this.row);
                    allowed = allowed && listenerAllow;
                }
                if (!allowed) {
                    TextSlot.this.setText((String)oldValue);
                } else {
                    JavaFXUtil.runPlatformLater(() -> {
                        if (TextSlot.this.suggestionDisplayProperty.get() != null) {
                            String beforeNewPrefix = TextSlot.this.getText().substring(0, TextSlot.this.getStartOfCurWord());
                            if (!beforeNewPrefix.equals(this.lastBeforePrefix)) {
                                if (!beforeNewPrefix.endsWith("(")) {
                                    this.showSuggestionDisplay(suggestionListener);
                                }
                            } else {
                                this.updateSuggestions(true);
                            }
                        }
                    });
                    TextSlot.this.editor.modifiedFrame(TextSlot.this.frameParent, false);
                }
            });
            this.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
                private String lastText;
                private double monospaceWidth;
                {
                    super.bind(new Observable[]{SlotTextField.this.textProperty()});
                    super.bind(new Observable[]{SlotTextField.this.promptTextProperty()});
                    super.bind(new Observable[]{SlotTextField.this.fontProperty()});
                }

                protected double computeValue() {
                    String effectiveText = ((String)SlotTextField.this.textProperty().get()).length() > 0 ? (String)SlotTextField.this.textProperty().get() : (String)SlotTextField.this.promptTextProperty().get();
                    return Math.max(10.0, 5.0 + SlotTextField.this.measureString(effectiveText, true));
                }
            });
            this.prefWidthProperty().bind((ObservableValue)this.minWidthProperty());
            this.caretPositionProperty().addListener((observable, oldValue, newVal) -> {
                if (this.isFocused()) {
                    JavaFXUtil.runNowOrLater(() -> TextSlot.this.showErrorAtCaret(newVal.intValue()));
                }
            });
            JavaFXUtil.onceInScene((Node)this.getNode(), () -> this.setContextMenu(AbstractOperation.MenuItems.makeContextMenu(TextSlot.this.getMenuItems(true))));
        }

        public final int getCaretPosition() {
            return this.caretPositionProperty().get();
        }

        protected void setTransparent(boolean transparent) {
            TextSlot.this.field.setPseudoclass("bj-transparent", transparent);
        }

        public String getCurWord() {
            return TextSlot.this.getText().substring(TextSlot.this.getStartOfCurWord(), this.getCaretPosition());
        }

        @OnThread(value=Tag.FXPlatform)
        private void updateSuggestions(boolean initialState) {
            String prefix = this.getCurWord();
            ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).calculateEligible(prefix, true, initialState);
            ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).updateVisual(prefix);
            this.lastBeforePrefix = TextSlot.this.getText().substring(0, TextSlot.this.getStartOfCurWord());
        }

        @OnThread(value=Tag.FXPlatform)
        private void showSuggestionDisplay(SuggestionList.SuggestionListListener listener) {
            if (TextSlot.this.completionCalculator == null) {
                return;
            }
            TextSlot.this.suggestionXOffset.set(this.calculateCaretPosition(TextSlot.this.getStartOfCurWord()));
            FXPlatformConsumer<SuggestionList> handler = s -> {
                TextSlot.this.suggestionDisplayProperty.set(s);
                this.updateSuggestions(true);
                ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).highlightFirstEligible();
                ((SuggestionList)TextSlot.this.suggestionDisplayProperty.get()).show((Node)TextSlot.this.field.getNode(), (Bounds)new BoundingBox(TextSlot.this.suggestionXOffset.get(), 0.0, 0.0, TextSlot.this.field.heightProperty().get()));
                TextSlot.this.field.setFakeCaretShowing(true);
            };
            TextSlot.this.editor.afterRegenerateAndReparse(() -> {
                int stringPos = TextSlot.this.field.getCaretPosition();
                TextSlot.this.completionCalculator.withCalculatedSuggestionList(TextSlot.this.getSlotElement().getPosInSourceDoc(stringPos), TextSlot.this.codeFrameParent.getCode(), listener, suggList -> {
                    TextSlot.this.editor.recordCodeCompletionStarted((SlotFragment)TextSlot.this.getSlotElement(), stringPos, this.getCurWord(), suggList.getRecordingId());
                    handler.accept((SuggestionList)suggList);
                });
            });
        }

        @Override
        protected double calculateCaretPosition(int beforeIndex) {
            return super.calculateCaretPosition(beforeIndex);
        }

        public TextOverlayPosition getOverlayLocation(int caretPos) {
            double x;
            if (caretPos == Integer.MAX_VALUE) {
                x = this.widthProperty().get();
            } else {
                caretPos = Math.max(0, Math.min(caretPos, this.getLength()));
                x = this.calculateCaretPosition(caretPos);
            }
            return TextOverlayPosition.nodeToOverlay((Node)TextSlot.this.field.getNode(), x, 0.0, this.getBaseline(), TextSlot.this.field.heightProperty().get());
        }
    }
}

