/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.FrameState;
import bluej.utility.javafx.FXRunnable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class UndoRedoManager {
    private int current = 0;
    private boolean recording = false;
    private boolean restoring = false;
    private final List<FrameState> statesStack = new LinkedList<FrameState>();
    private final List<FXRunnable> listeners = new ArrayList<FXRunnable>();
    private static final int MAX_CAPACITY = 30;

    public UndoRedoManager(FrameState initialState) {
        this.statesStack.add(initialState);
    }

    private void addState(FrameState state) {
        if (!this.restoring) {
            boolean newState = false;
            if (this.statesStack.size() > 0 && state.equals(this.statesStack.get(this.current))) {
                this.statesStack.set(this.current, state);
            } else {
                newState = true;
                while (this.canRedo()) {
                    this.statesStack.remove(this.statesStack.size() - 1);
                }
                this.statesStack.add(state);
                ++this.current;
                if (this.statesStack.size() > 30) {
                    --this.current;
                    this.statesStack.remove(0);
                }
            }
            this.runListeners();
        }
    }

    public void beginFrameState(FrameState state) {
        this.recording = true;
        this.addState(state);
    }

    public void endFrameState(FrameState state) {
        this.recording = false;
        this.addState(state);
    }

    public boolean canUndo() {
        return this.current > 0;
    }

    public boolean canRedo() {
        return this.current < this.statesStack.size() - 1;
    }

    public FrameState undo() {
        this.recording = false;
        if (this.canUndo()) {
            --this.current;
            this.runListeners();
            return this.statesStack.get(this.current);
        }
        return null;
    }

    private void runListeners() {
        ArrayList<FXRunnable> listenersCopy = new ArrayList<FXRunnable>(this.listeners);
        listenersCopy.forEach(FXRunnable::run);
    }

    public FrameState redo() {
        this.recording = false;
        if (this.canRedo()) {
            ++this.current;
            this.runListeners();
            return this.statesStack.get(this.current);
        }
        return null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void startRestoring() {
        this.restoring = true;
    }

    public void stopRestoring() {
        this.restoring = false;
    }

    public FrameState getCurrent() {
        return this.statesStack.get(this.current);
    }

    public void addListener(FXRunnable listChangeListener) {
        this.listeners.add(listChangeListener);
    }

    public void removeListener(FXRunnable listChangeListener) {
        this.listeners.remove(listChangeListener);
    }

    public boolean canUndoToReference(FrameState restoreTarget, int withinNumUndos) {
        int index = -1;
        for (int i = 0; i < this.statesStack.size(); ++i) {
            if (this.statesStack.get(i) != restoreTarget) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        return index < this.current && this.current - index <= withinNumUndos;
    }
}

