/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import java.util.HashMap;

public class ScreenreaderDictionary {
    private static HashMap<String, String> syntaxToTextMap = new HashMap<String, String>(){
        {
            this.put("(", " left bracket ");
            this.put(")", " right bracket ");
            this.put("{", " left curly bracket ");
            this.put("}", " right curly bracket ");
            this.put("[", " left square bracket ");
            this.put("]", " right square bracket ");
            this.put("#", " hash ");
            this.put("_", " underscore ");
            this.put("@", " at sign ");
            this.put(":", " colon ");
            this.put(";", " semicolon ");
            this.put(".", " dot ");
            this.put("\\", " back slash ");
            this.put("-", " minus ");
            this.put("+", " plus ");
            this.put("*", " times ");
            this.put("/", " divided by ");
            this.put("^", " caret ");
            this.put("%", " modulo ");
            this.put("++", " increment ");
            this.put("--", " decrement ");
            this.put("=", " equal ");
            this.put("+=", " increment by ");
            this.put("-=", " decrement by ");
            this.put("*=", " multiplied itself by ");
            this.put("/=", " divided itself by ");
            this.put("==", " is equal to ");
            this.put("!=", " is not equal to ");
            this.put("<", " is less than ");
            this.put(">", " is greater than ");
            this.put(">=", " is greater than or equal to ");
            this.put("<=", " is less than or equal to ");
            this.put("&&", " logical and ");
            this.put("||", " logical or ");
            this.put("!", " logical not ");
            this.put("|", " bitwise or ");
            this.put("&", " bitwise and ");
            this.put("~", " bitwise not ");
            this.put("<<", " zero-fill left shift ");
            this.put(">>", " signed right shift ");
            this.put(">>>", " zero-fill right shift");
            this.put("..", " dot dot ");
            this.put("<:", " left pointy colon ");
            this.put("::", " double colon ");
            this.put("->", " right arrow ");
        }
    };

    public static String transcribeForScreenreader(String inText) {
        String outText;
        if (syntaxToTextMap.containsKey(inText)) {
            outText = syntaxToTextMap.get(inText);
        } else {
            try {
                Float.parseFloat(inText);
                StringBuilder builder = new StringBuilder();
                block6: for (char c : inText.toCharArray()) {
                    switch (c) {
                        case '-': {
                            builder.append(" negative ");
                            continue block6;
                        }
                        case '.': {
                            builder.append(" point ");
                            continue block6;
                        }
                        default: {
                            builder.append(c);
                        }
                    }
                }
                outText = builder.toString();
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                for (char c : inText.toCharArray()) {
                    if (Character.isUpperCase(c)) {
                        builder.append(" " + c);
                        continue;
                    }
                    builder.append(c);
                }
                outText = builder.toString();
            }
        }
        return outText;
    }
}

