/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.SuperThis;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.stride.framedjava.slots.InfixExpression;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.ChoiceSlot;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.List;
import java.util.Optional;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ExpressionSlot<SLOT_FRAGMENT extends ExpressionSlotFragment>
extends StructuredSlot<SLOT_FRAGMENT, InfixExpression, ExpressionCompletionCalculator> {
    private ChoiceSlot<SuperThis> paramsToConstructor;

    public ExpressionSlot(InteractionManager editor, Frame parentFrame, CodeFrame<?> parentCodeFrame, FrameContentRow row, String stylePrefix, List<FrameCatalogue.Hint> hints) {
        super(editor, parentFrame, parentCodeFrame, row, stylePrefix, new ExpressionCompletionCalculator(editor), hints);
    }

    @Override
    public ExpressionSlot asExpressionSlot() {
        return this;
    }

    public void setText(ExpressionSlotFragment rhs) {
        rhs.registerSlot(this);
        this.setText(rhs.getContent());
    }

    @Override
    protected InfixExpression newInfix(InteractionManager editor, StructuredSlot.ModificationToken token) {
        return new InfixExpression(editor, this, token);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void saved() {
        if (this.getParentFrame().isFrameEnabled() && this.paramsToConstructor != null) {
            ((InfixExpression)this.topLevel).treatAsConstructorParams_updatePrompts();
        }
    }

    public void setParamsToConstructor(ChoiceSlot<SuperThis> paramsToConstructor) {
        this.paramsToConstructor = paramsToConstructor;
    }

    boolean isConstructorParams() {
        return this.paramsToConstructor != null;
    }

    @OnThread(value=Tag.FXPlatform)
    void withParamNamesForConstructor(FXPlatformConsumer<List<List<String>>> handler) {
        this.editor.afterRegenerateAndReparse(() -> ((ExpressionCompletionCalculator)this.completionCalculator).withConstructorParamNames(this.paramsToConstructor.getValue(SuperThis.EMPTY), handler));
    }

    @OnThread(value=Tag.FXPlatform)
    void withParamNamesForPos(CaretPos pos, String methodName, FXPlatformConsumer<List<List<String>>> handler) {
        this.editor.afterRegenerateAndReparse(() -> {
            JavaFragment.PosInSourceDoc posJava = ((ExpressionSlotFragment)this.getSlotElement()).getPosInSourceDoc(((InfixExpression)this.topLevel).caretPosToStringPos(pos, true));
            ((ExpressionCompletionCalculator)this.completionCalculator).withParamNames(posJava, this.asExpressionSlot(), methodName, (CodeElement)this.parentCodeFrame.getCode(), handler);
        });
    }

    @OnThread(value=Tag.FXPlatform)
    void withParamHintsForPos(CaretPos pos, String methodName, FXPlatformConsumer<List<List<String>>> handler) {
        this.editor.afterRegenerateAndReparse(() -> {
            JavaFragment.PosInSourceDoc posJava = ((ExpressionSlotFragment)this.getSlotElement()).getPosInSourceDoc(((InfixExpression)this.topLevel).caretPosToStringPos(pos, true));
            ((ExpressionCompletionCalculator)this.completionCalculator).withParamHints(posJava, this.asExpressionSlot(), methodName, (CodeElement)this.parentCodeFrame.getCode(), handler);
        });
    }

    @OnThread(value=Tag.FXPlatform)
    void withParamHintsForConstructor(int totalParams, FXPlatformConsumer<List<List<String>>> handler) {
        this.editor.afterRegenerateAndReparse(() -> ((ExpressionCompletionCalculator)this.completionCalculator).withConstructorParamHints(this.paramsToConstructor.getValue(SuperThis.EMPTY), totalParams, handler));
    }

    @OnThread(value=Tag.FXPlatform)
    void withMethodHint(CaretPos pos, String methodName, FXPlatformConsumer<List<String>> handler) {
        this.editor.afterRegenerateAndReparse(() -> {
            JavaFragment.PosInSourceDoc posJava = ((ExpressionSlotFragment)this.getSlotElement()).getPosInSourceDoc(((InfixExpression)this.topLevel).caretPosToStringPos(pos, true));
            ((ExpressionCompletionCalculator)this.completionCalculator).withMethodHints(posJava, this.asExpressionSlot(), methodName, (CodeElement)this.parentCodeFrame.getCode(), handler);
        });
    }

    @Override
    public boolean canCollapse() {
        return this.isConstructorParams();
    }

    @Override
    public List<? extends PossibleLink> findLinks() {
        return ((InfixExpression)this.topLevel).findLinks(Optional.empty(), ((ExpressionSlotFragment)this.getSlotElement()).getVars(), offset -> ((ExpressionSlotFragment)this.getSlotElement()).getPosInSourceDoc((int)offset), 0);
    }
}

