/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.DocumentContainerCodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.MethodProtoFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Node;

public class MethodProtoElement
extends DocumentContainerCodeElement {
    public static final String ELEMENT = "methodproto";
    private final TypeSlotFragment returnType;
    private final NameDefSlotFragment name;
    private final List<ParamFragment> params;
    private final List<ThrowsTypeFragment> throwsTypes;
    private MethodProtoFrame frame;

    public MethodProtoElement(MethodProtoFrame frame, TypeSlotFragment returnType, NameDefSlotFragment name, List<ParamFragment> params, List<ThrowsTypeFragment> throwsTypes, JavadocUnit documentation, boolean enabled) {
        this.frame = frame;
        this.returnType = returnType;
        this.name = name;
        this.params = params;
        this.throwsTypes = throwsTypes;
        this.enable = enabled;
        this.documentation = documentation;
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
    }

    public MethodProtoElement(Element el) {
        this.returnType = new TypeSlotFragment(el.getAttributeValue("type"), el.getAttributeValue("type-java"));
        this.name = new NameDefSlotFragment(el.getAttributeValue("name"));
        this.params = new ArrayList<ParamFragment>();
        this.throwsTypes = new ArrayList<ThrowsTypeFragment>();
        block10: for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            switch (child.getLocalName()) {
                case "params": {
                    this.params.add(new ParamFragment(child));
                    continue block10;
                }
                case "throws": {
                    for (int j = 0; j < child.getChildElements().size(); ++j) {
                        this.throwsTypes.add(new ThrowsTypeFragment(child.getChildElements().get(j)));
                    }
                    continue block10;
                }
                case "javadoc": {
                    this.documentation = new JavadocUnit(child);
                }
            }
        }
        if (this.documentation == null) {
            this.documentation = new JavadocUnit("");
        }
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    @Override
    public JavaSource toJavaSource() {
        List<JavaFragment> header = this.getHeaderFragments();
        if (this.getParent() instanceof ClassElement) {
            header.add(0, this.f(this.frame, "abstract "));
        }
        JavaSource javaSource = new JavaSource(null, header);
        javaSource.prependJavadoc(this.documentation.getJavaCode());
        return javaSource;
    }

    private List<JavaFragment> getHeaderFragments() {
        ArrayList<JavaFragment> header = new ArrayList<JavaFragment>();
        Collections.addAll(header, this.returnType, this.space(), this.name, this.f(this.frame, "("));
        ParamFragment.addParamsToHeader(this.frame, this, this.params, header);
        header.add(this.f(this.frame, ")"));
        header.addAll(this.throwsToJava());
        header.add(this.f(this.frame, ";"));
        return header;
    }

    private List<JavaFragment> throwsToJava() {
        if (this.throwsTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Supplier<JavaFragment>> typesAndCommas = this.throwsTypes.stream().map(ThrowsTypeFragment::getJavaSource).collect(Utility.intersperse(() -> this.f(null, ", ")));
        typesAndCommas.add(0, (Supplier<JavaFragment>)((Object)this.space()));
        typesAndCommas.add(0, (Supplier<JavaFragment>)((Object)this.f(this.frame, "throws")));
        typesAndCommas.add(0, (Supplier<JavaFragment>)((Object)this.space()));
        return typesAndCommas;
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new MethodProtoFrame(editor, this.returnType, this.name, this.params, this.throwsTypes, this.documentation.toString(), this.isEnable());
        return this.frame;
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement methodEl = new LocatableElement(this, ELEMENT);
        methodEl.addAttributeStructured("type", this.returnType);
        methodEl.addAttributeCode("name", this.name);
        this.addEnableAttribute(methodEl);
        methodEl.appendChild((Node)this.documentation.toXML());
        this.params.forEach(param -> methodEl.appendChild((Node)param.toXML()));
        Element throwsEl = new Element("throws");
        for (ThrowsTypeFragment t : this.throwsTypes) {
            throwsEl.appendChild((Node)t.toXML());
        }
        methodEl.appendChild((Node)throwsEl);
        return methodEl;
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return Collections.emptyList();
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return Stream.empty();
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.concat(Stream.of(this.returnType, this.name), this.params.stream().flatMap(p -> Stream.of(p.getParamType(), p.getParamName())));
    }
}

