/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.editor.fixes.Correction;
import bluej.editor.stride.FrameEditor;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.StructuredSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.EmptyError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UnknownTypeError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TypeSlotFragment
extends StructuredSlotFragment {
    private TypeSlot slot;
    private boolean hasEarlyErrors;

    public TypeSlotFragment(String content, String javaCode, TypeSlot slot) {
        super(content, javaCode);
        this.slot = slot;
    }

    public TypeSlotFragment(String content, String javaCode) {
        this(content, javaCode, null);
    }

    @Override
    public Map<String, CodeElement> getVars() {
        return Collections.emptyMap();
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
        if (!dest.substitute() || this.content != null && Parser.parseableAsType(this.content)) {
            return this.content;
        }
        return dummyNameGenerator.generateNewDummyName();
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        this.hasEarlyErrors = true;
        if (this.content != null && this.content.isEmpty()) {
            return Stream.of(new EmptyError((SlotFragment)this, "Type cannot be empty"));
        }
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> this.getSlot().setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content == null || !Parser.parseableAsType(this.content)) {
            return Stream.of(new SyntaxCodeError((SlotFragment)this, "Invalid type"));
        }
        this.hasEarlyErrors = false;
        return Stream.empty();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Future<List<DirectSlotError>> findLateErrors(InteractionManager editor, CodeElement parent, LocatableElement.LocationMap rootPathMap) {
        CompletableFuture<List<DirectSlotError>> f = new CompletableFuture<List<DirectSlotError>>();
        ArrayList<Integer> indexOfErrors = new ArrayList<Integer>();
        ArrayList<String> typesList = new ArrayList<String>();
        if (this.hasEarlyErrors) {
            f.complete(Collections.emptyList());
            return f;
        }
        if (this.content.contains("<") && this.content.contains(">") || this.content.contains("[") && this.content.contains("]")) {
            String modifiedContent = this.content.replaceAll("[<>\\]\\[]", ",");
            int index = 0;
            while (!modifiedContent.equals("")) {
                String type = modifiedContent.substring(0, modifiedContent.indexOf(","));
                if (!type.equals("")) {
                    indexOfErrors.add(index);
                    typesList.add(type);
                }
                index = index + type.length() + 1;
                if ((modifiedContent = modifiedContent.substring(modifiedContent.indexOf(",") + 1)).contains(",") || modifiedContent.equals("")) continue;
                indexOfErrors.add(index);
                typesList.add(modifiedContent);
                break;
            }
            return this.checkForTypeErrors(typesList, indexOfErrors, editor, rootPathMap);
        }
        if (this.content.contains("[") || this.content.contains("<") || this.content.contains(".")) {
            f.complete(Collections.emptyList());
            return f;
        }
        FrameEditor frameEditor = editor.getFrameEditor();
        editor.withTypes(types -> {
            if (types.containsKey(this.content)) {
                f.complete(Collections.emptyList());
                return;
            }
            FXPlatformConsumer<Correction.CorrectionElements> replacer = correctionElements -> {
                String correctionType = correctionElements.getPrimaryElement();
                String correctionPackage = correctionElements.getSecondaryElements().length > 0 ? correctionElements.getSecondaryElements()[0] : "";
                this.slot.setText(correctionType);
                String fullTypeName = (String)(correctionPackage.length() > 0 ? correctionPackage + "." : "") + (correctionType.contains(".") ? correctionType.substring(0, correctionType.lastIndexOf(".")) : correctionType);
                if (correctionPackage.length() > 0 && !editor.getFrameEditor().containsImport(fullTypeName) && !editor.getFrameEditor().containsImport(correctionPackage + ".*")) {
                    editor.getFrameEditor().addImportFromQuickFix(fullTypeName);
                }
            };
            UnknownTypeError error = new UnknownTypeError(this, this.content, replacer, editor, types.values().stream(), frameEditor.getEditorFixesManager().getImportSuggestions().values().stream().flatMap(Collection::stream)){};
            error.recordPath(rootPathMap.locationFor(this));
            f.complete(Arrays.asList(error));
        });
        return f;
    }

    @OnThread(value=Tag.FXPlatform)
    private Future<List<DirectSlotError>> checkForTypeErrors(ArrayList<String> typesList, ArrayList<Integer> indexList, InteractionManager editor, LocatableElement.LocationMap rootPathMap) {
        CompletableFuture<List<DirectSlotError>> f = new CompletableFuture<List<DirectSlotError>>();
        ArrayList listOfErrors = new ArrayList();
        FrameEditor frameEditor = editor.getFrameEditor();
        editor.withTypes(types -> {
            int i = 0;
            for (String t : typesList) {
                if (types.containsKey(t)) {
                    ++i;
                    continue;
                }
                int startPosInSlot = (Integer)indexList.get(i);
                int endPosInSlot = startPosInSlot + t.length();
                FXPlatformConsumer<Correction.CorrectionElements> replace = correctionElements -> this.slot.replace(startPosInSlot, endPosInSlot, false, correctionElements.getPrimaryElement());
                UnknownTypeError error = new UnknownTypeError(this, t, replace, editor, types.values().stream(), frameEditor.getEditorFixesManager().getImportSuggestions().values().stream().flatMap(Collection::stream));
                error.recordPath(rootPathMap.locationFor(this));
                listOfErrors.add(error);
                ++i;
            }
            f.complete(listOfErrors);
        });
        return f;
    }

    @Override
    public TypeSlot getSlot() {
        return this.slot;
    }

    public void registerSlot(TypeSlot slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }
}

