/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.actions.ClassTargetOperation;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ClassRole {
    public static final String CLASS_ROLE_NAME = null;

    @OnThread(value=Tag.Any)
    public String getRoleName() {
        return CLASS_ROLE_NAME;
    }

    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, int modifiers, String prefix) {
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
    }

    @OnThread(value=Tag.Any)
    public String getStereotypeLabel() {
        return null;
    }

    public boolean generateSkeleton(String template, Package pkg, String name, String sourceFile) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("CLASSNAME", name);
        if (pkg.isUnnamedPackage()) {
            translations.put("PKGLINE", "");
        } else {
            translations.put("PKGLINE", "package " + pkg.getQualifiedName() + ";" + Config.nl + Config.nl);
        }
        translations.put("PKGNAME", pkg.getQualifiedName());
        try {
            File dest = new File(sourceFile);
            if (dest.exists()) {
                pkg.showError("duplicate-name");
                return false;
            }
            BlueJFileReader.translateFile(Config.getClassTemplateFile(template), new File(sourceFile), translations, Charset.forName("UTF-8"), pkg.getProject().getProjectCharset());
            return true;
        }
        catch (IOException e) {
            pkg.showError("skeleton-error");
            Debug.reportError("The default skeleton for the class could not be generated");
            Debug.reportError("Exception: " + e);
            return false;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getRoleOperationsBegin(ClassTarget ct, Class<?> cl, DependentTarget.State state) {
        return List.of();
    }

    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getRoleOperationsEnd(ClassTarget ct, DependentTarget.State state) {
        return List.of();
    }

    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getClassConstructorOperations(ClassTarget ct, Class<?> cl) {
        View view = View.getView(cl);
        if (!Modifier.isAbstract(cl.getModifiers())) {
            ViewFilter filter = new ViewFilter(ViewFilter.StaticOrInstance.INSTANCE, ct.getPackage().getQualifiedName());
            CallableView[] constructors = view.getConstructors();
            return ClassRole.createMenuItems(constructors, filter, 0, constructors.length, "new ", ct);
        }
        return List.of();
    }

    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getClassStaticOperations(ClassTarget ct, Class<?> cl) {
        View view = View.getView(cl);
        ViewFilter filter = new ViewFilter(ViewFilter.StaticOrInstance.STATIC, ct.getPackage().getQualifiedName());
        CallableView[] allMethods = view.getAllMethods();
        return ClassRole.createMenuItems(allMethods, filter, 0, allMethods.length, "", ct);
    }

    @OnThread(value=Tag.FXPlatform)
    private static List<ClassTargetOperation> createMenuItems(CallableView[] members, ViewFilter filter, int first, int last, String prefix, InvokeListener il) {
        int itemHeight = 28;
        int itemsOnScreen = (int)Config.getScreenBounds().getHeight() / itemHeight;
        int sizeLimit = itemsOnScreen / 2;
        ArrayList<ClassTargetOperation> ops = new ArrayList<ClassTargetOperation>();
        for (int i = first; i < last; ++i) {
            try {
                CallableView m = members[last - i - 1];
                if (!filter.test(m)) continue;
                if (m instanceof MethodView) {
                    ops.add(new ExecuteMethodAction(prefix + m.getLongDesc(), il, (MethodView)m));
                    continue;
                }
                if (!(m instanceof ConstructorView)) continue;
                ops.add(new CallConstructorAction(prefix + m.getLongDesc(), il, (ConstructorView)m));
                continue;
            }
            catch (Exception e) {
                Debug.reportError("Exception accessing methods: " + e);
                e.printStackTrace();
            }
        }
        return ops;
    }

    public void run(PkgMgrFrame pmf, ClassTarget ct, String param) {
    }

    public List<File> getAllFiles(ClassTarget ct) {
        ArrayList<File> rlist = new ArrayList<File>();
        rlist.add(ct.getClassFile());
        rlist.addAll(Utility.mapList(ct.getAllSourceFilesJavaLast(), sf -> sf.file));
        rlist.add(ct.getContextFile());
        rlist.add(ct.getDocumentationFile());
        File[] innerClasses = ct.getInnerClassFiles();
        Collections.addAll(rlist, innerClasses);
        return rlist;
    }

    @OnThread(value=Tag.Any)
    public abstract boolean canConvertToStride();

    private static class ExecuteMethodAction
    extends ClassTargetOperation {
        private final InvokeListener il;
        private final MethodView m;

        public ExecuteMethodAction(String label, InvokeListener il, MethodView m) {
            super(label, AbstractOperation.Combine.ONE, null, label, AbstractOperation.MenuItemOrder.RUN_METHOD, new String[0]);
            this.il = il;
            this.m = m;
        }

        @Override
        protected void execute(ClassTarget target) {
            this.il.executeMethod(this.m);
        }
    }

    private static class CallConstructorAction
    extends ClassTargetOperation {
        private final InvokeListener il;
        private final ConstructorView c;

        public CallConstructorAction(String label, InvokeListener il, ConstructorView c) {
            super(label, AbstractOperation.Combine.ONE, null, label, AbstractOperation.MenuItemOrder.RUN_CONSTRUCTOR, new String[0]);
            this.il = il;
            this.c = c;
        }

        @Override
        protected void execute(ClassTarget target) {
            this.il.callConstructor(this.c);
        }
    }
}

