/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ImportMismatchDialog
extends Dialog<Boolean> {
    private static final String dialogTitle = Config.getString("pkgmgr.importmismatch.title");
    private final ButtonType CONTINUE;

    public ImportMismatchDialog(Window parent, List<File> files) {
        this.initOwner(parent);
        this.setTitle(dialogTitle);
        this.initModality(Modality.WINDOW_MODAL);
        Config.addDialogStylesheets((Pane)this.getDialogPane());
        this.setResizable(true);
        VBox mainPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPanel, "import-mismatch-content");
        mainPanel.getChildren().add((Object)new Label(Config.getStringList("pkgmgr.importmismatch.helpLine").stream().collect(Collectors.joining(" "))));
        mainPanel.getChildren().add((Object)new ScrollPane((Node)new VBox(Utility.mapList(files, f -> new Label(f.toString())).toArray(new Node[0]))));
        this.CONTINUE = new ButtonType(BlueJTheme.getContinueLabel(), ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, this.CONTINUE});
        this.setResultConverter(bt -> bt == this.CONTINUE);
        this.getDialogPane().setContent((Node)mainPanel);
    }
}

