/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.ui.TeamSettingsPanel;
import bluej.utility.DialogManager;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TeamSettingsDialog
extends FXCustomizedDialog<TeamSettings> {
    private TeamSettingsController teamSettingsController;
    private TeamSettingsPanel teamSettingsPanel;
    private Button okButton;

    public TeamSettingsDialog(Window owner, TeamSettingsController controller, boolean isShareAction) {
        super(owner, "team.settings.title", "team-settings");
        this.setResizable(false);
        this.teamSettingsController = controller;
        if (this.teamSettingsController.hasProject()) {
            this.setTitle(this.getTitle() + " - " + this.teamSettingsController.getProject().getProjectName());
        }
        this.setHeaderText(null);
        this.prepareButtonPane();
        this.teamSettingsPanel = new TeamSettingsPanel(this.teamSettingsController, this, isShareAction);
        this.getDialogPane().setContent((Node)this.teamSettingsPanel);
        DialogManager.centreDialog(this);
        this.setOnShown(e -> JavaFXUtil.runAfterCurrent(() -> this.teamSettingsPanel.doRequestFocus()));
        this.setResultConverter(bt -> bt == ButtonType.OK ? this.getSettings() : null);
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        this.okButton.setOnAction(event -> {
            TeamSettings settings = this.teamSettingsPanel.getSettings();
            this.teamSettingsController.updateSettings(settings);
            if (this.teamSettingsController.hasProject()) {
                this.teamSettingsController.writeToProject();
            }
        });
    }

    public void disableRepositorySettings() {
        this.teamSettingsPanel.disableRepositorySettings();
    }

    public TeamSettings getSettings() {
        return this.teamSettingsPanel.getSettings();
    }

    public Button getOkButton() {
        return this.okButton;
    }
}

