/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.pkgmgr.target.Target;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class SelectionSet {
    private Set<Target> elements = new HashSet<Target>();
    private List<FXPlatformConsumer<Collection<Target>>> listeners = new ArrayList<FXPlatformConsumer<Collection<Target>>>();

    @OnThread(value=Tag.Any)
    public SelectionSet(Collection<Target> initial) {
        this.elements.addAll(initial);
    }

    public void add(Target element) {
        if (!element.isSelected()) {
            element.setSelected(true);
            this.elements.add(element);
            this.notifyListeners();
        }
    }

    public void addAll(Collection<Target> newSet) {
        for (Target t : newSet) {
            this.add(t);
        }
    }

    public void remove(Target element) {
        if (element != null) {
            element.setSelected(false);
            this.elements.remove(element);
            this.notifyListeners();
        }
    }

    public void clear() {
        for (Target element : this.elements) {
            element.setSelected(false);
        }
        this.elements.clear();
        this.notifyListeners();
    }

    public void doubleClick(boolean openInNewWindow) {
        for (Target element : this.elements) {
            element.doubleClick(openInNewWindow);
        }
    }

    public void moveStopped() {
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void selectOnly(Target element) {
        this.clear();
        this.add(element);
    }

    public Target getAnyVertex() {
        Iterator<Target> iterator = this.elements.iterator();
        if (iterator.hasNext()) {
            Target element = iterator.next();
            return element;
        }
        return null;
    }

    public List<Target> getSelected() {
        return new ArrayList<Target>(this.elements);
    }

    private void notifyListeners() {
        ArrayList<Target> curSelection = new ArrayList<Target>(this.elements);
        for (FXPlatformConsumer<Collection<Target>> listener : this.listeners) {
            listener.accept(curSelection);
        }
    }

    public void addListener(FXPlatformConsumer<Collection<Target>> listener) {
        this.listeners.add(listener);
    }
}

